/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import com.thirdparty.bumptech.glide.DrawableRequestBuilder;
import com.thirdparty.bumptech.glide.DrawableTypeRequest;
import com.thirdparty.bumptech.glide.Glide;
import com.thirdparty.bumptech.glide.RequestManager$1;
import com.thirdparty.bumptech.glide.RequestManager$DefaultOptions;
import com.thirdparty.bumptech.glide.RequestManager$GenericModelRequest;
import com.thirdparty.bumptech.glide.RequestManager$ImageModelRequest;
import com.thirdparty.bumptech.glide.RequestManager$OptionsApplier;
import com.thirdparty.bumptech.glide.RequestManager$RequestManagerConnectivityListener;
import com.thirdparty.bumptech.glide.RequestManager$VideoModelRequest;
import com.thirdparty.bumptech.glide.load.engine.DiskCacheStrategy;
import com.thirdparty.bumptech.glide.load.model.ModelLoader;
import com.thirdparty.bumptech.glide.load.model.file_descriptor.FileDescriptorModelLoader;
import com.thirdparty.bumptech.glide.load.model.stream.MediaStoreStreamLoader;
import com.thirdparty.bumptech.glide.load.model.stream.StreamByteArrayLoader;
import com.thirdparty.bumptech.glide.load.model.stream.StreamModelLoader;
import com.thirdparty.bumptech.glide.manager.ConnectivityMonitor;
import com.thirdparty.bumptech.glide.manager.ConnectivityMonitorFactory;
import com.thirdparty.bumptech.glide.manager.Lifecycle;
import com.thirdparty.bumptech.glide.manager.LifecycleListener;
import com.thirdparty.bumptech.glide.manager.RequestManagerTreeNode;
import com.thirdparty.bumptech.glide.manager.RequestTracker;
import com.thirdparty.bumptech.glide.signature.ApplicationVersionSignature;
import com.thirdparty.bumptech.glide.signature.MediaStoreSignature;
import com.thirdparty.bumptech.glide.signature.StringSignature;
import com.thirdparty.bumptech.glide.util.Util;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.UUID;

public class RequestManager
implements LifecycleListener {
    private final Context context;
    private final Lifecycle lifecycle;
    private final RequestManagerTreeNode treeNode;
    private final RequestTracker requestTracker;
    private final Glide glide;
    private final RequestManager$OptionsApplier optionsApplier;
    private RequestManager$DefaultOptions options;

    /*
     * WARNING - void declaration
     */
    public RequestManager(Context context, Lifecycle lifecycle, RequestManagerTreeNode treeNode) {
        this((Context)var1_1, (Lifecycle)var2_2, (RequestManagerTreeNode)var3_3, new RequestTracker(), new ConnectivityMonitorFactory());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    RequestManager(Context context, Lifecycle lifecycle, RequestManagerTreeNode treeNode, RequestTracker requestTracker, ConnectivityMonitorFactory factory) {
        void var2_2;
        ConnectivityMonitor connectivityMonitor;
        void var3_3;
        this.context = context.getApplicationContext();
        this.lifecycle = lifecycle;
        this.treeNode = var3_3;
        this.requestTracker = requestTracker;
        this.glide = Glide.get(context);
        this.optionsApplier = new RequestManager$OptionsApplier(this);
        connectivityMonitor = factory.build((Context)connectivityMonitor, new RequestManager$RequestManagerConnectivityListener(requestTracker));
        if (Util.isOnBackgroundThread()) {
            new Handler(Looper.getMainLooper()).post((Runnable)new RequestManager$1(this, lifecycle));
        } else {
            lifecycle.addListener(this);
        }
        var2_2.addListener(connectivityMonitor);
    }

    /*
     * WARNING - void declaration
     */
    public void onTrimMemory(int level) {
        void var1_1;
        this.glide.trimMemory((int)var1_1);
    }

    public void onLowMemory() {
        this.glide.clearMemory();
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultOptions(RequestManager$DefaultOptions options) {
        void var1_1;
        this.options = var1_1;
    }

    public boolean isPaused() {
        Util.assertMainThread();
        return this.requestTracker.isPaused();
    }

    public void pauseRequests() {
        Util.assertMainThread();
        this.requestTracker.pauseRequests();
    }

    public void pauseRequestsRecursive() {
        Util.assertMainThread();
        this.pauseRequests();
        Iterator<RequestManager> iterator = this.treeNode.getDescendants().iterator();
        while (iterator.hasNext()) {
            iterator.next().pauseRequests();
        }
    }

    public void resumeRequests() {
        Util.assertMainThread();
        this.requestTracker.resumeRequests();
    }

    public void resumeRequestsRecursive() {
        Util.assertMainThread();
        this.resumeRequests();
        Iterator<RequestManager> iterator = this.treeNode.getDescendants().iterator();
        while (iterator.hasNext()) {
            iterator.next().resumeRequests();
        }
    }

    @Override
    public void onStart() {
        this.resumeRequests();
    }

    @Override
    public void onStop() {
        this.pauseRequests();
    }

    @Override
    public void onDestroy() {
        this.requestTracker.clearRequests();
    }

    /*
     * WARNING - void declaration
     */
    public <A, T> RequestManager$GenericModelRequest<A, T> using(ModelLoader<A, T> modelLoader, Class<T> dataClass) {
        void var2_2;
        void var1_1;
        return new RequestManager$GenericModelRequest(this, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public <T> RequestManager$ImageModelRequest<T> using(StreamModelLoader<T> modelLoader) {
        void var1_1;
        return new RequestManager$ImageModelRequest(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public RequestManager$ImageModelRequest<byte[]> using(StreamByteArrayLoader modelLoader) {
        void var1_1;
        return new RequestManager$ImageModelRequest<byte[]>(this, (ModelLoader<byte[], InputStream>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> RequestManager$VideoModelRequest<T> using(FileDescriptorModelLoader<T> modelLoader) {
        void var1_1;
        return new RequestManager$VideoModelRequest(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public DrawableTypeRequest<String> load(String string) {
        void var1_1;
        return (DrawableTypeRequest)this.fromString().load(var1_1);
    }

    public DrawableTypeRequest<String> fromString() {
        return this.loadGeneric(String.class);
    }

    /*
     * WARNING - void declaration
     */
    public DrawableTypeRequest<Uri> load(Uri uri) {
        void var1_1;
        return (DrawableTypeRequest)this.fromUri().load(var1_1);
    }

    public DrawableTypeRequest<Uri> fromUri() {
        return this.loadGeneric(Uri.class);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DrawableTypeRequest<Uri> loadFromMediaStore(Uri uri, String mimeType, long dateModified, int orientation) {
        void var1_1;
        void var3_3;
        MediaStoreSignature mediaStoreSignature;
        mediaStoreSignature = new MediaStoreSignature((String)((Object)mediaStoreSignature), (long)var3_3, orientation);
        return (DrawableTypeRequest)this.loadFromMediaStore((Uri)var1_1).signature(mediaStoreSignature);
    }

    /*
     * WARNING - void declaration
     */
    public DrawableTypeRequest<Uri> loadFromMediaStore(Uri uri) {
        void var1_1;
        return (DrawableTypeRequest)this.fromMediaStore().load(var1_1);
    }

    public DrawableTypeRequest<Uri> fromMediaStore() {
        MediaStoreStreamLoader mediaStoreStreamLoader = Glide.buildStreamModelLoader(Uri.class, this.context);
        mediaStoreStreamLoader = new MediaStoreStreamLoader(this.context, mediaStoreStreamLoader);
        ModelLoader<Class<Uri>, ParcelFileDescriptor> modelLoader = Glide.buildFileDescriptorModelLoader(Uri.class, this.context);
        return this.optionsApplier.apply(new DrawableTypeRequest<Class<Uri>>(Uri.class, mediaStoreStreamLoader, modelLoader, this.context, this.glide, this.requestTracker, this.lifecycle, this.optionsApplier));
    }

    /*
     * WARNING - void declaration
     */
    public DrawableTypeRequest<File> load(File file) {
        void var1_1;
        return (DrawableTypeRequest)this.fromFile().load(var1_1);
    }

    public DrawableTypeRequest<File> fromFile() {
        return this.loadGeneric(File.class);
    }

    /*
     * WARNING - void declaration
     */
    public DrawableTypeRequest<Integer> load(Integer resourceId) {
        void var1_1;
        return (DrawableTypeRequest)this.fromResource().load(var1_1);
    }

    public DrawableTypeRequest<Integer> fromResource() {
        return (DrawableTypeRequest)this.loadGeneric(Integer.class).signature(ApplicationVersionSignature.obtain(this.context));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DrawableTypeRequest<URL> load(URL url) {
        void var1_1;
        return (DrawableTypeRequest)this.fromUrl().load(var1_1);
    }

    @Deprecated
    public DrawableTypeRequest<URL> fromUrl() {
        return this.loadGeneric(URL.class);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DrawableTypeRequest<byte[]> load(byte[] model, String id) {
        void var2_2;
        void var1_1;
        return (DrawableTypeRequest)this.load(var1_1).signature(new StringSignature((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public DrawableTypeRequest<byte[]> load(byte[] model) {
        void var1_1;
        return (DrawableTypeRequest)this.fromBytes().load(var1_1);
    }

    public DrawableTypeRequest<byte[]> fromBytes() {
        return (DrawableTypeRequest)((DrawableRequestBuilder)((DrawableRequestBuilder)this.loadGeneric(byte[].class).signature(new StringSignature(UUID.randomUUID().toString()))).diskCacheStrategy(DiskCacheStrategy.NONE)).skipMemoryCache(true);
    }

    /*
     * WARNING - void declaration
     */
    public <T> DrawableTypeRequest<T> load(T model) {
        void var1_1;
        return (DrawableTypeRequest)this.loadGeneric(RequestManager.getSafeClass(model)).load((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> DrawableTypeRequest<T> from(Class<T> modelClass) {
        void var1_1;
        return this.loadGeneric((Class<T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private <T> DrawableTypeRequest<T> loadGeneric(Class<T> modelClass) {
        void var1_1;
        ModelLoader<Class<T>, InputStream> modelLoader = Glide.buildStreamModelLoader(modelClass, this.context);
        ModelLoader<Class<T>, ParcelFileDescriptor> modelLoader2 = Glide.buildFileDescriptorModelLoader(modelClass, this.context);
        if (modelClass != null && modelLoader == null && modelLoader2 == null) {
            throw new IllegalArgumentException("Unknown type " + modelClass + ". You must provide a Model of a type for which there is a registered ModelLoader, if you are using a custom model, you must first call Glide#register with a ModelLoaderFactory for your custom model class");
        }
        return this.optionsApplier.apply(new DrawableTypeRequest<Class<T>>(var1_1, modelLoader, modelLoader2, this.context, this.glide, this.requestTracker, this.lifecycle, this.optionsApplier));
    }

    private static <T> Class<T> getSafeClass(T model) {
        if (model != null) {
            T t2;
            return t2.getClass();
        }
        return null;
    }

    static /* synthetic */ RequestManager$OptionsApplier access$0(RequestManager requestManager) {
        return requestManager.optionsApplier;
    }

    static /* synthetic */ Class access$1(Object object) {
        return RequestManager.getSafeClass(object);
    }

    static /* synthetic */ Context access$2(RequestManager requestManager) {
        return requestManager.context;
    }

    static /* synthetic */ Glide access$3(RequestManager requestManager) {
        return requestManager.glide;
    }

    static /* synthetic */ RequestTracker access$4(RequestManager requestManager) {
        return requestManager.requestTracker;
    }

    static /* synthetic */ Lifecycle access$5(RequestManager requestManager) {
        return requestManager.lifecycle;
    }

    static /* synthetic */ RequestManager$DefaultOptions access$6(RequestManager requestManager) {
        return requestManager.options;
    }
}

