/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.ParcelFileDescriptor;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.thirdparty.bumptech.glide.BitmapOptions;
import com.thirdparty.bumptech.glide.GenericRequestBuilder;
import com.thirdparty.bumptech.glide.Priority;
import com.thirdparty.bumptech.glide.load.DecodeFormat;
import com.thirdparty.bumptech.glide.load.Encoder;
import com.thirdparty.bumptech.glide.load.Key;
import com.thirdparty.bumptech.glide.load.ResourceDecoder;
import com.thirdparty.bumptech.glide.load.ResourceEncoder;
import com.thirdparty.bumptech.glide.load.Transformation;
import com.thirdparty.bumptech.glide.load.engine.DiskCacheStrategy;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.model.ImageVideoWrapper;
import com.thirdparty.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.thirdparty.bumptech.glide.load.resource.bitmap.Downsampler;
import com.thirdparty.bumptech.glide.load.resource.bitmap.FileDescriptorBitmapDecoder;
import com.thirdparty.bumptech.glide.load.resource.bitmap.ImageVideoBitmapDecoder;
import com.thirdparty.bumptech.glide.load.resource.bitmap.StreamBitmapDecoder;
import com.thirdparty.bumptech.glide.load.resource.bitmap.VideoBitmapDecoder;
import com.thirdparty.bumptech.glide.load.resource.file.FileToStreamDecoder;
import com.thirdparty.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.thirdparty.bumptech.glide.provider.LoadProvider;
import com.thirdparty.bumptech.glide.request.RequestListener;
import com.thirdparty.bumptech.glide.request.animation.ViewPropertyAnimation$Animator;
import com.thirdparty.bumptech.glide.request.target.Target;
import java.io.File;
import java.io.InputStream;

public class BitmapRequestBuilder<ModelType, TranscodeType>
extends GenericRequestBuilder<ModelType, ImageVideoWrapper, Bitmap, TranscodeType>
implements BitmapOptions {
    private final BitmapPool bitmapPool;
    private Downsampler downsampler = Downsampler.AT_LEAST;
    private DecodeFormat decodeFormat;
    private ResourceDecoder<InputStream, Bitmap> imageDecoder;
    private ResourceDecoder<ParcelFileDescriptor, Bitmap> videoDecoder;

    /*
     * WARNING - void declaration
     */
    BitmapRequestBuilder(LoadProvider<ModelType, ImageVideoWrapper, Bitmap, TranscodeType> loadProvider, Class<TranscodeType> transcodeClass, GenericRequestBuilder<ModelType, ?, ?, ?> other) {
        super(var1_1, var2_2, other);
        void var3_3;
        void var2_2;
        void var1_1;
        this.bitmapPool = other.glide.getBitmapPool();
        this.decodeFormat = var3_3.glide.getDecodeFormat();
        this.imageDecoder = new StreamBitmapDecoder(this.bitmapPool, this.decodeFormat);
        this.videoDecoder = new FileDescriptorBitmapDecoder(this.bitmapPool, this.decodeFormat);
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> approximate() {
        return this.downsample(Downsampler.AT_LEAST);
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> asIs() {
        return this.downsample(Downsampler.NONE);
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> atMost() {
        return this.downsample(Downsampler.AT_MOST);
    }

    /*
     * WARNING - void declaration
     */
    private BitmapRequestBuilder<ModelType, TranscodeType> downsample(Downsampler downsampler) {
        void var1_1;
        this.downsampler = downsampler;
        this.imageDecoder = new StreamBitmapDecoder((Downsampler)var1_1, this.bitmapPool, this.decodeFormat);
        super.decoder(new ImageVideoBitmapDecoder(this.imageDecoder, this.videoDecoder));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> thumbnail(float sizeMultiplier) {
        void var1_1;
        super.thumbnail((float)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> thumbnail(BitmapRequestBuilder<?, TranscodeType> thumbnailRequest) {
        void var1_1;
        super.thumbnail(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> sizeMultiplier(float sizeMultiplier) {
        void var1_1;
        super.sizeMultiplier((float)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> decoder(ResourceDecoder<ImageVideoWrapper, Bitmap> decoder) {
        void var1_1;
        super.decoder(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> cacheDecoder(ResourceDecoder<File, Bitmap> cacheDecoder) {
        void var1_1;
        super.cacheDecoder(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> encoder(ResourceEncoder<Bitmap> encoder) {
        void var1_1;
        super.encoder(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> imageDecoder(ResourceDecoder<InputStream, Bitmap> decoder) {
        void var1_1;
        this.imageDecoder = decoder;
        super.decoder(new ImageVideoBitmapDecoder((ResourceDecoder<InputStream, Bitmap>)var1_1, this.videoDecoder));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> videoDecoder(ResourceDecoder<ParcelFileDescriptor, Bitmap> decoder) {
        void var1_1;
        this.videoDecoder = decoder;
        super.decoder(new ImageVideoBitmapDecoder(this.imageDecoder, (ResourceDecoder<ParcelFileDescriptor, Bitmap>)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> format(DecodeFormat format) {
        void var1_1;
        this.decodeFormat = format;
        this.imageDecoder = new StreamBitmapDecoder(this.downsampler, this.bitmapPool, format);
        this.videoDecoder = new FileDescriptorBitmapDecoder(new VideoBitmapDecoder(), this.bitmapPool, format);
        super.cacheDecoder(new FileToStreamDecoder<Bitmap>(new StreamBitmapDecoder(this.downsampler, this.bitmapPool, (DecodeFormat)var1_1)));
        super.decoder(new ImageVideoBitmapDecoder(this.imageDecoder, this.videoDecoder));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> priority(Priority priority) {
        void var1_1;
        super.priority((Priority)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> transform(BitmapTransformation ... transformations) {
        void var1_1;
        super.transform(var1_1);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> centerCrop() {
        return this.transform(new BitmapTransformation[]{this.glide.getBitmapCenterCrop()});
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> fitCenter() {
        return this.transform(new BitmapTransformation[]{this.glide.getBitmapFitCenter()});
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> transform(Transformation<Bitmap> ... transformations) {
        void var1_1;
        super.transform(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> transcoder(ResourceTranscoder<Bitmap, TranscodeType> transcoder) {
        void var1_1;
        super.transcoder(var1_1);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> dontAnimate() {
        super.dontAnimate();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> animate(int animationId) {
        void var1_1;
        super.animate((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public BitmapRequestBuilder<ModelType, TranscodeType> animate(Animation animation) {
        void var1_1;
        super.animate((Animation)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> animate(ViewPropertyAnimation$Animator animator) {
        void var1_1;
        super.animate((ViewPropertyAnimation$Animator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> placeholder(int resourceId) {
        void var1_1;
        super.placeholder((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> placeholder(Drawable drawable) {
        void var1_1;
        super.placeholder((Drawable)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> fallback(Drawable drawable) {
        void var1_1;
        super.fallback((Drawable)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> fallback(int resourceId) {
        void var1_1;
        super.fallback((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> error(int resourceId) {
        void var1_1;
        super.error((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> error(Drawable drawable) {
        void var1_1;
        super.error((Drawable)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> listener(RequestListener<? super ModelType, TranscodeType> requestListener) {
        void var1_1;
        super.listener(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> skipMemoryCache(boolean skip) {
        void var1_1;
        super.skipMemoryCache((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> diskCacheStrategy(DiskCacheStrategy strategy) {
        void var1_1;
        super.diskCacheStrategy((DiskCacheStrategy)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> override(int width, int height) {
        void var2_2;
        void var1_1;
        super.override((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> thumbnail(GenericRequestBuilder<?, ?, ?, TranscodeType> thumbnailRequest) {
        void var1_1;
        super.thumbnail(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> sourceEncoder(Encoder<ImageVideoWrapper> sourceEncoder) {
        void var1_1;
        super.sourceEncoder(var1_1);
        return this;
    }

    public BitmapRequestBuilder<ModelType, TranscodeType> dontTransform() {
        super.dontTransform();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> signature(Key signature) {
        void var1_1;
        super.signature((Key)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapRequestBuilder<ModelType, TranscodeType> load(ModelType model) {
        void var1_1;
        super.load(var1_1);
        return this;
    }

    @Override
    public BitmapRequestBuilder<ModelType, TranscodeType> clone() {
        return (BitmapRequestBuilder)super.clone();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Target<TranscodeType> into(ImageView view) {
        void var1_1;
        return super.into((ImageView)var1_1);
    }

    @Override
    void applyFitCenter() {
        this.fitCenter();
    }

    @Override
    void applyCenterCrop() {
        this.centerCrop();
    }
}

