/*
 * Decompiled with CFR 0.152.
 */
package com.melink.baseframe.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public class RoundImageView
extends ImageView {
    private int mBorderThickness = 2;
    private int mBorderOutsideColor = 0;
    private int mBorderInsideColor = -1;
    private Bitmap currentBitmap;

    /*
     * WARNING - void declaration
     */
    public RoundImageView(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RoundImageView(Context context, AttributeSet attrs) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RoundImageView(Context context, AttributeSet attrs, int defStyle) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    private void initCurrentBitmap() {
        Bitmap bitmap = null;
        Drawable drawable = this.getDrawable();
        if (drawable instanceof BitmapDrawable) {
            bitmap = ((BitmapDrawable)drawable).getBitmap();
        }
        if (bitmap != null) {
            this.currentBitmap = bitmap;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(Canvas canvas) {
        void var1_1;
        int n2;
        this.initCurrentBitmap();
        if (this.currentBitmap == null || this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        this.measure(0, 0);
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (this.mBorderInsideColor != 0 && this.mBorderOutsideColor != 0) {
            n2 = (n3 < n4 ? n3 : n4) / 2 - 2 * this.mBorderThickness;
            this.drawCircleBorder(canvas, n2 + this.mBorderThickness / 2, n3, n4, this.mBorderInsideColor);
            this.drawCircleBorder(canvas, n2 + this.mBorderThickness + this.mBorderThickness / 2, n3, n4, this.mBorderOutsideColor);
        } else if (this.mBorderInsideColor != 0 && this.mBorderOutsideColor == 0) {
            n2 = (n3 < n4 ? n3 : n4) / 2 - this.mBorderThickness;
            this.drawCircleBorder(canvas, n2 + this.mBorderThickness / 2, n3, n4, this.mBorderInsideColor);
        } else if (this.mBorderInsideColor == 0 && this.mBorderOutsideColor != 0) {
            n2 = (n3 < n4 ? n3 : n4) / 2 - this.mBorderThickness;
            this.drawCircleBorder(canvas, n2 + this.mBorderThickness / 2, n3, n4, this.mBorderOutsideColor);
        } else {
            n2 = (n3 < n4 ? n3 : n4) / 2;
        }
        Bitmap bitmap = this.getCroppedRoundBitmap(this.currentBitmap, n2);
        var1_1.drawBitmap(bitmap, (float)(n3 / 2 - n2), (float)(n4 / 2 - n2), null);
    }

    public Bitmap getCroppedRoundBitmap(Bitmap bmp, int radius) {
        Bitmap bitmap;
        int n2 = radius * 2;
        int n3 = bmp.getWidth();
        int n4 = bmp.getHeight();
        int n5 = 0;
        if (n4 > n3) {
            n5 = (n4 - n3) / 2;
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)n5, (int)n3, (int)n3);
        } else if (n4 < n3) {
            n5 = (n3 - n4) / 2;
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)n5, (int)0, (int)n4, (int)n4);
        }
        if (bitmap.getWidth() != n2 || bitmap.getHeight() != n2) {
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n2, (boolean)true);
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle((float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), (float)(bitmap.getWidth() / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return bitmap2;
    }

    /*
     * WARNING - void declaration
     */
    private void drawCircleBorder(Canvas canvas, int radius, int w2, int h2, int color) {
        void var2_2;
        void var3_3;
        void var1_1;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        paint.setColor(color);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth((float)this.mBorderThickness);
        var1_1.drawCircle((float)(var3_3 / 2), (float)(h2 / 2), (float)var2_2, paint);
    }

    /*
     * WARNING - void declaration
     */
    public void setBitmapRes(Bitmap bitmap) {
        void var1_1;
        this.currentBitmap = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setImageBitmap(Bitmap bm) {
        void var1_1;
        super.setImageBitmap(bm);
        this.setBitmapRes((Bitmap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setImageResource(int resId) {
        void var1_1;
        super.setImageResource(resId);
        this.setBitmapRes(BitmapFactory.decodeResource((Resources)this.getResources(), (int)var1_1));
    }

    public int getBorderThickness() {
        return this.mBorderThickness;
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderThickness(int borderThickness) {
        void var1_1;
        this.mBorderThickness = var1_1;
    }

    public int getBorderOutsideColor() {
        return this.mBorderOutsideColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderOutsideColor(int borderOutsideColor) {
        void var1_1;
        this.mBorderOutsideColor = var1_1;
    }

    public int getBorderInsideColor() {
        return this.mBorderInsideColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderInsideColor(int borderInsideColor) {
        void var1_1;
        this.mBorderInsideColor = var1_1;
    }
}

