/*
 * Decompiled with CFR 0.152.
 */
package com.melink.baseframe.db;

import android.text.TextUtils;
import com.melink.baseframe.db.ManyToOneLazyLoader;
import com.melink.baseframe.db.SqlInfo;
import com.melink.baseframe.db.utils.Id;
import com.melink.baseframe.db.utils.KeyValue;
import com.melink.baseframe.db.utils.ManyToOne;
import com.melink.baseframe.db.utils.Property;
import com.melink.baseframe.db.utils.TableInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class SqlBuilder {
    public static SqlInfo buildInsertSql(Object entity) {
        List<KeyValue> list = SqlBuilder.getSaveKeyValueListByEntity(entity);
        StringBuffer stringBuffer = new StringBuffer();
        SqlInfo sqlInfo = null;
        if (list != null && list.size() > 0) {
            Object object2;
            sqlInfo = new SqlInfo();
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(TableInfo.get(object2.getClass()).getTableName());
            stringBuffer.append(" (");
            for (KeyValue keyValue : list) {
                stringBuffer.append(keyValue.getKey()).append(",");
                sqlInfo.addValue(keyValue.getValue());
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append(") VALUES ( ");
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append("?,");
                ++n3;
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append(")");
            sqlInfo.setSql(stringBuffer.toString());
        }
        return sqlInfo;
    }

    public static List<KeyValue> getSaveKeyValueListByEntity(Object entity) {
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        Object object = TableInfo.get(entity.getClass());
        Object object2 = ((TableInfo)object).getId().getValue(entity);
        if (!(object2 instanceof Integer) && object2 instanceof String && object2 != null) {
            object2 = new KeyValue(((TableInfo)object).getId().getColumn(), object2);
            arrayList.add((KeyValue)object2);
        }
        Iterator<Property> iterator = ((TableInfo)object).propertyMap.values().iterator();
        while (iterator.hasNext()) {
            object2 = SqlBuilder.property2KeyValue(iterator.next(), entity);
            if (object2 == null) continue;
            arrayList.add((KeyValue)object2);
        }
        object2 = ((TableInfo)object).manyToOneMap.values().iterator();
        while (object2.hasNext()) {
            object = SqlBuilder.manyToOne2KeyValue((ManyToOne)object2.next(), entity);
            if (object == null) continue;
            arrayList.add((KeyValue)object);
        }
        return arrayList;
    }

    private static String getDeleteSqlBytableName(String tableName) {
        String string;
        return "DELETE FROM " + string;
    }

    public static SqlInfo buildDeleteSql(Object entity) {
        Object object;
        Object object2 = TableInfo.get(entity.getClass());
        Id id = ((TableInfo)object2).getId();
        Object t2 = id.getValue(entity);
        if (t2 == null) {
            throw new RuntimeException("getDeleteSQL:" + object.getClass() + " id value is null");
        }
        object = new StringBuffer(SqlBuilder.getDeleteSqlBytableName(((TableInfo)object2).getTableName()));
        ((StringBuffer)object).append(" WHERE ").append(id.getColumn()).append("=?");
        object2 = new SqlInfo();
        ((SqlInfo)object2).setSql(((StringBuffer)object).toString());
        ((SqlInfo)object2).addValue(t2);
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    public static SqlInfo buildDeleteSql(Class<?> clazz, Object idValue) {
        void var1_1;
        Object object = TableInfo.get(clazz);
        Object object2 = ((TableInfo)object).getId();
        if (idValue == null) {
            throw new RuntimeException("getDeleteSQL:idValue is null");
        }
        object = new StringBuffer(SqlBuilder.getDeleteSqlBytableName(((TableInfo)object).getTableName()));
        ((StringBuffer)object).append(" WHERE ").append(((Property)object2).getColumn()).append("=?");
        object2 = new SqlInfo();
        ((SqlInfo)object2).setSql(((StringBuffer)object).toString());
        ((SqlInfo)object2).addValue(var1_1);
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    public static String buildDeleteSql(Class<?> clazz, String strWhere) {
        Object object = TableInfo.get(clazz);
        object = new StringBuffer(SqlBuilder.getDeleteSqlBytableName(((TableInfo)object).getTableName()));
        if (!TextUtils.isEmpty((CharSequence)strWhere)) {
            void var1_1;
            ((StringBuffer)object).append(" WHERE ");
            ((StringBuffer)object).append((String)var1_1);
        }
        return ((StringBuffer)object).toString();
    }

    private static String getSelectSqlByTableName(String tableName) {
        String string;
        return new StringBuffer("SELECT * FROM ").append(string).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String getSelectSQL(Class<?> clazz, Object idValue) {
        void var1_1;
        TableInfo tableInfo = TableInfo.get(clazz);
        StringBuffer stringBuffer = new StringBuffer(SqlBuilder.getSelectSqlByTableName(tableInfo.getTableName()));
        stringBuffer.append(" WHERE ");
        stringBuffer.append(SqlBuilder.getPropertyStrSql(tableInfo.getId().getColumn(), var1_1));
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static SqlInfo getSelectSqlAsSqlInfo(Class<?> clazz, Object idValue) {
        void var1_1;
        Object object = TableInfo.get(clazz);
        StringBuffer stringBuffer = new StringBuffer(SqlBuilder.getSelectSqlByTableName(((TableInfo)object).getTableName()));
        stringBuffer.append(" WHERE ").append(((TableInfo)object).getId().getColumn()).append("=?");
        object = new SqlInfo();
        ((SqlInfo)object).setSql(stringBuffer.toString());
        ((SqlInfo)object).addValue(var1_1);
        return object;
    }

    public static String getSelectSQL(Class<?> clazz) {
        return SqlBuilder.getSelectSqlByTableName(TableInfo.get(clazz).getTableName());
    }

    /*
     * WARNING - void declaration
     */
    public static String getSelectSQLByWhere(Class<?> clazz, String strWhere) {
        Object object = TableInfo.get(clazz);
        object = new StringBuffer(SqlBuilder.getSelectSqlByTableName(((TableInfo)object).getTableName()));
        if (!TextUtils.isEmpty((CharSequence)strWhere)) {
            void var1_1;
            ((StringBuffer)object).append(" WHERE ").append((String)var1_1);
        }
        return ((StringBuffer)object).toString();
    }

    public static SqlInfo getUpdateSqlAsSqlInfo(Object entity) {
        TableInfo tableInfo = TableInfo.get(entity.getClass());
        Object t2 = tableInfo.getId().getValue(entity);
        if (t2 == null) {
            throw new RuntimeException("this entity[" + entity.getClass() + "]'s id value is null");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        Object object2 = tableInfo.propertyMap.values().iterator();
        while (object2.hasNext()) {
            object = SqlBuilder.property2KeyValue(object2.next(), entity);
            if (object == null) continue;
            arrayList.add(object);
        }
        object = tableInfo.manyToOneMap.values().iterator();
        while (object.hasNext()) {
            KeyValue keyValue = SqlBuilder.manyToOne2KeyValue((ManyToOne)object.next(), entity);
            if (keyValue == null) continue;
            arrayList.add(keyValue);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        object2 = new SqlInfo();
        object = new StringBuffer("UPDATE ");
        ((StringBuffer)object).append(tableInfo.getTableName());
        ((StringBuffer)object).append(" SET ");
        for (KeyValue keyValue : arrayList) {
            ((StringBuffer)object).append(keyValue.getKey()).append("=?,");
            ((SqlInfo)object2).addValue(keyValue.getValue());
        }
        ((StringBuffer)object).deleteCharAt(((StringBuffer)object).length() - 1);
        ((StringBuffer)object).append(" WHERE ").append(tableInfo.getId().getColumn()).append("=?");
        ((SqlInfo)object2).addValue(t2);
        ((SqlInfo)object2).setSql(((StringBuffer)object).toString());
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    public static SqlInfo getUpdateSqlAsSqlInfo(Object entity, String strWhere) {
        TableInfo tableInfo = TableInfo.get(entity.getClass());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        Object object2 = tableInfo.propertyMap.values().iterator();
        while (object2.hasNext()) {
            object = SqlBuilder.property2KeyValue(object2.next(), entity);
            if (object == null) continue;
            arrayList.add(object);
        }
        object = tableInfo.manyToOneMap.values().iterator();
        while (object.hasNext()) {
            KeyValue keyValue = SqlBuilder.manyToOne2KeyValue((ManyToOne)object.next(), entity);
            if (keyValue == null) continue;
            arrayList.add(keyValue);
        }
        if (arrayList.size() == 0) {
            Iterator iterator;
            throw new RuntimeException("this entity[" + iterator.getClass() + "] has no property");
        }
        object2 = new SqlInfo();
        object = new StringBuffer("UPDATE ");
        ((StringBuffer)object).append(tableInfo.getTableName());
        ((StringBuffer)object).append(" SET ");
        for (KeyValue keyValue : arrayList) {
            ((StringBuffer)object).append(keyValue.getKey()).append("=?,");
            ((SqlInfo)object2).addValue(keyValue.getValue());
        }
        ((StringBuffer)object).deleteCharAt(((StringBuffer)object).length() - 1);
        if (!TextUtils.isEmpty((CharSequence)strWhere)) {
            void var1_1;
            ((StringBuffer)object).append(" WHERE ").append((String)var1_1);
        }
        ((SqlInfo)object2).setSql(((StringBuffer)object).toString());
        return object2;
    }

    public static String getCreatTableSQL(Class<?> clazz) {
        Iterator<ManyToOne> iterator = TableInfo.get(clazz);
        Property property22 = ((TableInfo)((Object)iterator)).getId();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE IF NOT EXISTS ");
        stringBuffer.append(((TableInfo)((Object)iterator)).getTableName());
        stringBuffer.append(" ( ");
        Class<?> object2 = property22.getDataType();
        if (object2 == Integer.TYPE || object2 == Integer.class) {
            stringBuffer.append("\"").append(property22.getColumn()).append("\"    INTEGER PRIMARY KEY AUTOINCREMENT,");
        } else {
            stringBuffer.append("\"").append(property22.getColumn()).append("\"    TEXT PRIMARY KEY,");
        }
        for (Property property22 : ((TableInfo)((Object)iterator)).propertyMap.values()) {
            stringBuffer.append("\"").append(property22.getColumn());
            stringBuffer.append("\",");
        }
        for (ManyToOne manyToOne : ((TableInfo)((Object)iterator)).manyToOneMap.values()) {
            stringBuffer.append("\"").append(manyToOne.getColumn()).append("\",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String getPropertyStrSql(String key, Object value) {
        CharSequence charSequence;
        charSequence = new StringBuffer((String)charSequence).append("=");
        if (value instanceof String || value instanceof Date || value instanceof java.sql.Date) {
            ((StringBuffer)charSequence).append("'").append(value).append("'");
        } else {
            void var1_1;
            ((StringBuffer)charSequence).append(var1_1);
        }
        return ((StringBuffer)charSequence).toString();
    }

    private static KeyValue property2KeyValue(Property property, Object entity) {
        Object t2;
        KeyValue keyValue = null;
        String string = property.getColumn();
        if ((t2 = property.getValue(t2)) != null) {
            keyValue = new KeyValue(string, t2);
        } else if (property.getDefaultValue() != null && property.getDefaultValue().trim().length() != 0) {
            Property property2;
            keyValue = new KeyValue(string, property2.getDefaultValue());
        }
        return keyValue;
    }

    private static KeyValue manyToOne2KeyValue(ManyToOne many, Object entity) {
        Object t2;
        KeyValue keyValue = null;
        String string = many.getColumn();
        if ((t2 = many.getValue(t2)) != null) {
            ManyToOne manyToOne;
            manyToOne = t2.getClass() == ManyToOneLazyLoader.class ? TableInfo.get(manyToOne.getManyClass()).getId().getValue(t2) : TableInfo.get(t2.getClass()).getId().getValue(t2);
            if (string != null && manyToOne != null) {
                keyValue = new KeyValue(string, manyToOne);
            }
        }
        return keyValue;
    }
}

