﻿//ban drag of <img> and select of header
$(document).ready(
function () {
    $('img').bind('dragstart', function(){return false;});
    $('#header').bind('selectstart', function(){return false;});
}
);



var bheaderMouseDown=false;
var startx=0,starty=0,endx=0,endy=0;
function header_mouse_down()
{
	startx=window.event.screenX;
	starty=window.event.screenY;

	bheaderMouseDown=true;
	window.external.OnHeaderMouseDown();
}

function header_mouse_up()
{
	bheaderMouseDown=false;
}
function header_mouse_move()
{
	endx=window.event.screenX;
	endy=window.event.screenY;
	if (startx==endx && starty==endy)
	{
		return;
	}

	if (bheaderMouseDown && $('#BtnPin').attr('class').indexOf('Pinned') == -1)
	{
		bheaderMouseDown = false;
		$('#BtnPin').click();
	}
}

function header_mouse_out()
{
    if (bheaderMouseDown && $('#BtnPin').attr('class').indexOf('Pinned') == -1)
	{
		$('#BtnPin').click();
	}
}



VideoPlayerDlg = {
    //header 
    bheaderMouseDown:false,
    startx:0,
    starty:0,
    endx:0,
    endy:0,
    _playerId:"__thplayer",
    _player:null,
    _videoUrl:null,
    _onPlaying:false,

    header_mouse_down:function () 
	{
		VideoPlayerDlg.startx=window.event.screenX;
		VideoPlayerDlg.starty=window.event.screenY;
	
		VideoPlayerDlg.bheaderMouseDown=true;
        window.external.OnHeaderMouseDown();
    },

	header_mouse_up:function ()
	{
		VideoPlayerDlg.bheaderMouseDown=false;
	},
	header_mouse_move:function ()
	{
		VideoPlayerDlg.endx=window.event.screenX;
		VideoPlayerDlg.endy=window.event.screenY;
		if (VideoPlayerDlg.startx==VideoPlayerDlg.endx && VideoPlayerDlg.starty==VideoPlayerDlg.endy)
		{
			return;
		}
	
		if (VideoPlayerDlg.bheaderMouseDown && $('#BtnPin').attr('class').indexOf('Pinned') == -1)
		{
			VideoPlayerDlg.bheaderMouseDown = false;
			$('#BtnPin').click();
		}
	},
	
	header_mouse_out:function ()
	{
		if (VideoPlayerDlg.bheaderMouseDown && $('#BtnPin').attr('class').indexOf('Pinned') == -1)
		{
			VideoPlayerDlg.bheaderMouseDown = false;
			$('#BtnPin').click();
		}
	},
		
    //------------------------------------------------------------------------------
    //BtnPin_oncick()
    BtnPin_onclick: function () 
	{
		var obj=document.getElementById('BtnPin');
        if (obj.className.indexOf('Pinned')==-1)
		{
			obj.title='解除固定（快捷键：Alt+P）';
			window.external.OnPin();
			obj.className='Pinned_N';	
		}
		else
		{
			obj.title='固定窗口（快捷键：Alt+P）';
			window.external.OnUnPin();
			obj.className='Pin_N';
		} 
    },
	
	

    //------------------------------------------------------------------------------
    //BtnClose
    BtnClose_onclick: function () 
	{
        try 
		{
            window.external.HideWin(); //dont try to close window,only hide it.
			
			if ($('#BtnPin').attr('class').indexOf('Pinned') != -1)
			{
				$('#BtnPin').click();
			}
				
            if (VideoPlayerDlg._onPlaying == true) 
			{
                VideoPlayerDlg.OnBtnStop(); // to stop the video player.
            }

            VideoPlayerDlg._player = document.getElementById(VideoPlayerDlg._playerId);
            if (VideoPlayerDlg._player != null) 
			{
                VideoPlayerDlg._player.closeVideo();
            }
        } 
		catch (ex) {
        }
    },

    //------------------------------------------------------------------------------
    //ReadyForPlay
    ReadyForPlay: function (url) 
	{
        try {
            var currentUrl = url;

            if (currentUrl == null || currentUrl == "") {
                return false;
            }

            VideoPlayerDlg._videoUrl = currentUrl;

            VideoPlayerDlg._player = document.getElementById(VideoPlayerDlg._playerId);
            if (VideoPlayerDlg._player != null) {
                if (VideoPlayerDlg._onPlaying == true) {
                    VideoPlayerDlg.OnBtnStop();
                    VideoPlayerDlg._player.closeVideo();
                }
                VideoPlayerDlg._player.setCompleteHandler("VideoPlayerDlg.OnPlayCompleted");
                VideoPlayerDlg._player.setSource(VideoPlayerDlg._videoUrl);
            }

            return true;
        } catch (ex) {
            return false;
        }
    },

    //------------------------------------------------------------------------------
    //OnBtnStop
    OnBtnStop: function () 
	{
        try {
            var btnPlay = document.getElementById("btnplay");
            var btnPause = document.getElementById("btnpause");
            var btnReplay = document.getElementById("btnreplay");
            VideoPlayerDlg._player = document.getElementById(VideoPlayerDlg._playerId);

            if (VideoPlayerDlg._videoUrl == null || VideoPlayerDlg._videoUrl == "") {
                return;
            }

            if (VideoPlayerDlg._onPlaying == true && btnPlay != null && btnPause != null && btnReplay != null && VideoPlayerDlg._player != null) {
                btnPlay.style.display = "block";
                btnPause.style.display = "none";
                btnReplay.style.display = "none";

                VideoPlayerDlg._player.stopVideo();
                VideoPlayerDlg._onPlaying = false;
            }
        } catch (ex) {
        }
    },

    //------------------------------------------------------------------------------
    //OnBtnPause
    OnBtnPause: function () 
	{
        try {
            var btnPlay = document.getElementById("btnplay");
            var btnPause = document.getElementById("btnpause");
            var btnReplay = document.getElementById("btnreplay");
            VideoPlayerDlg._player = document.getElementById(VideoPlayerDlg._playerId);

            if (VideoPlayerDlg._videoUrl == null || VideoPlayerDlg._videoUrl == "") {
                return;
            }

            if (VideoPlayerDlg._onPlaying == true && btnPlay != null && btnPause != null && btnReplay != null && VideoPlayerDlg._player != null) {
                btnPlay.style.display = "block";
                btnPause.style.display = "none";
                btnReplay.style.display = "none";

                VideoPlayerDlg._player.pauseVideo();
                VideoPlayerDlg._onPlaying = false;
            }
        } catch (ex) {
        }
    },

    //------------------------------------------------------------------------------
    //OnBtnPlay
    OnBtnPlay: function () 
	{
        try {
            var btnPlay = document.getElementById("btnplay");
            var btnPause = document.getElementById("btnpause");
            var btnReplay = document.getElementById("btnreplay");
            VideoPlayerDlg._player = document.getElementById(VideoPlayerDlg._playerId);

            if (VideoPlayerDlg._videoUrl == null || VideoPlayerDlg._videoUrl == "") {
                return;
            }

            if (VideoPlayerDlg._onPlaying == false && btnPlay != null && btnPause != null && btnReplay != null && VideoPlayerDlg._player != null) {
                btnReplay.style.display = "none";
                btnPlay.style.display = "none";
                btnPause.style.display = "block";

                VideoPlayerDlg._player.goPlay();
                VideoPlayerDlg._onPlaying = true;
            }
        } catch (ex) {
        }
    },

    //------------------------------------------------------------------------------
    //OnBtnReplay
    OnBtnReplay: function () 
	{
        try {
            var btnPlay = document.getElementById("btnplay");
            var btnPause = document.getElementById("btnpause");
            var btnReplay = document.getElementById("btnreplay");
            VideoPlayerDlg._player = document.getElementById(VideoPlayerDlg._playerId);

            if (VideoPlayerDlg._videoUrl == null || VideoPlayerDlg._videoUrl == "") {
                return;
            }

            if (VideoPlayerDlg._onPlaying == false && btnPlay != null && btnPause != null && btnReplay != null && VideoPlayerDlg._player != null) {
                btnReplay.style.display = "none";
                btnPlay.style.display = "none";
                btnPause.style.display = "block";

                VideoPlayerDlg._player.goPlay();
                VideoPlayerDlg._onPlaying = true;
            }
        } catch (ex) {
        }
    },

    //------------------------------------------------------------------------------
    //OnPlayCompleted
    OnPlayCompleted: function () 
	{
        try {
            var btnPlay = document.getElementById("btnplay");
            var btnPause = document.getElementById("btnpause");
            var btnReplay = document.getElementById("btnreplay");
            VideoPlayerDlg._player = document.getElementById(VideoPlayerDlg._playerId);

            if (VideoPlayerDlg._videoUrl == null || VideoPlayerDlg._videoUrl == "") {
                return;
            }

            if (VideoPlayerDlg._onPlaying == true && btnPlay != null && btnPause != null && btnReplay != null && VideoPlayerDlg._player != null) {
                btnReplay.style.display = "block";
                btnPlay.style.display = "none";
                btnPause.style.display = "none";
                VideoPlayerDlg._onPlaying = false;
            }
        } catch (ex) {
        }
    }
}

function PlayVideo(url) 
{
    try 
	{
        VideoPlayerDlg.ReadyForPlay(url);
        VideoPlayerDlg.OnBtnPlay();
    } catch (ex) 
	{
    }
};



//------------------------------------------------------------------------------
//BtnPin_oncick()
function BtnPin_onclick() 
{
	VideoPlayerDlg.BtnPin_onclick(); 
}
	
	

//------------------------------------------------------------------------------
//BtnClose
function BtnClose_onclick() 
{
	VideoPlayerDlg.BtnClose_onclick(); 
}


/********skin********/
var CurSkinModel = "DefaultModel";
var CurSkinColor = "Blue.css";
var CurSkinImage = "";
function GetCurrentSkinModel()
{
    return CurSkinModel;
}

function GetCurrentSkinColor()
{
    return CurSkinColor;
}

function GetCurrentSkinImage()
{
    return CurSkinImage;
}

function UpdateSkinForPage(model, color, image)
{
    CurSkinModel = model;
    CurSkinColor = color;
    CurSkinImage = image;
    $("link#_NewSkinModel").attr("href", "").attr("href", "../../../skin/Model/" + model + "/VideoPlayerDlg/VideoPlayerDlg.css");
    $("link#_NewSkinColor").attr("href", "").attr("href", "../../../skin/Color/" + color + ".css");
}
