#ifndef AR_CONFIG_H
#define AR_CONFIG_H

/*------------------------------------------------------------*/
/*                                                            */
/*  For Linux, you should define one of below 3 input method  */
/*    AR_INPUT_V4L:     use of standard Video4Linux Library   */
/*    AR_INPUT_DV:      use of DV Camera                      */
/*    AR_INPUT_1394CAM: use of 1394 Digital Camara            */
/*                                                            */
/*------------------------------------------------------------*/
#ifdef __linux
#undef  AR_INPUT_V4L
#undef  AR_INPUT_DV
#undef  AR_INPUT_1394CAM

#ifdef AR_INPUT_V4L
#define  AR_PIX_FORMAT_BGR
#undef   AR_PIX_FORMAT_BGRA
#endif

#ifdef AR_INPUT_DV
#define  AR_PIX_FORMAT_RGB
#undef   AR_PIX_FORMAT_BGRA
#endif

#ifdef AR_INPUT_1394CAM
#define  AR_PIX_FORMAT_RGB
#endif

#undef   AR_BIG_ENDIAN
#define  AR_LITTLE_ENDIAN
#endif


/*------------------------------------------------------------*/
/*  For SGI                                                   */
/*------------------------------------------------------------*/
#ifdef __sgi
#define  AR_BIG_ENDIAN
#undef   AR_LITTLE_ENDIAN
#define  AR_PIX_FORMAT_ABGR
#endif

/*------------------------------------------------------------*/
/*  For Windows                                               */
/*------------------------------------------------------------*/
#ifdef _WIN32
#undef   AR_BIG_ENDIAN
#define  AR_LITTLE_ENDIAN
#define  AR_PIX_FORMAT_BGRA
#endif

/*------------------------------------------------------------*/
/*  For Mac OS X                                              */
/*------------------------------------------------------------*/
#if __APPLE_CC__
#define  AR_BIG_ENDIAN
#undef   AR_LITTLE_ENDIAN
#define  AR_PIX_FORMAT_RGBA
#endif


/*------------------------------------------------------------*/

#define  AR_DRAW_BY_GL_DRAW_PIXELS    0
#define  AR_DRAW_BY_TEXTURE_MAPPING   1
#define  AR_DRAW_TEXTURE_FULL_IMAGE   0
#define  AR_DRAW_TEXTURE_HALF_IMAGE   1
#define  AR_IMAGE_PROC_IN_FULL        0
#define  AR_IMAGE_PROC_IN_HALF        1
#define  AR_FITTING_TO_IDEAL          0
#define  AR_FITTING_TO_INPUT          1

#define  AR_TEMPLATE_MATCHING_COLOR   0
#define  AR_TEMPLATE_MATCHING_BW      1
#define  AR_MATCHING_WITHOUT_PCA      0
#define  AR_MATCHING_WITH_PCA         1
#define  DEFAULT_TEMPLATE_MATCHING_MODE     AR_TEMPLATE_MATCHING_COLOR
#define  DEFALUT_MATCHING_PCA_MODE          AR_MATCHING_WITHOUT_PCA


#ifdef __linux
#ifdef AR_INPUT_V4L
#define   VIDEO_MODE_PAL              0
#define   VIDEO_MODE_NTSC             1
#define   VIDEO_MODE_SECAM            2
#define   DEFAULT_VIDEO_DEVICE        "/dev/video0"
#define   DEFAULT_VIDEO_WIDTH         640
#define   DEFAULT_VIDEO_HEIGHT        480
#define   DEFAULT_VIDEO_CHANNEL       1
#define   DEFAULT_VIDEO_MODE          VIDEO_MODE_NTSC
#endif

#ifdef AR_INPUT_DV
#define   VIDEO_MODE_PAL              0
#define   VIDEO_MODE_NTSC             1
#define   DEFAULT_VIDEO_MODE          VIDEO_MODE_NTSC
#endif

#ifdef AR_INPUT_1394CAM
#undef    DRAGONFLY
#define   VIDEO_NODE_ANY                      -1
#define   VIDEO_MODE_320x240_YUV422           32
#define   VIDEO_MODE_640x480_YUV411           33
#define   VIDEO_MODE_640x480_RGB              34
#define   VIDEO_MODE_640x480_YUV411_HALF      35
#define   VIDEO_MODE_640x480_MONO             36
#define   VIDEO_MODE_640x480_MONO_COLOR       37
#define   VIDEO_MODE_640x480_MONO_COLOR_HALF  38
#define   VIDEO_FRAME_RATE_1_875               1
#define   VIDEO_FRAME_RATE_3_75                2
#define   VIDEO_FRAME_RATE_7_5                 3
#define   VIDEO_FRAME_RATE_15                  4
#define   VIDEO_FRAME_RATE_30                  5
#define   VIDEO_FRAME_RATE_60                  6
#define   DEFAULT_VIDEO_NODE                   VIDEO_NODE_ANY
#ifndef   DRAGONFLY
#define   DEFAULT_VIDEO_MODE                   VIDEO_MODE_640x480_YUV411_HALF
#else
#define   DEFAULT_VIDEO_MODE                   VIDEO_MODE_640x480_MONO_COLOR_HALF
#endif
#define   DEFAULT_VIDEO_FRAME_RATE             VIDEO_FRAME_RATE_30
#endif

#define   DEFAULT_IMAGE_PROC_MODE     AR_IMAGE_PROC_IN_HALF
#define   DEFAULT_FITTING_MODE        AR_FITTING_TO_IDEAL
#define   DEFAULT_DRAW_MODE           AR_DRAW_BY_TEXTURE_MAPPING
#define   DEFAULT_DRAW_TEXTURE_IMAGE  AR_DRAW_TEXTURE_HALF_IMAGE
#endif

#ifdef __sgi
#define   VIDEO_FULL                  0
#define   VIDEO_HALF                  1
#define   DEFAULT_VIDEO_SIZE          VIDEO_FULL
#define   DEFAULT_IMAGE_PROC_MODE     AR_IMAGE_PROC_IN_HALF
#define   DEFAULT_FITTING_MODE        AR_FITTING_TO_INPUT
#define   DEFAULT_DRAW_MODE           AR_DRAW_BY_GL_DRAW_PIXELS
#define   DEFAULT_DRAW_TEXTURE_IMAGE  AR_DRAW_TEXTURE_HALF_IMAGE
#endif

#ifdef _WIN32
#define   DEFAULT_IMAGE_PROC_MODE     AR_IMAGE_PROC_IN_FULL
#define   DEFAULT_FITTING_MODE        AR_FITTING_TO_INPUT
#define   DEFAULT_DRAW_MODE           AR_DRAW_BY_GL_DRAW_PIXELS
#define   DEFAULT_DRAW_TEXTURE_IMAGE  AR_DRAW_TEXTURE_FULL_IMAGE
#endif

#if __APPLE__
#define   DEFAULT_VIDEO_WIDTH         640
#define   DEFAULT_VIDEO_HEIGHT        480
#define   DEFAULT_IMAGE_PROC_MODE     AR_IMAGE_PROC_IN_HALF
#define   DEFAULT_FITTING_MODE        AR_FITTING_TO_IDEAL
#define   DEFAULT_DRAW_MODE           AR_DRAW_BY_TEXTURE_MAPPING
#define   DEFAULT_DRAW_TEXTURE_IMAGE  AR_DRAW_TEXTURE_HALF_IMAGE
#undef    APPLE_TEXTURE_FAST_TRANSFER
#endif


/*  For NVIDIA OpenGL Driver  */
#undef    AR_OPENGL_TEXTURE_RECTANGLE



#if defined(AR_PIX_FORMAT_ABGR) || defined(AR_PIX_FORMAT_BGRA) || defined(AR_PIX_FORMAT_RGBA)
#define AR_PIX_SIZE      4
#elif defined(AR_PIX_FORMAT_BGR) || defined(AR_PIX_FORMAT_RGB)
#define AR_PIX_SIZE      3
#endif


#define   AR_GET_TRANS_MAT_MAX_LOOP_COUNT         5
#define   AR_GET_TRANS_MAT_MAX_FIT_ERROR          1.0
#define   AR_GET_TRANS_CONT_MAT_MAX_FIT_ERROR     1.0

#define   AR_AREA_MAX      100000
#define   AR_AREA_MIN          70


#define   AR_SQUARE_MAX        30
#define   AR_CHAIN_MAX      10000
#define   AR_PATT_NUM_MAX      50 
#define   AR_PATT_SIZE_X       16 
#define   AR_PATT_SIZE_Y       16 
#define   AR_PATT_SAMPLE_NUM   64

#define   AR_GL_CLIP_NEAR      50.0
#define   AR_GL_CLIP_FAR     5000.0

#define   AR_HMD_XSIZE        640
#define   AR_HMD_YSIZE        480

#define   AR_PARAM_NMIN         6
#define   AR_PARAM_NMAX      1000
#define   AR_PARAM_C34        100.0

#endif
