/* Copyright 2012 ESRI
 *
 * All rights reserved under the copyright laws of the United States
 * and applicable international laws, treaties, and conventions.
 *
 * You may freely redistribute and use this sample code, with or
 * without modification, provided you include the original copyright
 * notice and use restrictions.
 *
 * See the �Sample code usage restrictions� document for further information.
 *
 */

package com.esri.arcgis.android.samples.helloworld;

import android.app.Activity;
import android.os.Bundle;

import com.esri.android.map.MapView;
import com.esri.android.map.ags.ArcGISTiledMapServiceLayer;

public class HelloWorld extends Activity {
	MapView map = null;
	ArcGISTiledMapServiceLayer tileLayer;

	/** Called when the activity is first created. */
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		
		// Retrieve the map and initial extent from XML layout
		map = (MapView)findViewById(R.id.map);
		// Add tiled layer to MapView
		tileLayer = new ArcGISTiledMapServiceLayer("http://services.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer");
		map.addLayer(tileLayer);
		
	}
	

	protected void onPause() {
		super.onPause();
		map.pause();
 }

	protected void onResume() {
		super.onResume(); 
		map.unpause();
	}	
	
}