/* Copyright 2011 ESRI
 *
 * All rights reserved under the copyright laws of the United States
 * and applicable international laws, treaties, and conventions.
 *
 * You may freely redistribute and use this sample code, with or
 * without modification, provided you include the original copyright
 * notice and use restrictions.
 *
 * See the sample code usage restrictions document for further information.
 *
 */

package com.esri.arcgis.android.samples.addbingmap;

import android.app.Activity;
import android.os.Bundle;

import com.esri.android.map.MapView;
import com.esri.android.map.bing.BingMapsLayer;

public class AddBingMap extends Activity {

	MapView map;
	BingMapsLayer baseLayer;
	
	final static int LOADING_CANCEL = 0;
	final static int LOADING_SUCCESS = 1;

	// Called when the activity is first created.
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		// Retrieve the MapView from XML layout
		map = (MapView)findViewById(R.id.map);
		
		//Retrieve the non-configuration instance data that was previously returned. 
		Object init = getLastNonConfigurationInstance();
		if (init != null) {
			map.restoreState((String) init);
		}	

	}
	

	protected void onPause() {
		super.onPause();
		map.pause();
 }
	
	protected void onResume() {
		super.onResume(); 
		map.unpause();
	}	
	
}