/* Copyright 2012 ESRI
 *
 * All rights reserved under the copyright laws of the United States
 * and applicable international laws, treaties, and conventions.
 *
 * You may freely redistribute and use this sample code, with or
 * without modification, provided you include the original copyright
 * notice and use restrictions.
 *
 * See the �Sample code usage restrictions� document for further information.
 *
 */

package com.esri.arcgis.android.samples.securedfeatureylayer;

import android.app.Activity;
import android.os.Bundle;
import android.widget.Toast;

import com.esri.android.map.MapView;
import com.esri.android.map.ags.ArcGISDynamicMapServiceLayer;
import com.esri.android.map.ags.ArcGISFeatureLayer;
import com.esri.android.map.ags.ArcGISFeatureLayer.MODE;
import com.esri.android.map.ags.ArcGISTiledMapServiceLayer;
import com.esri.android.map.event.OnSingleTapListener;
import com.esri.android.map.event.OnStatusChangedListener;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.io.EsriSecurityException;
import com.esri.core.io.UserCredentials;
import com.esri.core.map.FeatureSet;
import com.esri.core.map.Graphic;
import com.esri.core.tasks.ags.query.Query;
import com.esri.core.tasks.ags.query.QueryTask;

public class SecuredFeatureLayer extends Activity {
	MapView map;
	String url;
	ArcGISFeatureLayer fl;

  public void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);
      
      // Create map
      map = new MapView(this);
      setContentView(map);	

      // Add a cached map service
      ArcGISTiledMapServiceLayer tiledLayer = new ArcGISTiledMapServiceLayer("https://server.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer");
      map.addLayer(tiledLayer);
      
      // Add a dynamic map service
      ArcGISDynamicMapServiceLayer dynLayer = new ArcGISDynamicMapServiceLayer("https://servicesbeta.esri.com/ArcGIS/rest/services/SanJuan/Trails/MapServer");
      map.addLayer(dynLayer);
      
      // Add a token-based secured feature service  
      // Set user credential through token. 
			// Refer to http://help.arcgis.com/en/webapi/javascript/arcgis/help/jshelp_start.htm#jshelp/ags_security.htm#http://help.arcgis.com/en/webapi/javascript/arcgis/help/jshelp/ags_security.htm/tokens 
			// on how to obtain a token.
      UserCredentials creds = new UserCredentials();
      creds.setUserToken("YonZCrEXExMMvF8AGB0-qBmtsXXivAYTYN9Udqu4dc6H9cUYud8NzjpeTt7aZhkN", "mytoken");
      url = "https://servicesbeta.esri.com/ArcGIS/rest/services/SanJuan/TrailConditions/FeatureServer/0";		

      fl = new ArcGISFeatureLayer(url, MODE.ONDEMAND, creds);      
      map.addLayer(fl);
      // Set map extent
      map.setExtent(new Envelope(-12080521, 4472736, -11829657, 4563023));

      // Tap on the map and query the secured feature service
			map.setOnSingleTapListener(new OnSingleTapListener() {
				private static final long serialVersionUID = 1L;
	
				public void onSingleTap(final float x, final float y) {
					try {
						// Create query for the secured feature service
			      Query queryParameter = new Query();
						SpatialReference sr = SpatialReference.create(map.getSpatialReference().getID());
						queryParameter.setOutSpatialReference(sr);
						queryParameter.setReturnGeometry(true);
						queryParameter.setWhere("Condition='Campground'");
						queryParameter.setOutFields(new String[] { "*" });
						
			      // Set user credential through username and password
			      UserCredentials creds = new UserCredentials();
			      creds.setUserAccount("rick", "rick@esri");
						QueryTask query = new QueryTask(url, creds);
					
						// Display query result
						FeatureSet featureSet = query.execute(queryParameter);
						String str = "No Campground is found.";
						if (featureSet != null) {
							Graphic[] feature = featureSet.getGraphics();
							if (feature != null && feature.length > 0) {
								str = "A total of " + feature.length + " Campgrounds found.";	
							}
						}
						Toast.makeText(map.getContext(), str, Toast.LENGTH_SHORT).show();

					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			});
			
			// Handle status change event on MapView
			map.setOnStatusChangedListener(new OnStatusChangedListener() {
				private static final long serialVersionUID = 1L;

				public void onStatusChanged(Object source, STATUS status) {
					if (status == STATUS.LAYER_LOADING_FAILED) {
						// Check if a layer is failed to be loaded due to security
						if ((status.getError()) instanceof EsriSecurityException) {
              EsriSecurityException securityEx = (EsriSecurityException) status.getError();
              if (securityEx.getCode() == EsriSecurityException.AUTHENTICATION_FAILED)
                Toast.makeText(map.getContext(), "Authentication Failed! Resubmit!", Toast.LENGTH_SHORT).show();
              else if (securityEx.getCode() == EsriSecurityException.TOKEN_INVALID)
              	Toast.makeText(map.getContext(), "Invalid Token! Resubmit!", Toast.LENGTH_SHORT).show();
              else if (securityEx.getCode() == EsriSecurityException.TOKEN_SERVICE_NOT_FOUND)
              	Toast.makeText(map.getContext(), "Token Service Not Found! Resubmit!", Toast.LENGTH_SHORT).show();
              else if (securityEx.getCode() == EsriSecurityException.UNTRUSTED_SERVER_CERTIFICATE)
              	Toast.makeText(map.getContext(), "Untrusted Host! Resubmit!", Toast.LENGTH_SHORT).show();
              
              if (source instanceof ArcGISFeatureLayer) {
              	// Set user credential through username and password
    			      UserCredentials creds = new UserCredentials();
    			      creds.setUserAccount("rick", "rick@esri");
              	fl.reinitializeLayer(creds); 
              }
						}
					}
        }        
      });

  }
  
	protected void onPause() {
		super.onPause();
 }

	protected void onResume() {
		super.onResume(); 
	}	
}