/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.wizard;

import com.esri.arcgis.android.core.ProjectUtils;
import com.esri.arcgis.android.core.commands.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleWizardPage
extends WizardPage {
    public static final String[] languages = new String[]{"English", "German", "Spanish", "French", "Italian", "Portuguese", "Russian", "Chinese", "Korean", "Japanese", "Norwegian", "Polish", "Swedish", "Dutch", "Romanian"};
    public static final String[] languages_abbr = new String[]{"", "de", "es", "fr", "it", "pt", "ru", "zh", "ko", "ja", "no", "pl", "sv", "nl", "ro"};
    Button[] buttons = new Button[languages.length];

    protected LocaleWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectGroup(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private void createProjectGroup(Composite parent) {
        Group ownerInfo = new Group(parent, 0);
        ownerInfo.setText(Messages.LocaleWizardPage_label_0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginTop = 20;
        gridLayout.marginLeft = 110;
        gridLayout.marginBottom = 20;
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 100;
        ownerInfo.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 1, true, false);
        ownerInfo.setLayoutData((Object)gridData);
        int i = 0;
        while (i < languages.length) {
            Button button = new Button((Composite)ownerInfo, 32);
            button.setText(languages[i]);
            if (i == 0) {
                button.setSelection(true);
                button.setEnabled(false);
            }
            button.setData((Object)languages_abbr[i]);
            this.buttons[i] = button;
            ++i;
        }
        this.setInitialSelection();
    }

    public void setInitialSelection() {
        IProject proj = ProjectUtils.getProject();
        Button[] buttonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder resFolder;
            Button bnt = buttonArray[n2];
            Object obj = bnt.getData();
            if (obj != null && obj instanceof String && (resFolder = proj.getFolder("/res/values-" + (String)obj)).exists()) {
                bnt.setSelection(true);
                bnt.setEnabled(false);
            }
            ++n2;
        }
    }

    public List<String> getSelectedLocales() {
        ArrayList<String> list = new ArrayList<String>();
        Button[] buttonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button n3 = buttonArray[n2];
            if (n3.getSelection()) {
                String lang = (String)n3.getData();
                list.add(lang);
            }
            ++n2;
        }
        return list;
    }
}

