/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.wizard;

import com.esri.arcgis.android.core.ProjectUtils;
import com.esri.arcgis.android.core.wizard.LocaleWizardPage;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.osgi.framework.Bundle;

public class LocaleUtils {
    static final String UI_POPUP_RES = "arcgis_ui_strings.xml";
    static final String UI_STR_RES = "strings.xml";

    public static void copyLocaleFileFromBundleToProject(IJavaProject project, String strLocale) {
        LocaleUtils.copyLocaleFileFromBundleToProject(project, strLocale, false);
    }

    public static void updateProjectLocale(IJavaProject project) {
        if (project == null) {
            return;
        }
        ArrayList<String> selectedLangs = new ArrayList<String>();
        String[] stringArray = LocaleWizardPage.languages_abbr;
        int n = LocaleWizardPage.languages_abbr.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            IFolder resFolders = project.getProject().getFolder("res/values" + (folder.length() < 1 ? "" : "-" + folder + "/"));
            if (resFolders.exists()) {
                System.out.println("adding " + resFolders);
                selectedLangs.add(folder);
            }
            ++n2;
        }
        for (String s : selectedLangs) {
            LocaleUtils.copyLocaleFileFromBundleToProject(project, s, true);
        }
    }

    public static void copyLocaleFileFromBundleToProject(IJavaProject project, String strLocale, boolean update) {
        String valuesFolder;
        String string = valuesFolder = strLocale.length() == 0 ? "values" : "values-" + strLocale;
        if (project == null) {
            return;
        }
        Bundle bundle = Platform.getBundle((String)"com.esri.arcgis.android.core");
        try {
            ProjectUtils.addDefaultDirectories(project.getProject(), "/", new String[]{"res"});
            ProjectUtils.addDefaultDirectories(project.getProject(), "res/", new String[]{valuesFolder});
            Path uiPath = new Path("res/" + valuesFolder + "/" + UI_POPUP_RES);
            URL[] urls = FileLocator.findEntries((Bundle)bundle, (IPath)uiPath);
            if (urls != null && urls.length > 0) {
                InputStream popup_stream = FileLocator.openStream((Bundle)bundle, (IPath)uiPath, (boolean)false);
                IFile popup_file = project.getProject().getFile("res/" + valuesFolder + "/" + UI_POPUP_RES);
                if (!popup_file.exists()) {
                    popup_file.create(popup_stream, true, null);
                } else if (update) {
                    popup_file.setContents(popup_stream, true, false, null);
                }
                popup_stream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

