/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.wizard;

import com.esri.arcgis.android.core.ProjectUtils;
import com.esri.arcgis.android.core.commands.Messages;
import com.esri.arcgis.android.core.wizard.LocaleUtils;
import com.esri.arcgis.android.core.wizard.LocaleWizardPage;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddLocaleWizard
extends Wizard
implements INewWizard {
    private static String desc = "This wizard will help you  to install language resource files required \nfor localization of ArcGIS Android widgets at run-time";
    protected static final String MAIN_PAGE_NAME = "newLocaleWizardPage";
    private LocaleWizardPage mMainPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setHelpAvailable(false);
        this.setWindowTitle(Messages.AddLocaleWizard_label_0);
        this.setImageDescriptor();
        this.mMainPage = this.createMainPage();
        this.mMainPage.setDescription(desc);
    }

    protected LocaleWizardPage createMainPage() {
        return new LocaleWizardPage(MAIN_PAGE_NAME);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mMainPage);
    }

    public boolean performFinish() {
        List<String> SelectedLangs = this.mMainPage.getSelectedLocales();
        IJavaProject project = ProjectUtils.getJavaProject();
        for (String s : SelectedLangs) {
            LocaleUtils.copyLocaleFileFromBundleToProject(project, s);
        }
        return true;
    }

    private void setImageDescriptor() {
    }
}

