/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.project.support;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Density {
    XHIGH("xhdpi", "X-High Density", 320),
    HIGH("hdpi", "High Density", 240),
    TV("tvdpi", "TV Density", 213),
    MEDIUM("mdpi", "Medium Density", 160),
    LOW("ldpi", "Low Density", 120),
    NODPI("nodpi", "No Density", 0);

    public static final int DEFAULT_DENSITY = 160;
    private final String mValue;
    private final String mDisplayValue;
    private final int mDensity;

    private Density(String value, String displayValue, int density) {
        this.mValue = value;
        this.mDisplayValue = displayValue;
        this.mDensity = density;
    }

    public static Density getEnum(String value) {
        Density[] densityArray = Density.values();
        int n = densityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Density orient = densityArray[n2];
            if (orient.mValue.equals(value)) {
                return orient;
            }
            ++n2;
        }
        return null;
    }

    public static Density getEnum(int value) {
        Density[] densityArray = Density.values();
        int n = densityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Density d = densityArray[n2];
            if (d.mDensity == value) {
                return d;
            }
            ++n2;
        }
        return null;
    }

    public String getResourceValue() {
        return this.mValue;
    }

    public int getDpiValue() {
        return this.mDensity;
    }

    public String getLegacyValue() {
        if (this != NODPI) {
            return String.format("%1$ddpi", this.getDpiValue());
        }
        return "";
    }

    public String getShortDisplayValue() {
        return this.mDisplayValue;
    }

    public String getLongDisplayValue() {
        return this.mDisplayValue;
    }

    public static int getIndex(Density value) {
        int i = 0;
        Density[] densityArray = Density.values();
        int n = densityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Density input = densityArray[n2];
            if (value == input) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public static Density getByIndex(int index) {
        int i = 0;
        Density[] densityArray = Density.values();
        int n = densityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Density value = densityArray[n2];
            if (i == index) {
                return value;
            }
            ++i;
            ++n2;
        }
        return null;
    }

    public boolean isFakeValue() {
        return false;
    }

    public boolean isValidValueForDevice() {
        return this != NODPI;
    }
}

