/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.project;

import com.esri.arcgis.android.core.project.NewProjectWizardState;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;

class ProjectNamePage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private static final String UNC_PREFIX = "//";
    private static final String SCHEME_FILE = "file";
    private final NewProjectWizardState mValues;
    private boolean mIgnore;
    private static final Pattern sProjectNamePattern = Pattern.compile("^[\\w][\\w. -]*$");
    private static String sCustomLocationOsPath = "";
    private static boolean sAutoComputeCustomLocation = true;
    private Text mProjectNameText;
    private Text mLocationText;
    private Button mUseDefaultCheckBox;
    private Button mBrowseButton;
    private Label mLocationLabel;

    ProjectNamePage(NewProjectWizardState values) {
        super("projectNamePage");
        this.mValues = values;
        this.setTitle("Create ArcGIS for Android Project");
        this.setDescription("Select project name and type of project");
    }

    public void init(IStructuredSelection selection, IWorkbenchPart activePart) {
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label projectDesc = new Label(container, 0);
        GridData griddata = new GridData(16384, 0x1000000, false, false, 3, 1);
        griddata.heightHint = 30;
        projectDesc.setLayoutData((Object)griddata);
        projectDesc.setText("Create new project in workspace");
        Label nameLabel = new Label(container, 0);
        nameLabel.setText("Project Name:");
        this.mProjectNameText = new Text(container, 2048);
        griddata = new GridData(4, 0x1000000, true, false, 2, 1);
        this.mProjectNameText.setLayoutData((Object)griddata);
        this.mProjectNameText.addModifyListener((ModifyListener)this);
        Label separator = new Label(container, 258);
        griddata = new GridData(4, 0x1000000, false, false, 3, 1);
        griddata.heightHint = 20;
        separator.setLayoutData((Object)griddata);
        this.mUseDefaultCheckBox = new Button(container, 32);
        this.mUseDefaultCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.mUseDefaultCheckBox.setText("Use default location");
        this.mUseDefaultCheckBox.addSelectionListener((SelectionListener)this);
        this.mLocationLabel = new Label(container, 0);
        this.mLocationLabel.setText("Location:");
        this.mLocationText = new Text(container, 2048);
        this.mLocationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mLocationText.addModifyListener((ModifyListener)this);
        this.mBrowseButton = new Button(container, 0);
        this.mBrowseButton.setText("Browse...");
        this.mBrowseButton.addSelectionListener((SelectionListener)this);
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.mValues.projectName != null) {
                this.mProjectNameText.setText(this.mValues.projectName);
            }
            if (this.mValues.projectLocation != null) {
                this.mLocationText.setText(this.mValues.projectLocation.getPath());
            }
            this.mUseDefaultCheckBox.setSelection(this.mValues.useDefaultLocation);
            this.updateLocationState();
        }
        this.validatePage();
    }

    public void modifyText(ModifyEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mProjectNameText) {
            this.onProjectFieldModified();
            this.updateLocationPathField(null);
        } else if (source == this.mLocationText && !this.mValues.useDefaultLocation) {
            this.mValues.projectLocation = new File(this.mLocationText.getText().trim());
        }
        this.validatePage();
    }

    private void onProjectFieldModified() {
        this.mValues.projectName = this.mProjectNameText.getText().trim();
        this.mValues.projectNameModifiedByUser = true;
        if (!this.mValues.applicationNameModifiedByUser) {
            this.mValues.applicationName = ProjectNamePage.capitalize(this.mValues.projectName);
        }
        if (!this.mValues.activityNameModifiedByUser) {
            String name = ProjectNamePage.capitalize(this.mValues.projectName);
            this.mValues.activityName = String.valueOf(ProjectNamePage.stripWhitespace(name)) + "Activity";
        }
        this.updateLocationPathField(null);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mUseDefaultCheckBox) {
            this.mValues.useDefaultLocation = this.mUseDefaultCheckBox.getSelection();
            this.updateLocationState();
        } else if (source == this.mBrowseButton) {
            this.onOpenDirectoryBrowser();
        }
        this.validatePage();
    }

    private void updateLocationState() {
        boolean isNewProject = !this.mValues.useExisting;
        boolean useDefault = this.mValues.useDefaultLocation;
        boolean locationEnabled = !isNewProject || !useDefault;
        this.mUseDefaultCheckBox.setEnabled(isNewProject);
        this.mLocationLabel.setEnabled(locationEnabled);
        this.mLocationText.setEnabled(locationEnabled);
        this.mBrowseButton.setEnabled(locationEnabled);
        this.updateLocationPathField(null);
    }

    private void onOpenDirectoryBrowser() {
        String existingDir = this.mLocationText.getText().trim();
        if (existingDir.length() == 0) {
            existingDir = null;
        } else {
            File f = new File(existingDir);
            if (!f.exists()) {
                existingDir = null;
            }
        }
        DirectoryDialog directoryDialog = new DirectoryDialog(this.mLocationText.getShell());
        directoryDialog.setMessage("Browse for folder");
        directoryDialog.setFilterPath(existingDir);
        String dir = directoryDialog.open();
        if (dir != null) {
            this.updateLocationPathField(dir);
            this.validatePage();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void updateLocationPathField(String absDir) {
        boolean customLocation;
        boolean isNewProject = !this.mValues.useExisting;
        boolean useDefault = this.mValues.useDefaultLocation;
        boolean bl = customLocation = !isNewProject || !useDefault;
        if (!this.mIgnore) {
            try {
                this.mIgnore = true;
                if (customLocation) {
                    if (absDir != null) {
                        sAutoComputeCustomLocation = sAutoComputeCustomLocation && absDir.equals(sCustomLocationOsPath);
                        sCustomLocationOsPath = TextProcessor.process((String)absDir);
                    } else if (sAutoComputeCustomLocation || !isNewProject && !new File(sCustomLocationOsPath).isDirectory()) {
                        sCustomLocationOsPath = System.getProperty("user.home");
                    }
                    if (!this.mLocationText.getText().equals(sCustomLocationOsPath)) {
                        this.mLocationText.setText(sCustomLocationOsPath);
                        this.mValues.projectLocation = new File(sCustomLocationOsPath);
                    }
                } else {
                    String value = Platform.getLocation().append(this.mValues.projectName).toString();
                    value = TextProcessor.process((String)value);
                    if (!this.mLocationText.getText().equals(value)) {
                        this.mLocationText.setText(value);
                        this.mValues.projectLocation = new File(value);
                    }
                }
            }
            finally {
                this.mIgnore = false;
            }
        }
    }

    private void validatePage() {
        IStatus validLocation;
        IStatus status = null;
        status = ProjectNamePage.validateProjectName(this.mValues.projectName);
        if ((status == null || status.getSeverity() != 4) && (validLocation = this.validateLocation()) != null) {
            status = validLocation;
        }
        this.setPageComplete(status == null || status.getSeverity() != 4);
        if (status != null) {
            this.setMessage(status.getMessage(), status.getSeverity() == 4 ? 3 : 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    private IStatus validateLocation() {
        try {
            Path path = new Path(this.mValues.projectLocation.getPath());
            if (!this.mValues.useDefaultLocation) {
                String[] l;
                IProject handle;
                URI uri = ProjectNamePage.toURI(path.toOSString());
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus locationStatus = workspace.validateProjectLocationURI(handle = workspace.getRoot().getProject(this.mValues.projectName), uri);
                if (!locationStatus.isOK()) {
                    return locationStatus;
                }
                File f = path.toFile();
                if (f.exists() && !f.isDirectory()) {
                    return new Status(4, "com.esri.arcgis.android.core", "A directory name must be specified.");
                }
                if (f.isDirectory() && (l = f.list()) != null && l.length != 0) {
                    return new Status(2, "com.esri.arcgis.android.core", "The selected output directory is not empty.");
                }
            } else {
                if (this.mValues.projectLocation.getPath().length() == 0) {
                    return new Status(4, "com.esri.arcgis.android.core", "A directory name must be specified.");
                }
                File dest = path.toFile();
                if (dest.exists()) {
                    return new Status(4, "com.esri.arcgis.android.core", String.format("There is already a file or directory named \"%1$s\" in the selected location.", this.mValues.projectName));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static IStatus validateProjectName(String projectName) {
        if (projectName == null || projectName.length() == 0) {
            return new Status(4, "com.esri.arcgis.android.core", "Project name must be specified");
        }
        if (!sProjectNamePattern.matcher(projectName).matches()) {
            return new Status(4, "com.esri.arcgis.android.core", "The project name must start with an alphanumeric characters, followed by one or more alphanumerics, digits, dots, dashes, underscores or spaces.");
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(projectName, 4);
        if (!nameStatus.isOK()) {
            return nameStatus;
        }
        IProject handle = workspace.getRoot().getProject(projectName);
        if (handle.exists()) {
            return new Status(4, "com.esri.arcgis.android.core", "A project with that name already exists in the workspace");
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    public static String capitalize(String str) {
        if (str == null || str.length() < 1 || Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toUpperCase(str.charAt(0)));
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static String stripWhitespace(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int i = 0;
        int n = string.length();
        while (i < n) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static URI toURI(String strUrl) throws URISyntaxException, MalformedURLException {
        URL url = new URL("file://" + strUrl);
        if (SCHEME_FILE.equals(url.getProtocol())) {
            String pathString = url.toExternalForm().substring(5);
            if (pathString.indexOf(47) != 0) {
                pathString = String.valueOf('/') + pathString;
            } else if (pathString.startsWith(UNC_PREFIX) && !pathString.startsWith(UNC_PREFIX, 2)) {
                pathString = ProjectNamePage.ensureUNCPath(pathString);
            }
            return new URI(SCHEME_FILE, null, pathString, null);
        }
        try {
            return new URI(url.toExternalForm());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
    }

    private static String ensureUNCPath(String path) {
        int len = path.length();
        StringBuffer result = new StringBuffer(len);
        int i = 0;
        while (i < 4) {
            if (i >= len || path.charAt(i) != '/') {
                result.append('/');
            }
            ++i;
        }
        result.append(path);
        return result.toString();
    }
}

