/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.project;

import com.esri.arcgis.android.core.Activator;
import com.esri.arcgis.android.core.project.ApplicationInfoPage;
import com.esri.arcgis.android.core.project.NewProjectCreator;
import com.esri.arcgis.android.core.project.NewProjectWizardState;
import com.esri.arcgis.android.core.project.ProjectNamePage;
import org.eclipse.jdt.ui.actions.OpenJavaPerspectiveAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    private static final String PROJECT_LOGO_LARGE = "icons/android-64.png";
    private NewProjectWizardState mValues;
    private ProjectNamePage mNamePage;
    private ApplicationInfoPage mPropertiesPage;
    private IWorkbench mWorkbench;

    public void addPages() {
        this.mValues = new NewProjectWizardState();
        this.mNamePage = new ProjectNamePage(this.mValues);
        this.addPage((IWizardPage)this.mNamePage);
        this.mPropertiesPage = new ApplicationInfoPage(this.mValues);
        this.addPage((IWizardPage)this.mPropertiesPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setHelpAvailable(false);
        this.setWindowTitle("New ArcGIS for Android Project");
        ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)"com.esri.arcgis.android.core", (String)PROJECT_LOGO_LARGE);
        this.setDefaultPageImageDescriptor(desc);
        this.mWorkbench = workbench;
    }

    public boolean canFinish() {
        return super.canFinish() && this.mValues.canFinish();
    }

    public boolean performFinish() {
        NewProjectCreator creator = new NewProjectCreator(this.mValues, (IRunnableContext)this.getContainer(), this.mWorkbench.getDisplay().getActiveShell());
        if (!creator.createAndroidProjects()) {
            return false;
        }
        OpenJavaPerspectiveAction action = new OpenJavaPerspectiveAction();
        action.run();
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return super.getNextPage(page);
    }
}

