/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.project;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.esri.arcgis.android.core.LogUtils;
import com.esri.arcgis.android.core.ManifestFileUtils;
import com.esri.arcgis.android.core.ProjectUtils;
import com.esri.arcgis.android.core.project.NewProjectWizardState;
import com.esri.arcgis.android.core.project.ProjectHelper;
import com.esri.arcgis.android.core.project.support.AdtUtil;
import com.esri.arcgis.android.core.project.support.Density;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewProjectCreator {
    public static String STRING_PREFIX = "@string/";
    private static final String PARAM_SDK_TOOLS_DIR = "ANDROID_SDK_TOOLS";
    private static final String PARAM_ACTIVITY = "ACTIVITY_NAME";
    private static final String PARAM_APPLICATION = "APPLICATION_NAME";
    private static final String PARAM_PACKAGE = "PACKAGE";
    private static final String PARAM_IMPORT_RESOURCE_CLASS = "IMPORT_RESOURCE_CLASS";
    private static final String PARAM_PROJECT = "PROJECT_NAME";
    private static final String PARAM_STRING_NAME = "STRING_NAME";
    private static final String PARAM_STRING_CONTENT = "STRING_CONTENT";
    private static final String PARAM_IS_NEW_PROJECT = "IS_NEW_PROJECT";
    private static final String PARAM_SAMPLE_LOCATION = "SAMPLE_LOCATION";
    private static final String PARAM_SRC_FOLDER = "SRC_FOLDER";
    private static final String PARAM_SDK_TARGET = "SDK_TARGET";
    private static final String PARAM_MIN_SDK_VERSION = "MIN_SDK_VERSION";
    private static final String PARAM_TEST_TARGET_PACKAGE = "TEST_TARGET_PCKG";
    private static final String PARAM_TARGET_SELF = "TARGET_SELF";
    private static final String PARAM_TARGET_MAIN = "TARGET_MAIN";
    private static final String PARAM_TARGET_EXISTING = "TARGET_EXISTING";
    private static final String PARAM_REFERENCE_PROJECT = "REFERENCE_PROJECT";
    private static final String PH_ACTIVITIES = "ACTIVITIES";
    private static final String PH_USES_SDK = "USES-SDK";
    private static final String PH_INTENT_FILTERS = "INTENT_FILTERS";
    private static final String PH_STRINGS = "STRINGS";
    private static final String PH_TEST_USES_LIBRARY = "TEST-USES-LIBRARY";
    private static final String PH_TEST_INSTRUMENTATION = "TEST-INSTRUMENTATION";
    private static final String BIN_DIRECTORY = "bin/";
    private static final String BIN_CLASSES_DIRECTORY = "bin/classes/";
    private static final String RES_DIRECTORY = "res/";
    private static final String ASSETS_DIRECTORY = "assets/";
    private static final String DRAWABLE_DIRECTORY = "drawable/";
    private static final String DRAWABLE_HDPI_DIRECTORY = "drawable-" + Density.HIGH.getResourceValue() + "/";
    private static final String DRAWABLE_MDPI_DIRECTORY = "drawable-" + Density.MEDIUM.getResourceValue() + "/";
    private static final String DRAWABLE_LDPI_DIRECTORY = "drawable-" + Density.LOW.getResourceValue() + "/";
    private static final String LAYOUT_DIRECTORY = "layout/";
    private static final String VALUES_DIRECTORY = "values/";
    private static final String GEN_SRC_DIRECTORY = "gen/";
    private static final String TEMPLATES_DIRECTORY = "templates/";
    private static final String TEMPLATE_MANIFEST = "templates/AndroidManifest.template";
    private static final String TEMPLATE_ACTIVITIES = "templates/activity.template";
    private static final String TEMPLATE_USES_SDK = "templates/uses-sdk.template";
    private static final String TEMPLATE_INTENT_LAUNCHER = "templates/launcher_intent_filter.template";
    private static final String TEMPLATE_TEST_USES_LIBRARY = "templates/test_uses-library.template";
    private static final String TEMPLATE_TEST_INSTRUMENTATION = "templates/test_instrumentation.template";
    private static final String TEMPLATE_STRINGS = "templates/strings.template";
    private static final String TEMPLATE_STRING = "templates/string.template";
    private static final String PROJECT_ICON = "ic_launcher.png";
    private static final String ICON_HDPI = "ic_launcher_hdpi.png";
    private static final String ICON_MDPI = "ic_launcher_mdpi.png";
    private static final String ICON_LDPI = "ic_launcher_ldpi.png";
    private static final String STRINGS_FILE = "strings.xml";
    private static final String STRING_APP_NAME = "app_name";
    private static final String STRING_HELLO_WORLD = "hello";
    private static final String[] DEFAULT_DIRECTORIES = new String[]{"bin/", "bin/classes/", "res/", "assets/"};
    private static final String[] RES_DIRECTORIES = new String[]{"drawable/", "layout/", "values/"};
    private static final String[] RES_DENSITY_ENABLED_DIRECTORIES = new String[]{DRAWABLE_HDPI_DIRECTORY, DRAWABLE_MDPI_DIRECTORY, DRAWABLE_LDPI_DIRECTORY, "layout/", "values/"};
    private static final String JAVA_ACTIVITY_TEMPLATE = "java_file.template";
    private static final String LAYOUT_TEMPLATE = "layout.template";
    private static final String MAIN_LAYOUT_XML = "main.xml";
    private final NewProjectWizardState mValues;
    private final IRunnableContext mRunnableContext;
    private final Shell mShell;
    private Object mPackageName;

    public NewProjectCreator(NewProjectWizardState values, IRunnableContext runnableContext, Shell shell) {
        this.mValues = values;
        this.mRunnableContext = runnableContext;
        this.mShell = shell;
    }

    private boolean validateNewProjectLocationIsEmpty(IPath destination) {
        File f = new File(destination.toOSString());
        if (f.isDirectory()) {
            int cfr_ignored_0 = f.list().length;
        }
        return true;
    }

    public boolean createAndroidProjects() {
        final ProjectInfo mainData = this.collectMainPageInfo();
        final ProjectInfo testData = this.collectTestPageInfo();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                NewProjectCreator.this.createProjectAsync(monitor, mainData, testData);
            }
        };
        this.runAsyncOperation(op);
        return true;
    }

    private ProjectInfo collectMainPageInfo() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.mValues.projectName);
        IProjectDescription description = workspace.newProjectDescription(project.getName());
        this.mPackageName = this.mValues.packageName;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(PARAM_PROJECT, this.mValues.projectName);
        parameters.put(PARAM_PACKAGE, this.mPackageName);
        parameters.put(PARAM_APPLICATION, String.valueOf(STRING_PREFIX) + STRING_APP_NAME);
        parameters.put(PARAM_SDK_TOOLS_DIR, AdtUtil.adtPlugin.getOsSdkToolsFolder());
        parameters.put(PARAM_IS_NEW_PROJECT, !this.mValues.useExisting);
        parameters.put(PARAM_SAMPLE_LOCATION, this.mValues.chosenSample);
        parameters.put(PARAM_SRC_FOLDER, this.mValues.sourceFolder);
        parameters.put(PARAM_SDK_TARGET, this.mValues.target);
        parameters.put(PARAM_MIN_SDK_VERSION, this.mValues.minSdk);
        if (this.mValues.createActivity) {
            parameters.put(PARAM_ACTIVITY, this.mValues.activityName);
        }
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put(STRING_APP_NAME, this.mValues.applicationName);
        Path path = new Path(this.mValues.projectLocation.getPath());
        IPath defaultLocation = Platform.getLocation();
        if (!(this.mValues.useDefaultLocation && !this.mValues.useExisting || defaultLocation.isPrefixOf((IPath)path))) {
            description.setLocation((IPath)path);
        }
        if (!(this.mValues.useExisting || this.mValues.useDefaultLocation || this.validateNewProjectLocationIsEmpty((IPath)path))) {
            return null;
        }
        return new ProjectInfo(project, description, parameters, dictionary);
    }

    private ProjectInfo collectTestPageInfo() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void runAsyncOperation(WorkspaceModifyOperation op) {
        block9: {
            block8: {
                try {
                    this.mRunnableContext.run(true, true, (IRunnableWithProgress)op);
                }
                catch (InvocationTargetException e) {
                    t = e.getTargetException();
                    if (t instanceof CoreException) {
                        core = (CoreException)t;
                        if (core.getStatus().getCode() == 275) {
                            MessageDialog.openError((Shell)this.mShell, (String)"Error", (String)"Error: Case Variant Exists");
                        } else {
                            ErrorDialog.openError((Shell)this.mShell, (String)"Error", (String)core.getMessage(), (IStatus)core.getStatus());
                        }
                        break block8;
                    }
                    msg = t.getMessage();
                    t1 = t;
                    ** while (msg == null && t1.getCause() != null)
                }
lbl-1000:
                // 1 sources

                {
                    msg = t1.getMessage();
                    t1 = t1.getCause();
                    continue;
                }
lbl20:
                // 1 sources

                if (msg == null) {
                    msg = t.toString();
                }
                MessageDialog.openError((Shell)this.mShell, (String)"Error", (String)msg);
            }
            e.printStackTrace();
            break block9;
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void createProjectAsync(IProgressMonitor monitor, final ProjectInfo mainData, ProjectInfo testData) throws InvocationTargetException {
        monitor.beginTask("Create Android Project", 100);
        try {
            try {
                IProject mainProject = null;
                if (mainData != null && (mainProject = this.createEclipseProject((IProgressMonitor)new SubProgressMonitor(monitor, 50), mainData.getProject(), mainData.getDescription(), mainData.getParameters(), mainData.getDictionary())) != null) {
                    final IJavaProject javaProject = JavaCore.create((IProject)mainProject);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            IWorkingSet[] workingSets = ((NewProjectCreator)NewProjectCreator.this).mValues.workingSets;
                            if (workingSets.length > 0 && javaProject != null && javaProject.exists()) {
                                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)javaProject, workingSets);
                            }
                            String minSDK = (String)mainData.getParameters().get(NewProjectCreator.PARAM_MIN_SDK_VERSION);
                            String srcFolder = (String)mainData.getParameters().get(NewProjectCreator.PARAM_SRC_FOLDER);
                            String packageName = (String)mainData.getParameters().get(NewProjectCreator.PARAM_PACKAGE);
                            String activityName = (String)mainData.getParameters().get(NewProjectCreator.PARAM_ACTIVITY);
                            ProjectUtils.copyNativeLibrary(javaProject);
                            ManifestFileUtils.modifyManifestFile(javaProject, minSDK);
                            try {
                                ProjectUtils.modifyActivityClass(javaProject, srcFolder, packageName, activityName);
                            }
                            catch (Exception e) {
                                LogUtils.logERROR(e);
                            }
                            ProjectUtils.addAGSLibrary(javaProject);
                        }
                    });
                }
                if (testData != null) {
                    IProject testProject;
                    Map<String, Object> parameters = testData.getParameters();
                    if (parameters.containsKey(PARAM_TARGET_MAIN) && mainProject != null) {
                        parameters.put(PARAM_REFERENCE_PROJECT, mainProject);
                    }
                    if ((testProject = this.createEclipseProject((IProgressMonitor)new SubProgressMonitor(monitor, 50), testData.getProject(), testData.getDescription(), parameters, testData.getDictionary())) != null) {
                        final IJavaProject javaProject = JavaCore.create((IProject)testProject);
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                IWorkingSet[] workingSets = ((NewProjectCreator)NewProjectCreator.this).mValues.workingSets;
                                if (workingSets.length > 0 && javaProject != null && javaProject.exists()) {
                                    PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)javaProject, workingSets);
                                }
                            }
                        });
                    }
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private IProject createEclipseProject(IProgressMonitor monitor, IProject project, IProjectDescription description, Map<String, Object> parameters, Map<String, String> dictionary) throws Exception {
        IProject refProject;
        File sampleDir;
        String target = "android-" + (String)parameters.get(PARAM_MIN_SDK_VERSION);
        boolean legacy = false;
        project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        NewProjectCreator.setupProjectNatures(project, monitor);
        NewProjectCreator.addNatureToProjectDescription(project, "org.eclipse.jdt.core.javanature", monitor);
        NewProjectCreator.addNatureToProjectDescription(project, "com.android.ide.eclipse.adt.AndroidNature", monitor);
        this.addDefaultDirectories(project, "/", DEFAULT_DIRECTORIES, monitor);
        String[] sourceFolders = new String[]{(String)parameters.get(PARAM_SRC_FOLDER), GEN_SRC_DIRECTORY};
        this.addDefaultDirectories(project, "/", sourceFolders, monitor);
        if (legacy) {
            this.addDefaultDirectories(project, RES_DIRECTORY, RES_DIRECTORIES, monitor);
        } else {
            this.addDefaultDirectories(project, RES_DIRECTORY, RES_DENSITY_ENABLED_DIRECTORIES, monitor);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.setupSourceFolders(javaProject, sourceFolders, monitor);
        if (((Boolean)parameters.get(PARAM_IS_NEW_PROJECT)).booleanValue()) {
            File libFolder;
            File proguardcfg;
            this.addManifest(project, parameters, dictionary, monitor);
            this.addIcon(project, legacy, monitor);
            this.addSampleCode(project, sourceFolders[0], parameters, dictionary, monitor);
            if (dictionary.size() > 0) {
                this.addStringDictionaryFile(project, dictionary, monitor);
            }
            if ((proguardcfg = new File(libFolder = new File((String)parameters.get(PARAM_SDK_TOOLS_DIR), "lib"), "proguard.cfg")).exists()) {
                this.addLocalFile(project, proguardcfg, monitor);
            } else {
                File proguardtxt = new File(libFolder, "proguard-project.txt");
                if (proguardtxt.exists()) {
                    this.addLocalFile(project, proguardtxt, monitor);
                }
            }
            javaProject.setOutputLocation(project.getFolder(BIN_CLASSES_DIRECTORY).getFullPath(), monitor);
        }
        if ((sampleDir = (File)parameters.get(PARAM_SAMPLE_LOCATION)) != null) {
            this.copySampleCode(project, sampleDir, parameters, dictionary, monitor);
        }
        if (parameters.containsKey(PARAM_REFERENCE_PROJECT) && (refProject = (IProject)parameters.get(PARAM_REFERENCE_PROJECT)) != null) {
            IProjectDescription desc = project.getDescription();
            desc.setReferencedProjects(new IProject[]{refProject});
            project.setDescription(desc, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            IClasspathEntry entry = JavaCore.newProjectEntry((IPath)refProject.getFullPath(), (IAccessRule[])new IAccessRule[0], (boolean)false, (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
            ProjectHelper.addEntryToClasspath(javaProject, entry);
        }
        this.setTargetSdk(project, target);
        ProjectHelper.fixProject(project);
        return project;
    }

    private void addDefaultDirectories(IProject project, String parentFolder, String[] folders, IProgressMonitor monitor) throws CoreException {
        String[] stringArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder;
            String name = stringArray[n2];
            if (name.length() > 0 && !(folder = project.getFolder(String.valueOf(parentFolder) + name)).exists()) {
                folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            ++n2;
        }
    }

    private void addManifest(IProject project, Map<String, Object> parameters, Map<String, String> dictionary, IProgressMonitor monitor) throws CoreException, IOException {
        IFile file = project.getFile("AndroidManifest.xml");
        if (!file.exists()) {
            String manifestTemplate = AdtPlugin.readEmbeddedTextFile((String)TEMPLATE_MANIFEST);
            if ((manifestTemplate = this.replaceParameters(manifestTemplate, parameters)) == null) {
                AdtPlugin.logAndPrintError(null, (String)"Create Project", (String)"Failed to generate the Android manifest. Missing template %s", (Object[])new Object[]{TEMPLATE_MANIFEST});
                return;
            }
            if (parameters.containsKey(PARAM_ACTIVITY)) {
                String activityTemplate = AdtPlugin.readEmbeddedTextFile((String)TEMPLATE_ACTIVITIES);
                String name = (String)parameters.get(PARAM_ACTIVITY);
                if (name.indexOf(46) == -1) {
                    parameters = new HashMap<String, Object>(parameters);
                    parameters.put(PARAM_ACTIVITY, "." + name);
                }
                String activities = this.replaceParameters(activityTemplate, parameters);
                String intent = AdtPlugin.readEmbeddedTextFile((String)TEMPLATE_INTENT_LAUNCHER);
                if (activities != null) {
                    if (intent != null) {
                        activities = activities.replaceAll(PH_INTENT_FILTERS, intent);
                    }
                    manifestTemplate = manifestTemplate.replaceAll(PH_ACTIVITIES, activities);
                }
            } else {
                manifestTemplate = manifestTemplate.replaceAll(PH_ACTIVITIES, "");
            }
            if (parameters.containsKey(PARAM_TEST_TARGET_PACKAGE)) {
                String instru;
                String usesLibrary = AdtPlugin.readEmbeddedTextFile((String)TEMPLATE_TEST_USES_LIBRARY);
                if (usesLibrary != null) {
                    manifestTemplate = manifestTemplate.replaceAll(PH_TEST_USES_LIBRARY, usesLibrary);
                }
                if ((instru = AdtPlugin.readEmbeddedTextFile((String)TEMPLATE_TEST_INSTRUMENTATION)) != null) {
                    manifestTemplate = manifestTemplate.replaceAll(PH_TEST_INSTRUMENTATION, instru);
                }
                manifestTemplate = this.replaceParameters(manifestTemplate, parameters);
            } else {
                manifestTemplate = manifestTemplate.replaceAll(PH_TEST_USES_LIBRARY, "");
                manifestTemplate = manifestTemplate.replaceAll(PH_TEST_INSTRUMENTATION, "");
            }
            String minSdkVersion = (String)parameters.get(PARAM_MIN_SDK_VERSION);
            if (minSdkVersion != null && minSdkVersion.length() > 0) {
                String usesSdkTemplate = AdtPlugin.readEmbeddedTextFile((String)TEMPLATE_USES_SDK);
                if (usesSdkTemplate != null) {
                    String usesSdk = this.replaceParameters(usesSdkTemplate, parameters);
                    manifestTemplate = manifestTemplate.replaceAll(PH_USES_SDK, usesSdk);
                }
            } else {
                manifestTemplate = manifestTemplate.replaceAll(PH_USES_SDK, "");
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(manifestTemplate.getBytes("UTF-8"));
            file.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private void addStringDictionaryFile(IProject project, Map<String, String> strings, IProgressMonitor monitor) throws CoreException, IOException {
        IFile file = project.getFile("res//values//strings.xml");
        if (!file.exists()) {
            String stringDefinitionTemplate = AdtPlugin.readEmbeddedTextFile((String)TEMPLATE_STRINGS);
            String stringTemplate = AdtPlugin.readEmbeddedTextFile((String)TEMPLATE_STRING);
            Set<String> stringNames = strings.keySet();
            StringBuilder stringNodes = new StringBuilder();
            for (String key : stringNames) {
                String value = strings.get(key);
                String stringDef = stringTemplate.replace(PARAM_STRING_NAME, key);
                stringDef = stringDef.replace(PARAM_STRING_CONTENT, value);
                if (stringNodes.length() > 0) {
                    stringNodes.append('\n');
                }
                stringNodes.append(stringDef);
            }
            stringDefinitionTemplate = stringDefinitionTemplate.replace(PH_STRINGS, stringNodes.toString());
            ByteArrayInputStream stream = new ByteArrayInputStream(stringDefinitionTemplate.getBytes("UTF-8"));
            file.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private void addIcon(IProject project, boolean legacy, IProgressMonitor monitor) throws CoreException {
        if (legacy) {
            IFile file = project.getFile("res//drawable//ic_launcher.png");
            if (!file.exists()) {
                this.addFile(file, AdtPlugin.readEmbeddedFile((String)"templates/ic_launcher_mdpi.png"), monitor);
            }
        } else {
            IFile file = project.getFile("res//" + DRAWABLE_HDPI_DIRECTORY + "/" + PROJECT_ICON);
            if (!file.exists()) {
                this.addFile(file, AdtPlugin.readEmbeddedFile((String)"templates/ic_launcher_hdpi.png"), monitor);
            }
            if (!(file = project.getFile("res//" + DRAWABLE_MDPI_DIRECTORY + "/" + PROJECT_ICON)).exists()) {
                this.addFile(file, AdtPlugin.readEmbeddedFile((String)"templates/ic_launcher_mdpi.png"), monitor);
            }
            if (!(file = project.getFile("res//" + DRAWABLE_LDPI_DIRECTORY + "/" + PROJECT_ICON)).exists()) {
                this.addFile(file, AdtPlugin.readEmbeddedFile((String)"templates/ic_launcher_ldpi.png"), monitor);
            }
        }
    }

    private void addFile(IFile dest, byte[] source, IProgressMonitor monitor) throws CoreException {
        if (source != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(source);
            dest.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private void addSampleCode(IProject project, String sourceFolder, Map<String, Object> parameters, Map<String, String> dictionary, IProgressMonitor monitor) throws CoreException, IOException {
        IFolder layoutfolder;
        String activityJava;
        IFile file;
        String[] components;
        IFolder pkgFolder = project.getFolder(sourceFolder);
        String packageName = (String)parameters.get(PARAM_PACKAGE);
        String activityName = (String)parameters.get(PARAM_ACTIVITY);
        HashMap<String, Object> java_activity_parameters = new HashMap<String, Object>(parameters);
        java_activity_parameters.put(PARAM_IMPORT_RESOURCE_CLASS, "");
        if (activityName != null) {
            String resourcePackageClass = null;
            int lastDotIndex = activityName.lastIndexOf(46);
            if (lastDotIndex != -1) {
                if (lastDotIndex > 0) {
                    resourcePackageClass = String.valueOf(packageName) + "." + "R";
                }
                packageName = activityName.startsWith(".") ? String.valueOf(packageName) + activityName.substring(0, lastDotIndex) : activityName.substring(0, lastDotIndex);
                activityName = activityName.substring(lastDotIndex + 1);
            }
            java_activity_parameters.put(PARAM_ACTIVITY, activityName);
            java_activity_parameters.put(PARAM_PACKAGE, packageName);
            if (resourcePackageClass != null) {
                String importResourceClass = "\nimport " + resourcePackageClass + ";";
                java_activity_parameters.put(PARAM_IMPORT_RESOURCE_CLASS, importResourceClass);
            }
        }
        String[] stringArray = components = packageName.split("\\.");
        int n = components.length;
        int importResourceClass = 0;
        while (importResourceClass < n) {
            String component = stringArray[importResourceClass];
            if (!(pkgFolder = pkgFolder.getFolder(component)).exists()) {
                pkgFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            ++importResourceClass;
        }
        if (activityName != null && !(file = pkgFolder.getFile(activityJava = String.valueOf(activityName) + ".java")).exists()) {
            this.copyFile(JAVA_ACTIVITY_TEMPLATE, file, java_activity_parameters, monitor, false);
        }
        if (!(file = (layoutfolder = project.getFolder(RES_DIRECTORY).getFolder(LAYOUT_DIRECTORY)).getFile(MAIN_LAYOUT_XML)).exists()) {
            this.copyFile(LAYOUT_TEMPLATE, file, parameters, monitor, true);
            if (activityName != null) {
                dictionary.put(STRING_HELLO_WORLD, String.format("Hello World, %1$s!", activityName));
            } else {
                dictionary.put(STRING_HELLO_WORLD, "Hello World!");
            }
        }
    }

    private void copySampleCode(IProject project, File sampleDir, Map<String, Object> parameters, Map<String, String> dictionary, IProgressMonitor monitor) throws CoreException {
    }

    private void addLocalFile(IProject project, File source, IProgressMonitor monitor) throws FileNotFoundException, CoreException {
        IFile dest = project.getFile(source.getName());
        if (!dest.exists()) {
            FileInputStream stream = new FileInputStream(source);
            dest.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private void setupSourceFolders(IJavaProject javaProject, String[] sourceFolders, IProgressMonitor monitor) throws JavaModelException {
        IProject project = javaProject.getProject();
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        entries = this.removeSourceClasspath(entries, (IContainer)project);
        String[] stringArray = sourceFolders;
        int n = sourceFolders.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceFolder = stringArray[n2];
            IFolder srcFolder = project.getFolder(sourceFolder);
            entries = this.removeSourceClasspath(entries, (IContainer)srcFolder);
            entries = ProjectHelper.addEntryToClasspath(entries, JavaCore.newSourceEntry((IPath)srcFolder.getFullPath()));
            ++n2;
        }
        javaProject.setRawClasspath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
    }

    private IClasspathEntry[] removeSourceClasspath(IClasspathEntry[] entries, IContainer folder) {
        if (folder == null) {
            return entries;
        }
        IClasspathEntry source = JavaCore.newSourceEntry((IPath)folder.getFullPath());
        int n = entries.length;
        int i = n - 1;
        while (i >= 0) {
            if (entries[i].equals(source)) {
                IClasspathEntry[] newEntries = new IClasspathEntry[n - 1];
                if (i > 0) {
                    System.arraycopy(entries, 0, newEntries, 0, i);
                }
                if (i < n - 1) {
                    System.arraycopy(entries, i + 1, newEntries, i, n - i - 1);
                }
                --n;
                entries = newEntries;
            }
            --i;
        }
        return entries;
    }

    private void copyFile(String resourceFilename, IFile destFile, Map<String, Object> parameters, IProgressMonitor monitor, boolean reformat) throws CoreException, IOException {
        String template = AdtPlugin.readEmbeddedTextFile((String)(TEMPLATES_DIRECTORY + resourceFilename));
        template = this.replaceParameters(template, parameters);
        ByteArrayInputStream stream = new ByteArrayInputStream(template.getBytes("UTF-8"));
        destFile.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
    }

    private String replaceParameters(String str, Map<String, Object> parameters) {
        if (parameters == null) {
            AdtPlugin.log((int)4, (String)"NPW replace parameters: null parameter map. String: '%s'", (Object[])new Object[]{str});
            return str;
        }
        if (str == null) {
            AdtPlugin.log((int)4, (String)"NPW replace parameters: null template string", (Object[])new Object[0]);
            return str;
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (entry == null || !(entry.getValue() instanceof String)) continue;
            Object value = entry.getValue();
            if (value == null) {
                AdtPlugin.log((int)4, (String)"NPW replace parameters: null value for key '%s' in template '%s'", (Object[])new Object[]{entry.getKey(), str});
                continue;
            }
            str = str.replaceAll(entry.getKey(), (String)value);
        }
        return str;
    }

    private static void addNatureToProjectDescription(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            if (natureId.equals("com.android.ide.eclipse.adt.AndroidNature")) {
                System.arraycopy(natures, 0, newNatures, 1, natures.length);
                newNatures[0] = natureId;
            } else {
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = natureId;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetSdk(IProject project, String target) throws Exception {
        if (project == null || target == null) {
            return;
        }
        IProject iProject = project;
        synchronized (iProject) {
            Properties properties = new Properties();
            IPath path = project.getLocation().append("project.properties");
            properties.setProperty("target", target);
            FileOutputStream os = new FileOutputStream(path.toFile());
            properties.store(os, " project target");
            os.flush();
            ((OutputStream)os).close();
        }
    }

    public static synchronized void setupProjectNatures(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project == null || !project.isOpen()) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        NewProjectCreator.addNatureToProjectDescription(project, "org.eclipse.jdt.core.javanature", monitor);
        NewProjectCreator.addNatureToProjectDescription(project, "com.android.ide.eclipse.adt.AndroidNature", monitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectInfo {
        private final IProject mProject;
        private final IProjectDescription mDescription;
        private final Map<String, Object> mParameters;
        private final HashMap<String, String> mDictionary;

        public ProjectInfo(IProject project, IProjectDescription description, Map<String, Object> parameters, HashMap<String, String> dictionary) {
            this.mProject = project;
            this.mDescription = description;
            this.mParameters = parameters;
            this.mDictionary = dictionary;
        }

        public IProject getProject() {
            return this.mProject;
        }

        public IProjectDescription getDescription() {
            return this.mDescription;
        }

        public Map<String, Object> getParameters() {
            return this.mParameters;
        }

        public HashMap<String, String> getDictionary() {
            return this.mDictionary;
        }
    }
}

