/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.project;

import com.esri.arcgis.android.core.project.NewProjectWizardState;
import com.esri.arcgis.android.core.project.ProjectNamePage;
import com.esri.arcgis.android.core.project.support.AdtUtil;
import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class ApplicationInfoPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private static final String JDK_15 = "1.5";
    private static final String DUMMY_PACKAGE = "your.package.namespace";
    static final String ACTIVITY_NAME_SUFFIX = "Activity";
    private final NewProjectWizardState mValues;
    private Text mApplicationText;
    private Text mPackageText;
    private Text mActivityText;
    private Button mCreateActivityCheckbox;
    private boolean mIgnore;
    private String[] targetLabels = new String[]{"Android 1.5", "Android 1.6", "Android 2.1", "Android 2.2", "Android 2.3.1", "Android 2.3.3", "Android Honeycomb(Preview)"};
    private String[] apiLevels = new String[]{"3", "4", "7", "8", "9", "10", "Honeycomb"};
    private String defultApi = "8";

    ApplicationInfoPage(NewProjectWizardState values) {
        super("appInfo");
        this.mValues = values;
        this.setTitle("Application Info");
        this.setDescription("Configure the new Android Project");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label applicationLabel = new Label(container, 0);
        applicationLabel.setText("Application Name:");
        this.mApplicationText = new Text(container, 2048);
        this.mApplicationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mApplicationText.addModifyListener((ModifyListener)this);
        Label packageLabel = new Label(container, 0);
        packageLabel.setText("Package Name:");
        this.mPackageText = new Text(container, 2048);
        this.mPackageText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mPackageText.addModifyListener((ModifyListener)this);
        this.mCreateActivityCheckbox = new Button(container, 32);
        this.mCreateActivityCheckbox.setText("Create Activity:");
        this.mCreateActivityCheckbox.addSelectionListener((SelectionListener)this);
        this.mActivityText = new Text(container, 2048);
        this.mActivityText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mActivityText.addModifyListener((ModifyListener)this);
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.mIgnore = true;
                if (this.mValues.applicationName != null) {
                    this.mApplicationText.setText(this.mValues.applicationName);
                }
                if (this.mValues.packageName != null) {
                    this.mPackageText.setText(this.mValues.packageName);
                } else {
                    this.mPackageText.setText(DUMMY_PACKAGE);
                }
                this.mCreateActivityCheckbox.setSelection(this.mValues.createActivity);
                this.mActivityText.setEnabled(this.mValues.createActivity);
                if (this.mValues.activityName != null) {
                    this.mActivityText.setText(this.mValues.activityName);
                }
                if (this.mValues.minSdk != null) {
                    this.mValues.minSdk.length();
                }
            }
            finally {
                this.mIgnore = false;
            }
        }
        this.mPackageText.setFocus();
        this.mPackageText.selectAll();
        this.validatePage();
    }

    protected void setSdkTargets(String target) {
        String[] items = new String[this.targetLabels.length];
        int i = 0;
        int n = this.targetLabels.length;
        while (i < n) {
            items[i] = String.valueOf(this.apiLevels[i]) + " (" + this.targetLabels[i] + ")";
            if (target.equalsIgnoreCase(this.apiLevels[i])) {
            }
            ++i;
        }
        try {
            this.mIgnore = true;
            this.mValues.minSdk = target;
        }
        finally {
            this.mIgnore = false;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isPageComplete() {
        if (this.mValues.useExisting) {
            return true;
        }
        if (this.mValues.packageName == null) {
            return false;
        }
        return super.isPageComplete();
    }

    public void modifyText(ModifyEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mApplicationText) {
            this.mValues.applicationName = this.mApplicationText.getText().trim();
            this.mValues.applicationNameModifiedByUser = true;
        } else if (source == this.mPackageText) {
            this.mValues.packageName = this.mPackageText.getText().trim();
            this.mValues.packageNameModifiedByUser = true;
        } else if (source == this.mActivityText) {
            this.mValues.activityName = this.mActivityText.getText().trim();
            this.mValues.activityNameModifiedByUser = true;
        }
        this.validatePage();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mCreateActivityCheckbox) {
            this.mValues.createActivity = this.mCreateActivityCheckbox.getSelection();
            this.mActivityText.setEnabled(this.mValues.createActivity);
        }
        this.validatePage();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void validatePage() {
        IStatus validSourceFolder;
        IStatus validMinSdk;
        IStatus validActivity;
        IStatus status = this.validatePackage(this.mValues.packageName);
        if ((status == null || status.getSeverity() != 4) && (validActivity = this.validateActivity()) != null) {
            status = validActivity;
        }
        if ((status == null || status.getSeverity() != 4) && (validMinSdk = this.validateMinSdk()) != null) {
            status = validMinSdk;
        }
        if ((status == null || status.getSeverity() != 4) && (validSourceFolder = this.validateSourceFolder()) != null) {
            status = validSourceFolder;
        }
        if (status == null || status.getSeverity() != 4) {
            status = this.validateADTPlugin();
        }
        if ((status == null || status.getSeverity() != 4) && this.mValues.createPairProject) {
            IStatus validTestPackage;
            IStatus validTestProject = ProjectNamePage.validateProjectName(this.mValues.testProjectName);
            if (validTestProject != null) {
                status = validTestProject;
            }
            if ((status == null || status.getSeverity() != 4) && (validTestPackage = this.validatePackage(this.mValues.testPackageName)) != null) {
                status = new Status(validTestPackage.getSeverity(), "com.esri.arcgis.android.core", String.valueOf(validTestPackage.getMessage()) + " (in test package)");
            }
            if ((status == null || status.getSeverity() != 4) && this.mValues.projectName.equals(this.mValues.testProjectName)) {
                status = new Status(4, "com.esri.arcgis.android.core", "The main project name and the test project name must be different.");
            }
        }
        this.setPageComplete(status == null || status.getSeverity() != 4);
        if (status != null) {
            this.setMessage(status.getMessage(), status.getSeverity() == 4 ? 3 : 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    private IStatus validateSourceFolder() {
        this.mValues.sourceFolder = "src";
        if (!this.mValues.useExisting || !this.mValues.createActivity) {
            return null;
        }
        String osTarget = this.mValues.activityName;
        if (osTarget.indexOf(46) == -1) {
            osTarget = String.valueOf(this.mValues.packageName) + File.separator + osTarget;
        } else if (osTarget.indexOf(46) == 0) {
            osTarget = String.valueOf(this.mValues.packageName) + osTarget;
        }
        osTarget = String.valueOf(osTarget.replace('.', File.separatorChar)) + ".java";
        File projectDir = this.mValues.projectLocation;
        File[] allDirs = projectDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (allDirs != null) {
            boolean found = false;
            File[] fileArray = allDirs;
            int n = allDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Path path = new Path(f.getAbsolutePath());
                File java_activity = path.append(osTarget).toFile();
                if (java_activity.isFile()) {
                    this.mValues.sourceFolder = f.getName();
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                String projectPath = projectDir.getPath();
                if (allDirs.length > 0) {
                    return new Status(4, "com.esri.arcgis.android.core", String.format("%1$s can not be found under %2$s.", osTarget, projectPath));
                }
                return new Status(4, "com.esri.arcgis.android.core", String.format("No source folders can be found in %1$s.", projectPath));
            }
        }
        return null;
    }

    private IStatus validateMinSdk() {
        return null;
    }

    private IStatus validateADTPlugin() {
        if (!AdtUtil.isAdtPluginExisted()) {
            return new Status(4, "com.esri.arcgis.android.core", "ADT plugin is not existed in the IDE.");
        }
        return null;
    }

    private IStatus validatePackage(String packageFieldContents) {
        if (packageFieldContents == null || packageFieldContents.length() == 0) {
            return new Status(4, "com.esri.arcgis.android.core", "Package name must be specified.");
        }
        if (packageFieldContents.equals(DUMMY_PACKAGE)) {
            return new Status(4, "com.esri.arcgis.android.core", "Package name must be specified.");
        }
        IStatus status = JavaConventions.validatePackageName((String)packageFieldContents, (String)JDK_15, (String)JDK_15);
        if (!status.isOK()) {
            return status;
        }
        if (packageFieldContents.indexOf(46) == -1) {
            return new Status(4, "com.esri.arcgis.android.core", "Package name must have at least two identifiers.");
        }
        return null;
    }

    private IStatus validateActivity() {
        IStatus status;
        if (!this.mValues.createActivity) {
            return null;
        }
        String activityFieldContents = this.mValues.activityName;
        if (activityFieldContents == null || activityFieldContents.length() == 0) {
            return new Status(4, "com.esri.arcgis.android.core", "Activity name must be specified.");
        }
        if (ACTIVITY_NAME_SUFFIX.equals(activityFieldContents)) {
            return new Status(4, "com.esri.arcgis.android.core", "Enter a valid activity name");
        }
        if (activityFieldContents.contains("..")) {
            return new Status(4, "com.esri.arcgis.android.core", "Package segments in activity name cannot be empty (..)");
        }
        String packageName = "";
        int pos = activityFieldContents.lastIndexOf(46);
        if (pos >= 0) {
            packageName = activityFieldContents.substring(0, pos);
            if (packageName.startsWith(".")) {
                packageName = packageName.substring(1);
            }
            activityFieldContents = activityFieldContents.substring(pos + 1);
        }
        if (activityFieldContents.length() > 0 && activityFieldContents.charAt(0) == '.') {
            activityFieldContents = activityFieldContents.substring(1);
        }
        if (!(status = JavaConventions.validateTypeVariableName((String)activityFieldContents, (String)JDK_15, (String)JDK_15)).isOK()) {
            return status;
        }
        if (packageName.length() > 0 && !(status = JavaConventions.validatePackageName((String)packageName, (String)JDK_15, (String)JDK_15)).isOK()) {
            return new Status(4, "com.esri.arcgis.android.core", String.valueOf(status.getMessage()) + " (in the activity name)");
        }
        return null;
    }

    public void onSdkLoaded() {
    }

    public void onProjectTargetChange(IProject changedProject) {
    }

    public static String suggestTestApplicationName(String applicationName) {
        if (applicationName == null) {
            applicationName = "";
        }
        if (applicationName.indexOf(32) != -1) {
            return String.valueOf(applicationName) + " Test";
        }
        return String.valueOf(applicationName) + "Test";
    }

    public static String suggestTestProjectName(String projectName) {
        if (projectName == null) {
            projectName = "";
        }
        if (projectName.length() > 0 && Character.isUpperCase(projectName.charAt(0))) {
            return String.valueOf(projectName) + "Test";
        }
        return String.valueOf(projectName) + "-test";
    }

    public static String suggestTestPackage(String packagePath) {
        if (packagePath == null) {
            packagePath = "";
        }
        return String.valueOf(packagePath) + ".test";
    }
}

