/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.project;

import com.esri.arcgis.android.core.Activator;
import com.esri.arcgis.android.core.LogUtils;
import com.esri.arcgis.android.core.project.AGSClasspathContainer;
import com.esri.arcgis.android.core.project.ProjectHelper;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;

public class AGSClasspathLibraryUtil {
    static final String LIB_PATH = "lib";
    static final String JACKSON_CORE_PATH = "lib/jackson-core-lgpl-1.9.5.jar";
    static final String JACKSON_MAPPER_PATH = "lib/jackson-mapper-lgpl-1.9.5.jar";
    static final String AGS_ANDROID_PATH = "lib/ArcGIS_Android.jar";
    static final String DOC_ZIP = "doc.zip";
    static final String DOC_BOUNDLE_ID = "com.esri.arcgis.android.doc";
    static final String CORE_BUNLDE_ID = "com.esri.arcgis.android.core";

    public static void updateAGSClasspathContainer(IJavaProject androidProject) {
        try {
            IClasspathContainer container = AGSClasspathLibraryUtil.getLibraryContainer(androidProject);
            if (container != null) {
                JavaCore.setClasspathContainer((IPath)new Path("com.esri.arcgis.android.LIBRARIES"), (IJavaProject[])new IJavaProject[]{androidProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            LogUtils.logERROR(e);
        }
    }

    private static IClasspathEntry[] getArcGISAndroidClasspaths() throws Exception {
        return new IClasspathEntry[]{AGSClasspathLibraryUtil.getArcGISForAndroidJar(), AGSClasspathLibraryUtil.getJacksonCoreJar(), AGSClasspathLibraryUtil.getJacksonMapperJar()};
    }

    private static IClasspathContainer getLibraryContainer(IJavaProject javaProject) throws Exception {
        try {
            IClasspathEntry[] rawClasspath;
            IClasspathEntry[] oldRawClasspath = rawClasspath = javaProject.getRawClasspath();
            boolean foundLibrariesContainer = false;
            IClasspathEntry[] iClasspathEntryArray = rawClasspath;
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                String path;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                int kind = entry.getEntryKind();
                if (kind == 5 && "com.esri.arcgis.android.LIBRARIES".equals(path = entry.getPath().toString())) {
                    foundLibrariesContainer = true;
                    break;
                }
                ++n2;
            }
            if (!foundLibrariesContainer) {
                IClasspathEntry libEntry = JavaCore.newContainerEntry((IPath)new Path("com.esri.arcgis.android.LIBRARIES"), (boolean)true);
                rawClasspath = ProjectHelper.addEntryToClasspath(rawClasspath, libEntry);
            }
            if (rawClasspath != oldRawClasspath) {
                javaProject.setRawClasspath(rawClasspath, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return new AGSClasspathContainer(AGSClasspathLibraryUtil.getArcGISAndroidClasspaths(), (IPath)new Path("com.esri.arcgis.android.LIBRARIES"), "ArcGIS for Android 2.0.0", 1);
    }

    private static IClasspathEntry getArcGISForAndroidJar() throws Exception {
        URL docurl;
        String lib = AGSClasspathLibraryUtil.getLibURLString(AGS_ANDROID_PATH);
        Bundle docbundle = Platform.getBundle((String)DOC_BOUNDLE_ID);
        IClasspathAttribute attr = null;
        if (docbundle != null && (docurl = FileLocator.find((Bundle)docbundle, (IPath)new Path(DOC_ZIP), null)) != null) {
            URL fileURL = null;
            try {
                fileURL = FileLocator.toFileURL((URL)docurl);
                if (fileURL != null) {
                    URL APIURL = new URL("jar:file:" + fileURL.getPath() + "!/api");
                    String docpath = APIURL.toExternalForm();
                    attr = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)docpath);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (attr != null) {
            return JavaCore.newLibraryEntry((IPath)new Path(lib), null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{attr}, (boolean)true);
        }
        return JavaCore.newLibraryEntry((IPath)new Path(lib), null, null, null, null, (boolean)true);
    }

    private static IClasspathEntry getJacksonCoreJar() throws Exception {
        String lib = AGSClasspathLibraryUtil.getLibURLString(JACKSON_CORE_PATH);
        return JavaCore.newLibraryEntry((IPath)new Path(lib), null, null, null, null, (boolean)true);
    }

    private static IClasspathEntry getJacksonMapperJar() throws Exception {
        String lib = AGSClasspathLibraryUtil.getLibURLString(JACKSON_MAPPER_PATH);
        return JavaCore.newLibraryEntry((IPath)new Path(lib), null, null, null, null, (boolean)true);
    }

    private static String getLibURLString(String libname) throws Exception {
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(libname), null);
        return FileLocator.toFileURL((URL)url).getPath();
    }
}

