/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.commands;

import com.esri.arcgis.android.core.commands.Service;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class SimpleTypeTransfer
extends ByteArrayTransfer {
    private static final String MYTYPENAME = "my_type_name";
    private static final int MYTYPEID = SimpleTypeTransfer.registerType((String)"my_type_name");
    private static SimpleTypeTransfer _instance = new SimpleTypeTransfer();

    private SimpleTypeTransfer() {
    }

    public static SimpleTypeTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof Object[]) || ((Object[])object).length == 0) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream writeOut = new DataOutputStream(out);
                int i = 0;
                int length = ((Object[])object).length;
                while (i < length) {
                    Service service = (Service)((Object[])object)[i];
                    byte[] buffer = service.getName().getBytes();
                    writeOut.writeInt(buffer.length);
                    writeOut.write(buffer);
                    buffer = service.getType().getBytes();
                    writeOut.writeInt(buffer.length);
                    writeOut.write(buffer);
                    buffer = service.getUrl().getBytes();
                    writeOut.writeInt(buffer.length);
                    writeOut.write(buffer);
                    ++i;
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            Service[] myData = new Service[]{};
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                DataInputStream readIn = new DataInputStream(in);
                while (readIn.available() > 20) {
                    Service datum = new Service();
                    int size = readIn.readInt();
                    byte[] name = new byte[size];
                    readIn.read(name);
                    datum.setName(new String(name));
                    size = readIn.readInt();
                    name = new byte[size];
                    readIn.read(name);
                    datum.setType(new String(name));
                    size = readIn.readInt();
                    name = new byte[size];
                    readIn.read(name);
                    datum.setUrl(new String(name));
                    Service[] newMyData = new Service[myData.length + 1];
                    System.arraycopy(myData, 0, newMyData, 0, myData.length);
                    newMyData[myData.length] = datum;
                    myData = newMyData;
                }
                readIn.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
            return myData;
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{MYTYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{MYTYPEID};
    }
}

