/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.commands;

import com.esri.arcgis.android.core.Activator;
import com.esri.arcgis.android.core.commands.Catalog;
import com.esri.arcgis.android.core.commands.MapService;
import com.esri.arcgis.android.core.commands.Messages;
import com.esri.arcgis.android.core.commands.Service;
import com.esri.arcgis.android.core.commands.URLChangeListener;
import com.esri.arcgis.android.core.commands.URLInputField;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ServiceChooser
extends Composite
implements URLChangeListener {
    private static final String SPATIAL_REFERENCE_CONFLICT = Messages.ServiceChooser_0;
    private static final String SPATIAL_REFERENCE_CONFLICT_BASE = String.valueOf(Messages.ServiceChooser_1) + Messages.ServiceChooser_2;
    private static final String REORDER_DELETE_MAP = Messages.ServiceChooser_3;
    private static final String ADD_MAP = Messages.ServiceChooser_4;
    private static final String ENTER_URL = Messages.ServiceChooser_5;
    private TreeViewer tv1;
    private ArrayList<Catalog> cataloglist = new ArrayList();
    private TreeViewer tv2;
    private ArrayList<Service> servicelist = new ArrayList();
    private Image folderimage;
    private Image mapimage;
    private Image mapimage_warning;
    private ArrayList<TreeItemChangedListener> treeItemChangedListeners;
    private TreeItem selectedTreeItem;
    private TreeItem selectedTreeItem2;
    private boolean spatialRefConflict;
    private boolean spatialRefConflictwithBase;

    public ServiceChooser(Composite parent, int style) {
        super(parent, style);
        try {
            this.folderimage = new Image((Device)this.getDisplay(), FileLocator.openStream((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/folder.gif"), (boolean)false));
            this.mapimage = new Image((Device)this.getDisplay(), FileLocator.openStream((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/localmap.gif"), (boolean)false));
            this.mapimage_warning = new Image((Device)this.getDisplay(), FileLocator.openStream((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/localmap_warning.gif"), (boolean)false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.createControl();
    }

    public boolean isSpatialRefConflict() {
        return this.spatialRefConflict;
    }

    public void calcSpatialRefConflict() {
        this.spatialRefConflict = false;
        this.spatialRefConflictwithBase = false;
        if (this.servicelist.size() == 0) {
            this.spatialRefConflict = false;
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        MapService bms = this.servicelist.get(0).getMapService();
        for (Service service : this.servicelist) {
            String spatialref;
            MapService ms = service.getMapService();
            if (ms == null || !ms.isTile() || list.contains(spatialref = ms.getWkid())) continue;
            list.add(spatialref);
        }
        if (list.size() == 0) {
            this.spatialRefConflict = false;
        } else if (list.size() == 1) {
            if (!bms.isTile() && !list.contains(bms.getWkid())) {
                this.spatialRefConflict = true;
                this.spatialRefConflictwithBase = true;
            }
        } else {
            this.spatialRefConflict = true;
        }
    }

    private void createControl() {
        this.setLayout((Layout)new FormLayout());
        final Sash sash = new Sash((Composite)this, 512);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(50, 0);
        sash.setLayoutData((Object)fd);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((FormData)sash.getLayoutData()).left = new FormAttachment(0, e.x);
                sash.getParent().layout();
            }
        });
        Composite left = new Composite((Composite)this, 2048);
        FormData fd1 = new FormData();
        fd1.top = new FormAttachment(0, 0);
        fd1.bottom = new FormAttachment(100, 0);
        fd1.left = new FormAttachment(0, 0);
        fd1.right = new FormAttachment((Control)sash, 0);
        left.setLayoutData((Object)fd1);
        left.setLayout((Layout)new GridLayout());
        this.tv1 = new TreeViewer(left, 0);
        this.tv1.setContentProvider((IContentProvider)new ServiceContentProvider());
        this.tv1.setLabelProvider((IBaseLabelProvider)new ServiceLabelProvider());
        GridData gdtv1 = new GridData(1808);
        this.tv1.getTree().setLayoutData((Object)gdtv1);
        this.tv1.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                ServiceChooser.this.selectedTreeItem = ServiceChooser.this.tv1.getTree().getItem(point);
            }
        });
        this.createMenu();
        this.tv1.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof Service) {
                    ServiceChooser.this.addService(element);
                }
            }
        });
        this.tv1.getTree().setToolTipText(ADD_MAP);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 7;
        final Object[] dragSelection = new Object[1];
        this.tv1.addDragSupport(operations, types, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ArrayList list = new ArrayList();
                ISelection selection = ServiceChooser.this.tv1.getSelection();
                StructuredSelection ss = (StructuredSelection)selection;
                for (Object object : ss) {
                    if (!(object instanceof Service) || ServiceChooser.this.contains((Service)object)) continue;
                    list.add(object);
                }
                if (!list.isEmpty()) {
                    event.doit = true;
                    dragSelection[0] = list.toArray();
                } else {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = ServiceChooser.this.javaToNative(dragSelection[0]);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        Composite right = new Composite((Composite)this, 2048);
        FormData fd2 = new FormData();
        fd2.top = new FormAttachment(0, 0);
        fd2.bottom = new FormAttachment(100, 0);
        fd2.left = new FormAttachment((Control)sash, 0);
        fd2.right = new FormAttachment(100, 0);
        right.setLayoutData((Object)fd2);
        right.setLayout((Layout)new GridLayout());
        this.tv2 = new TreeViewer(right, 0);
        GridData gdlv = new GridData(1808);
        this.tv2.getTree().setLayoutData((Object)gdlv);
        this.tv2.setContentProvider((IContentProvider)new ServiceContentProvider());
        this.tv2.setLabelProvider((IBaseLabelProvider)new ServiceLabelProvider());
        this.tv2.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                ServiceChooser.this.selectedTreeItem2 = ServiceChooser.this.tv2.getTree().getItem(point);
            }
        });
        this.createMenu2();
        this.tv2.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof Service) {
                    Service service = (Service)element;
                    if (ServiceChooser.this.servicelist.contains(service)) {
                        ServiceChooser.this.servicelist.remove((Service)element);
                        ServiceChooser.this.tv2.setInput((Object)ServiceChooser.this.servicelist);
                        ServiceChooser.this.notifyTreeItemChangedListener((Widget)ServiceChooser.this.tv2.getTree());
                    }
                }
            }
        });
        this.tv2.getTree().setToolTipText(REORDER_DELETE_MAP);
        final StructuredSelection[] dragSelection2 = new StructuredSelection[1];
        this.tv2.addDragSupport(operations, types, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ISelection selection = ServiceChooser.this.tv2.getSelection();
                if (!selection.isEmpty()) {
                    event.doit = true;
                    dragSelection2[0] = (StructuredSelection)selection;
                } else {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = ServiceChooser.this.javaToNative(dragSelection2[0].toArray());
            }

            public void dragFinished(DragSourceEvent event) {
                Object[] ss;
                Object[] objectArray = ss = dragSelection2[0].toArray();
                int n = ss.length;
                int n2 = 0;
                while (n2 < n) {
                    Object service = objectArray[n2];
                    ServiceChooser.this.servicelist.remove((Service)service);
                    ++n2;
                }
                ServiceChooser.this.tv2.setInput((Object)ServiceChooser.this.servicelist);
                ServiceChooser.this.notifyTreeItemChangedListener((Widget)ServiceChooser.this.tv2.getTree());
            }
        });
        this.tv2.addDropSupport(operations, types, (DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.feedback = 6;
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                Object[] selection = new Object[]{ServiceChooser.this.nativeToJava((String)event.data)};
                if (event.item == null) {
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object service = objectArray[n2];
                        ServiceChooser.this.getMapService((Service)service);
                        ServiceChooser.this.servicelist.add((Service)service);
                        ++n2;
                    }
                } else {
                    TreeItem item = (TreeItem)event.item;
                    TreeItem[] items = ServiceChooser.this.tv2.getTree().getItems();
                    int index = 0;
                    int i = 0;
                    while (i < items.length) {
                        if (items[i] == item) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object service = objectArray[n3];
                        ServiceChooser.this.getMapService((Service)service);
                        ServiceChooser.this.servicelist.add(index, (Service)service);
                        ++n3;
                    }
                }
                ServiceChooser.this.tv2.setInput((Object)ServiceChooser.this.servicelist);
                ServiceChooser.this.notifyTreeItemChangedListener((Widget)ServiceChooser.this.tv2.getTree());
            }
        });
    }

    private boolean contains(Service object) {
        for (Service service : this.servicelist) {
            if (!service.getUrl().equals(object.getUrl())) continue;
            return true;
        }
        return false;
    }

    public void URLChanged(Catalog catalog) {
        this.cataloglist.add(catalog);
        this.tv1.setInput(this.cataloglist);
        this.notifyTreeItemChangedListener((Widget)this.tv1.getTree());
    }

    void addTreeItemChangedListener(TreeItemChangedListener listener) {
        if (this.treeItemChangedListeners == null) {
            this.treeItemChangedListeners = new ArrayList();
        }
        this.treeItemChangedListeners.add(listener);
    }

    void notifyTreeItemChangedListener(Widget widget) {
        if (this.treeItemChangedListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.treeItemChangedListeners.size()) {
            this.treeItemChangedListeners.get(i).treeItemChanged(new TreeItemChangedEvent(widget));
            ++i;
        }
    }

    void getMapService(Service service) {
        if (service.getMapService() != null) {
            return;
        }
        String url = service.getUrl();
        String type = service.getType();
        try {
            URL u = new URL(url);
            String host = u.getHost();
            String protocol = u.getProtocol();
            int port = u.getPort();
            String path = u.getPath();
            String[] ss = path.split("/");
            StringBuffer sb = new StringBuffer();
            String[] stringArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sb.append(String.valueOf(URLEncoder.encode(s, "UTF-8")) + "/");
                ++n2;
            }
            u = new URL(protocol, host, port, String.valueOf(sb.toString()) + "/" + type + "?f=json");
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createJsonParser(u);
            parser.nextToken();
            MapService ms = MapService.fromJson(parser);
            service.setMapService(ms);
            parser.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createMenu() {
        final Menu popupmenu = new Menu((Decorations)this.getShell(), 8);
        popupmenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = popupmenu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                if (ServiceChooser.this.selectedTreeItem == null) {
                    return;
                }
                if (ServiceChooser.this.selectedTreeItem != null) {
                    if (ServiceChooser.this.selectedTreeItem.getData() instanceof Catalog) {
                        MenuItem deleteitem = new MenuItem(popupmenu, 8);
                        deleteitem.setText(Messages.ServiceChooser_26);
                        deleteitem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE"));
                        deleteitem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                ServiceChooser.this.cataloglist.remove((Catalog)ServiceChooser.this.selectedTreeItem.getData());
                                ServiceChooser.this.tv1.setInput((Object)ServiceChooser.this.cataloglist);
                            }
                        });
                    } else if (ServiceChooser.this.selectedTreeItem.getData() instanceof Service) {
                        MenuItem additem = new MenuItem(popupmenu, 8);
                        additem.setText(Messages.ServiceChooser_27);
                        additem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
                        additem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                ServiceChooser.this.addService(ServiceChooser.this.selectedTreeItem.getData());
                            }
                        });
                    }
                }
                super.menuShown(e);
            }
        });
        this.tv1.getTree().setMenu(popupmenu);
    }

    private void createMenu2() {
        final Menu popupmenu = new Menu((Decorations)this.getShell(), 8);
        popupmenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = popupmenu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                if (ServiceChooser.this.selectedTreeItem2 == null) {
                    return;
                }
                if (ServiceChooser.this.selectedTreeItem2 != null && ServiceChooser.this.selectedTreeItem2.getData() instanceof Service) {
                    MenuItem additem = new MenuItem(popupmenu, 8);
                    additem.setText(Messages.ServiceChooser_28);
                    additem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE"));
                    additem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ServiceChooser.this.servicelist.remove((Service)ServiceChooser.this.selectedTreeItem2.getData());
                            ServiceChooser.this.tv2.setInput((Object)ServiceChooser.this.servicelist);
                            ServiceChooser.this.notifyTreeItemChangedListener((Widget)ServiceChooser.this.tv2.getTree());
                        }
                    });
                }
                super.menuShown(e);
            }
        });
        this.tv2.getTree().setMenu(popupmenu);
    }

    private void addService(Object element) {
        Service service = (Service)element;
        if (!this.contains(service)) {
            this.servicelist.add((Service)element);
            this.getMapService(service);
            this.tv2.setInput(this.servicelist);
            this.notifyTreeItemChangedListener((Widget)this.tv2.getTree());
        }
    }

    public String javaToNative(Object object) {
        if (object == null) {
            return null;
        }
        String result = null;
        Service service = (Service)((Object[])object)[0];
        try {
            CharArrayWriter writeOut = new CharArrayWriter();
            String s = service.getName();
            char[] buffer = new char[s.length()];
            s.getChars(0, s.length(), buffer, 0);
            writeOut.write(buffer.length);
            writeOut.write(buffer);
            s = service.getType();
            buffer = new char[s.length()];
            s.getChars(0, s.length(), buffer, 0);
            writeOut.write(buffer.length);
            writeOut.write(buffer);
            s = service.getUrl();
            buffer = new char[s.length()];
            s.getChars(0, s.length(), buffer, 0);
            writeOut.write(buffer.length);
            writeOut.write(buffer);
            MapService ms = service.getMapService();
            if (ms == null) {
                writeOut.write(0);
            } else {
                writeOut.write(1);
                writeOut.write(ms.isTile() ? 1 : 2);
                String wkid = ms.getWkid();
                if (wkid == null) {
                    writeOut.write(0);
                } else {
                    s = ms.getWkid();
                    buffer = new char[s.length()];
                    s.getChars(0, s.length(), buffer, 0);
                    writeOut.write(buffer.length);
                    writeOut.write(buffer);
                }
            }
            result = writeOut.toString();
            writeOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Service nativeToJava(String transferData) {
        char[] buffer = transferData.toCharArray();
        if (buffer == null) {
            return null;
        }
        Service datum = new Service();
        try {
            CharArrayReader readIn = new CharArrayReader(buffer);
            while (readIn.ready()) {
                boolean hasMapService;
                int size = readIn.read();
                char[] name = new char[size];
                readIn.read(name);
                datum.setName(new String(name));
                size = readIn.read();
                name = new char[size];
                readIn.read(name);
                datum.setType(new String(name));
                size = readIn.read();
                name = new char[size];
                readIn.read(name);
                datum.setUrl(new String(name));
                boolean bl = hasMapService = readIn.read() == 1;
                if (!hasMapService) continue;
                MapService ms = new MapService();
                boolean isTiled = readIn.read() == 1;
                ms.setTile(isTiled);
                size = readIn.read();
                if (size > 0) {
                    name = new char[size];
                    readIn.read(name);
                    ms.setWkid(new String(name));
                }
                datum.setMapService(ms);
            }
            readIn.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return datum;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Dialog
    extends StatusDialog
    implements TreeItemChangedListener {
        private URLInputField input;
        private ServiceChooser chooser;

        protected Dialog(Shell shell) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
            this.setTitle(Messages.ServiceChooser_6);
            this.setHelpAvailable(false);
        }

        protected Control createDialogArea(Composite parent) {
            this.input = new URLInputField(parent, 0);
            this.chooser = new ServiceChooser(parent, 0);
            GridData gd = new GridData(1808);
            gd.heightHint = 300;
            gd.widthHint = 600;
            this.chooser.setLayoutData(gd);
            this.input.addURLChangeListener(this.chooser);
            this.chooser.addTreeItemChangedListener(this);
            this.updateStatus((IStatus)new Status(1, "com.esri.arcgis.android.core", ENTER_URL));
            return super.createDialogArea(parent);
        }

        @Override
        public void treeItemChanged(TreeItemChangedEvent e) {
            if (this.chooser.spatialRefConflictwithBase) {
                this.updateStatus((IStatus)new Status(2, "com.esri.arcgis.android.core", SPATIAL_REFERENCE_CONFLICT_BASE));
            } else if (this.chooser.isSpatialRefConflict()) {
                this.updateStatus((IStatus)new Status(2, "com.esri.arcgis.android.core", SPATIAL_REFERENCE_CONFLICT));
            } else if (e.source == this.chooser.tv1.getTree()) {
                this.updateStatus((IStatus)new Status(1, "com.esri.arcgis.android.core", ADD_MAP));
            } else {
                this.updateStatus((IStatus)new Status(1, "com.esri.arcgis.android.core", REORDER_DELETE_MAP));
            }
            Control control = this.getButtonBar();
            if (control instanceof Composite) {
                ((Composite)control).layout(true);
            }
        }

        protected void updateButtonsEnableState(IStatus status) {
            super.updateButtonsEnableState(status);
            if (this.chooser.servicelist.isEmpty()) {
                this.getButton(0).setEnabled(false);
            }
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            return super.createButton(parent, id, label, false);
        }

        public ArrayList<Service> getMapServices() {
            return this.chooser.servicelist;
        }
    }

    class Folder {
        private Catalog catlog;
        private String url;
        private String name;

        Folder() {
        }

        public Catalog getCatlog() {
            return this.catlog;
        }

        public void setCatlog(Catalog catlog) {
            this.catlog = catlog;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    class ServiceContentProvider
    implements ITreeContentProvider {
        ServiceContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Catalog) {
                Catalog catalog = (Catalog)parentElement;
                return this.parse(catalog);
            }
            if (!(parentElement instanceof Service) && parentElement instanceof Folder) {
                final Folder folder = (Folder)parentElement;
                Catalog catalog = folder.getCatlog();
                if (catalog == null) {
                    BusyIndicator.showWhile((Display)ServiceChooser.this.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            try {
                                String url = folder.getUrl();
                                JsonFactory factory = new JsonFactory();
                                JsonParser parser = factory.createJsonParser(new URL(String.valueOf(url) + "/" + "?f=json"));
                                parser.nextToken();
                                Catalog catalog = Catalog.fromJson(parser, url);
                                parser.close();
                                folder.setCatlog(catalog);
                            }
                            catch (Exception ex) {
                                MessageDialog.openError((Shell)ServiceChooser.this.getShell(), (String)Messages.ServiceChooser_9, (String)ex.toString());
                                ex.printStackTrace();
                            }
                        }
                    });
                    catalog = folder.getCatlog();
                }
                return this.parse(catalog);
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Catalog) {
                return true;
            }
            return element instanceof Folder;
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            ServiceChooser.this.calcSpatialRefConflict();
        }

        private Object[] parse(Catalog catalog) {
            String url = catalog.getUrl();
            ArrayList<Object> list = new ArrayList<Object>();
            List<Service> services = catalog.getService();
            for (Service service : services) {
                if (!service.getType().equals("MapServer")) continue;
                list.add(service);
            }
            List<String> folders = catalog.getFolder();
            for (String foldername : folders) {
                Folder folder = new Folder();
                folder.setName(foldername);
                folder.setUrl(String.valueOf(url) + "/" + foldername);
                list.add(folder);
            }
            return list.toArray();
        }
    }

    class ServiceLabelProvider
    implements ILabelProvider {
        ServiceLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof Service) {
                Service service = (Service)element;
                MapService ms = service.getMapService();
                boolean isTile = false;
                if (ms != null) {
                    isTile = ms.isTile();
                }
                if (isTile && ServiceChooser.this.isSpatialRefConflict()) {
                    return ServiceChooser.this.mapimage_warning;
                }
                return ServiceChooser.this.mapimage;
            }
            return ServiceChooser.this.folderimage;
        }

        public String getText(Object element) {
            if (element instanceof Service) {
                Service service = (Service)element;
                MapService ms = service.getMapService();
                if (ms == null) {
                    return String.valueOf(service.getName()) + " (" + service.getType() + ")";
                }
                return String.valueOf(service.getName()) + " (" + service.getType() + (ms.isTile() ? "/Tiled/" : "/Dynamic/") + ms.getWkid() + ")";
            }
            if (element instanceof Catalog) {
                return ((Catalog)element).getUrl();
            }
            if (element instanceof Folder) {
                return ((Folder)element).getName();
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class TreeItemChangedEvent {
        Widget source;

        public TreeItemChangedEvent(Widget widget) {
            this.source = widget;
        }
    }

    static interface TreeItemChangedListener {
        public void treeItemChanged(TreeItemChangedEvent var1);
    }
}

