/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.commands;

import com.esri.arcgis.android.core.commands.Service;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Catalog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String currentVersion;
    private String url;
    private List<String> folder;
    private List<Service> service;

    public Catalog(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public List<String> getFolder() {
        return this.folder;
    }

    public List<Service> getService() {
        return this.service;
    }

    public static Catalog fromJson(JsonParser parser, String url) throws Exception {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            return null;
        }
        Catalog ret = new Catalog(url);
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            parser.nextToken();
            if ("error".equals(fieldName)) {
                String code = "";
                String message = "";
                if (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                    while (parser.nextToken() != JsonToken.END_OBJECT) {
                        if ("code".equals(parser.getCurrentName())) {
                            code = parser.getText();
                        }
                        if (!"message".equals(parser.getCurrentName())) continue;
                        message = parser.getText();
                    }
                }
                throw new Exception("Code = " + code + "\nMessage = " + message);
            }
            if ("currentVersion".equals(fieldName)) {
                ret.currentVersion = parser.getText();
                continue;
            }
            if ("folders".equals(fieldName)) {
                if (parser.getCurrentToken() != JsonToken.START_ARRAY) continue;
                ret.folder = new ArrayList<String>();
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    ret.folder.add(parser.getText());
                }
                continue;
            }
            if ("services".equals(fieldName)) {
                if (parser.getCurrentToken() != JsonToken.START_ARRAY) continue;
                ret.service = new ArrayList<Service>();
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    Service service = Service.fromJson(parser);
                    String name = service.getName();
                    int index = name.lastIndexOf(47);
                    if (index > -1) {
                        name = name.substring(index + 1, name.length());
                    }
                    service.setUrl(String.valueOf(url) + "/" + name);
                    ret.service.add(service);
                }
                continue;
            }
            parser.skipChildren();
        }
        return ret;
    }
}

