/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.commands;

import com.esri.arcgis.android.core.LogUtils;
import com.esri.arcgis.android.core.ProjectUtils;
import com.esri.arcgis.android.core.commands.MapService;
import com.esri.arcgis.android.core.commands.Messages;
import com.esri.arcgis.android.core.commands.Service;
import com.esri.arcgis.android.core.commands.ServiceChooser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddMapView
extends AbstractHandler {
    private static final String ANDROID_PERMISSION = "android.permission.";
    private static final String ANDROID_NAME = "android:name";
    private static final String USES_PERMISSION = "uses-permission";
    private static final String MAPVIEW = "<com.esri.android.map.MapView\n\txmlns:android=\"http://schemas.android.com/apk/res/android\"\n\tandroid:id=\"@+id/map\" android:layout_width=\"fill_parent\"\n\tandroid:layout_height=\"fill_parent\">\n_LAYERS_</com.esri.android.map.MapView>";
    private static final String TILEDLAYER = "\t<com.esri.android.map.ags.ArcGISTiledMapServiceLayer url=\"_URL_\"/>\n";
    private static final String DYNAMICLAYER = "\t<com.esri.android.map.ags.ArcGISDynamicMapServiceLayer url=\"_URL_\"/>\n";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ServiceChooser.Dialog dialog = new ServiceChooser.Dialog(activeShell);
        if (dialog.open() != 0) {
            return null;
        }
        ArrayList<Service> services = dialog.getMapServices();
        StringBuffer buffer = new StringBuffer();
        for (Service service : services) {
            String url = service.getUrl();
            String type = service.getType();
            MapService ms = service.getMapService();
            if (ms != null && ms.isTile()) {
                buffer.append(TILEDLAYER.replaceFirst("_URL_", String.valueOf(url) + "/" + type));
                continue;
            }
            buffer.append(DYNAMICLAYER.replaceFirst("_URL_", String.valueOf(url) + "/" + type));
        }
        StructuredTextEditor textEditor = null;
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor == null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            activeEditor = page.getActiveEditor();
        }
        LogUtils.logINFO(activeEditor.getClass().getName());
        if (activeEditor instanceof FormEditor) {
            IEditorPart editor = ((FormEditor)activeEditor).getActiveEditor();
            LogUtils.logINFO(editor.getClass().getName());
            if (editor != null && editor instanceof StructuredTextEditor) {
                textEditor = (StructuredTextEditor)editor;
            }
        }
        if (textEditor == null) {
            return null;
        }
        IProject project = ((FileEditorInput)textEditor.getEditorInput()).getFile().getProject();
        if (!this.addPermission(project, activeShell)) {
            return null;
        }
        ProjectUtils.addAGSLibrary(JavaCore.create((IProject)project));
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        ITextSelection sel = (ITextSelection)textEditor.getSelectionProvider().getSelection();
        int offset = sel.getOffset();
        try {
            doc.replace(offset, 0, MAPVIEW.replaceFirst("_LAYERS_", buffer.toString()));
            project.refreshLocal(2, null);
        }
        catch (Exception e) {
            LogUtils.logERROR(e);
        }
        return null;
    }

    private boolean addPermission(IProject project, Shell shell) {
        ArrayList<String> listNewElements;
        Element root;
        Document document;
        IFile file;
        block12: {
            StringBuffer sbuf;
            block11: {
                block10: {
                    file = project.getFile("AndroidManifest.xml");
                    if (file != null) break block10;
                    LogUtils.logERROR(Messages.AddMapView_17);
                    return true;
                }
                document = AddMapView.parseXmlFile(file.getContents(), false);
                root = document.getDocumentElement();
                ArrayList<String> listExistingElements = new ArrayList<String>();
                NodeList permissions = root.getElementsByTagName(USES_PERMISSION);
                int i = 0;
                while (i < permissions.getLength()) {
                    Node permission = permissions.item(i);
                    NamedNodeMap attributes = permission.getAttributes();
                    Node name = attributes.getNamedItem(ANDROID_NAME);
                    if (ANDROID_NAME.equals(name.getNodeName())) {
                        listExistingElements.add(name.getNodeValue());
                    }
                    ++i;
                }
                listNewElements = new ArrayList<String>();
                sbuf = new StringBuffer();
                String[] stringArray = new String[]{"INTERNET", "ACCESS_FINE_LOCATION", "WRITE_EXTERNAL_STORAGE"};
                int n = stringArray.length;
                int name = 0;
                while (name < n) {
                    String permission = stringArray[name];
                    if (!listExistingElements.contains(ANDROID_PERMISSION + permission)) {
                        listNewElements.add(ANDROID_PERMISSION + permission);
                        sbuf.append(ANDROID_PERMISSION + permission + "\n");
                    }
                    ++name;
                }
                if (listNewElements.size() != 0) break block11;
                return true;
            }
            boolean b = MessageDialog.openConfirm((Shell)shell, (String)Messages.AddMapView_22, (String)(String.valueOf(Messages.AddMapView_23) + sbuf.toString()));
            if (b) break block12;
            return false;
        }
        try {
            for (String permission : listNewElements) {
                Element element = document.createElement(USES_PERMISSION);
                element.setAttribute(ANDROID_NAME, permission);
                root.appendChild(element);
            }
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(file.getRawLocation().toFile());
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            file.refreshLocal(0, null);
        }
        catch (Exception e) {
            LogUtils.logERROR(e);
        }
        return true;
    }

    private static Document parseXmlFile(InputStream in, boolean validating) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            Document doc = factory.newDocumentBuilder().parse(in);
            return doc;
        }
        catch (Exception e) {
            LogUtils.logERROR(e);
            return null;
        }
    }

    public boolean isEnabled() {
        String agsdebug = System.getProperty("agsdebug");
        if (agsdebug == null || !"true".equals(agsdebug)) {
            return true;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart activeEditor = page.getActiveEditor();
        StructuredTextEditor textEditor = null;
        if (activeEditor instanceof FormEditor) {
            IEditorPart editor = ((FormEditor)activeEditor).getActiveEditor();
            LogUtils.logINFO(editor.getClass().getName());
            if (editor != null && editor instanceof StructuredTextEditor) {
                textEditor = (StructuredTextEditor)editor;
            }
        }
        if (textEditor == null) {
            return false;
        }
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        String document = doc.get();
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(document.getBytes("UTF-8"));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document docu = factory.newDocumentBuilder().parse(in);
            return docu.getElementsByTagName("com.esri.android.map.MapView").getLength() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }
}

