/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.actions;

import com.esri.arcgis.android.core.ProjectUtils;
import com.esri.arcgis.android.core.actions.AbstractWindowAction;
import com.esri.arcgis.android.core.wizard.LocaleUtils;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;

public class FixProjectAction
extends AbstractWindowAction {
    protected IWorkbenchWizard instanciateWizard(IAction action) {
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        boolean hasNeedVersion = false;
        IJavaProject javaProject = ProjectUtils.getJavaProject();
        if (selection instanceof StructuredSelection && javaProject != null) {
            boolean hasLibPath;
            hasNeedVersion = this.hasNeedVersion(javaProject);
            boolean hasOSFile = ProjectUtils.isSOFileExisted(javaProject.getProject());
            enabled = hasOSFile == (hasLibPath = ProjectUtils.isArcGISAndroidLibExisted(javaProject)) ? hasOSFile && hasLibPath : !hasOSFile || !hasLibPath;
        }
        action.setEnabled(hasNeedVersion && enabled);
    }

    public void run(IAction action) {
        this.showProgressDialog();
    }

    private void showProgressDialog() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        Shell parent = window.getShell();
        final IJavaProject project = ProjectUtils.getJavaProject();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(parent);
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Checking ArcGIS For android libraries...", 1);
                    FixProjectAction.this.waitSeconds(monitor, 2.0f, "Checking native library...", 1);
                    ProjectUtils.copyNativeLibrary(project, true);
                    FixProjectAction.this.waitSeconds(monitor, 0.2f, "Checking resource files...", 1);
                    LocaleUtils.updateProjectLocale(project);
                    FixProjectAction.this.waitSeconds(monitor, 0.1f, "Checking the class  path", 1);
                    ProjectUtils.removeClasspathVariable(project);
                    ProjectUtils.addAGSLibrary(project);
                    FixProjectAction.this.waitSeconds(monitor, 1.0f, "Done", 1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

