/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.actions;

import com.esri.arcgis.android.core.ManifestFileUtils;
import com.esri.arcgis.android.core.ProjectUtils;
import com.esri.arcgis.android.core.actions.AbstractWindowAction;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;

public class ConvertToArcGISAction
extends AbstractWindowAction {
    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.showProgressDialog();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        boolean hasNeedVersion = false;
        IJavaProject javaProject = ProjectUtils.getJavaProject();
        if (selection instanceof StructuredSelection && javaProject != null) {
            hasNeedVersion = this.hasNeedVersion(javaProject);
            boolean hasOSFile = ProjectUtils.isSOFileExisted(javaProject.getProject());
            boolean hasLibPath = ProjectUtils.isArcGISAndroidLibExisted(javaProject);
            if (!hasOSFile && !hasLibPath) {
                enabled = true;
            }
        }
        action.setEnabled(hasNeedVersion && enabled);
    }

    private void showProgressDialog() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        Shell parent = window.getShell();
        final IJavaProject project = ProjectUtils.getJavaProject();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(parent);
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Copying ArcGIS For android libraries...", 3);
                    ConvertToArcGISAction.this.waitSeconds(monitor, 2.0f, "copying native library...", 2);
                    ProjectUtils.copyNativeLibrary(project);
                    ConvertToArcGISAction.this.waitSeconds(monitor, 0.2f, "copying native library...", 2);
                    ManifestFileUtils.modifyManifestFile(project, String.valueOf(ConvertToArcGISAction.this.mVersion));
                    ConvertToArcGISAction.this.waitSeconds(monitor, 0.1f, "linking arcgis_android.jar", 1);
                    ProjectUtils.addAGSLibrary(project);
                    ConvertToArcGISAction.this.waitSeconds(monitor, 1.0f, "Done", 3);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void waitSeconds(IProgressMonitor monitor, float secs, String msg, int task) {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(msg);
        try {
            Thread.sleep((int)(secs * 1000.0f));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        monitor.worked(task);
    }

    protected IWorkbenchWizard instanciateWizard(IAction action) {
        return null;
    }
}

