/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core.actions;

import com.esri.arcgis.android.core.ProjectUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.util.Util;

public abstract class AbstractWindowAction
implements IWorkbenchWindowActionDelegate {
    int mVersion = -1;
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected abstract IWorkbenchWizard instanciateWizard(IAction var1);

    protected int getAndroidVersion(String path) {
        String pattern = "android-";
        int pos = path.lastIndexOf(pattern);
        if (pos > 0) {
            int start = pos + pattern.length();
            char a = path.charAt(start);
            char b = path.charAt(start + 1);
            if (Character.isDigit(a)) {
                this.mVersion = Character.isDigit(b) ? Integer.valueOf(path.substring(start, start + 2)).intValue() : Integer.valueOf(path.substring(start, start + 1)).intValue();
            }
        }
        return this.mVersion;
    }

    protected void enabledAction(IAction action, ISelection selection) {
        IProject pro;
        IFile file;
        StructuredSelection selected;
        Object obj;
        boolean enabled = false;
        if (selection instanceof StructuredSelection && (obj = (selected = (StructuredSelection)selection).getFirstElement()) != null && obj instanceof IProject && (file = (pro = (IProject)obj).getFile((IPath)new Path(String.valueOf(ProjectUtils.NATVIVE_LIBS_FOLDER) + "/" + ProjectUtils.NATIVE_LIBS_ARMV7 + "/lib" + ProjectUtils.NATIVE_LIBS_NAME + ".so"))).exists()) {
            enabled = true;
        }
        action.setEnabled(enabled);
    }

    public void run(IAction action) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            selectionToPass = (IStructuredSelection)selection;
        } else {
            IWorkbenchPart part = window.getPartService().getActivePart();
            if (part instanceof IEditorPart) {
                Object file;
                IEditorInput input = ((IEditorPart)part).getEditorInput();
                Class fileClass = LegacyResourceSupport.getFileClass();
                if (input != null && fileClass != null && (file = Util.getAdapter((Object)input, (Class)fileClass)) != null) {
                    selectionToPass = new StructuredSelection(file);
                }
            }
        }
        IWorkbenchWizard wizard = this.instanciateWizard(action);
        wizard.init(workbench, (IStructuredSelection)selectionToPass);
        Shell parent = window.getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        Point defaultSize = dialog.getShell().getSize();
        dialog.getShell().setSize(Math.max(500, defaultSize.x), Math.max(500, defaultSize.y));
        window.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.new_wizard_shortcut_context");
        dialog.open();
    }

    protected void waitSeconds(IProgressMonitor monitor, float secs, String msg, int task) {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(msg);
        try {
            Thread.sleep((int)(secs * 1000.0f));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        monitor.worked(task);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasNeedVersion(IJavaProject javaProject) {
        if (javaProject == null) return false;
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (true) {
                IClasspathContainer clsContainer;
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && (clsContainer = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject)) != null) {
                    IClasspathEntry[] childEntries;
                    IClasspathEntry[] iClasspathEntryArray2 = childEntries = clsContainer.getClasspathEntries();
                    int n3 = childEntries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry childPath = iClasspathEntryArray2[n4];
                        String path = childPath.getPath().toFile().getAbsolutePath();
                        if (this.getAndroidVersion(path) >= 8) {
                            return true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return false;
    }
}

