/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core;

import com.esri.arcgis.android.core.Activator;
import com.esri.arcgis.android.core.FileUtils;
import com.esri.arcgis.android.core.LogUtils;
import com.esri.arcgis.android.core.project.AGSClasspathLibraryUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ProjectUtils {
    public static String NATVIVE_LIBS_FOLDER = "libs";
    public static String NATIVE_LIBS_ARMV7 = "armeabi-v7a";
    public static String NATIVE_LIBS_ARMV5 = "armeabi";
    public static String NATIVE_LIBS_NAME = "GLMapCore";
    static String NATIVE_MAP_IMPORT = "\nimport com.esri.android.map.MapView;\n";
    static String NATIVE_LIB_TOKEN = "\t\n\tMapView mMapView ;";
    static String NATIVE_MAP = "\t\tmMapView = new MapView(this);\n";
    static String NATIVE_CODE_TOKEN1 = "\n\t@Override \n\tprotected void onDestroy() { \n\t\tsuper.onDestroy();\n }";
    static String NATIVE_CODE_TOKEN2 = "\n\t@Override\n\tprotected void onPause() {\n\t\tsuper.onPause();\n\t\tmMapView.pause();\n }";
    static String NATIVE_CODE_TOKEN3 = "\n\t@Override \tprotected void onResume() {\n\t\tsuper.onResume(); \n\t\tmMapView.unpause();\n\t}";
    public static final String WS_SEP = "/";
    public static final String FN_ANDROID_MANIFEST_XML = "AndroidManifest.xml";

    public static void addDefaultDirectories(IProject project, String parentFolder, String[] folders) throws CoreException {
        String[] stringArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder;
            String name = stringArray[n2];
            if (name.length() > 0 && !(folder = project.getFolder(String.valueOf(parentFolder) + name)).exists()) {
                folder.create(true, true, null);
            }
            ++n2;
        }
    }

    public static void copyFile(IProject project, String folder, String sourceFile) {
        IFile destFile = project.getFile(sourceFile);
        try {
            InputStream in = FileLocator.openStream((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(String.valueOf(folder) + File.separator + "ArcGIS_Android.jar"), (boolean)false);
            destFile.create(in, false, null);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isSOFileExisted(IProject pro) {
        boolean enabled = false;
        IFile file = pro.getFile((IPath)new Path(String.valueOf(NATVIVE_LIBS_FOLDER) + WS_SEP + NATIVE_LIBS_ARMV7 + "/lib" + NATIVE_LIBS_NAME + ".so"));
        if (file.exists()) {
            enabled = true;
        }
        return enabled;
    }

    public static boolean isArcGISAndroidLibExisted(IJavaProject jproject) {
        if (jproject == null) {
            return false;
        }
        boolean exist = false;
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = jproject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                String path = entry.getPath().toString();
                if ("com.esri.arcgis.android.LIBRARIES".equals(path)) {
                    exist = true;
                    Activator.getDefault().getLog().log((IStatus)new Status(1, "com.esri.arcgis.android.core", "ArcGIS_Android.jar exists."));
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return exist;
    }

    public static void addAGSLibrary(IJavaProject jproject) {
        try {
            if (!ProjectUtils.isArcGISAndroidLibExisted(jproject)) {
                AGSClasspathLibraryUtil.updateAGSClasspathContainer(jproject);
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.esri.arcgis.android.core", LogUtils.parseException(e)));
            e.printStackTrace();
        }
    }

    public static void removeClasspathVariable(IJavaProject javaProject) {
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() != 4 || e.getPath().toString().indexOf("") < 0) {
                    newEntries.add(e);
                }
                ++n2;
            }
            IClasspathEntry[] theEntries = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
            javaProject.setRawClasspath(theEntries, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public static void addEntryToClasspath(IJavaProject javaProject, IClasspathEntry new_entry) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        entries = ProjectUtils.addEntryToClasspath(entries, new_entry);
        javaProject.setRawClasspath(entries, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IClasspathEntry[] addEntryToClasspath(IClasspathEntry[] entries, IClasspathEntry new_entry) {
        int n = entries.length;
        IClasspathEntry[] newEntries = new IClasspathEntry[n + 1];
        System.arraycopy(entries, 0, newEntries, 0, n);
        newEntries[n] = new_entry;
        return newEntries;
    }

    public static IProject getProject() {
        IProject project = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            ISelectionService selectionService = window.getSelectionService();
            ISelection selection = selectionService.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (element instanceof IResource) {
                    project = ((IResource)element).getProject();
                } else if (element instanceof PackageFragmentRootContainer) {
                    IJavaProject jProject = ((PackageFragmentRootContainer)element).getJavaProject();
                    project = jProject.getProject();
                } else if (element instanceof IJavaElement) {
                    IJavaProject jProject = ((IJavaElement)element).getJavaProject();
                    project = jProject.getProject();
                }
                return project;
            }
            boolean cfr_ignored_0 = selection instanceof ITextSelection;
        }
        return project;
    }

    public static IJavaProject getJavaProject() {
        IJavaProject project = null;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof PackageFragmentRootContainer) {
                project = ((PackageFragmentRootContainer)element).getJavaProject();
            } else if (element instanceof IJavaElement) {
                project = ((IJavaElement)element).getJavaProject();
            } else if (element instanceof Project) {
                project = JavaCore.create((IProject)((Project)element).getProject());
            }
            return project;
        }
        boolean cfr_ignored_0 = selection instanceof ITextSelection;
        return project;
    }

    public static void copyNativeLibrary(IJavaProject project) {
        ProjectUtils.copyNativeLibrary(project, false);
    }

    public static void copyNativeLibrary(IJavaProject project, boolean update) {
        if (project == null || project.getProject() == null) {
            return;
        }
        Bundle bundle = Platform.getBundle((String)"com.esri.arcgis.android.core");
        try {
            ProjectUtils.addDefaultDirectories(project.getProject(), WS_SEP, new String[]{NATVIVE_LIBS_FOLDER});
            ProjectUtils.addDefaultDirectories(project.getProject(), String.valueOf(NATVIVE_LIBS_FOLDER) + WS_SEP, new String[]{NATIVE_LIBS_ARMV7});
            ProjectUtils.addDefaultDirectories(project.getProject(), String.valueOf(NATVIVE_LIBS_FOLDER) + WS_SEP, new String[]{NATIVE_LIBS_ARMV5});
            InputStream stream = FileLocator.openStream((Bundle)bundle, (IPath)new Path(String.valueOf(NATVIVE_LIBS_FOLDER) + WS_SEP + NATIVE_LIBS_ARMV7 + "/lib" + NATIVE_LIBS_NAME + ".so"), (boolean)false);
            IFile file = project.getProject().getFile(String.valueOf(NATVIVE_LIBS_FOLDER) + WS_SEP + NATIVE_LIBS_ARMV7 + "/lib" + NATIVE_LIBS_NAME + ".so");
            if (!file.exists()) {
                file.create(stream, true, null);
                stream.close();
            } else if (update) {
                file.delete(1, null);
                file.create(stream, true, null);
                stream.close();
            }
            stream = FileLocator.openStream((Bundle)bundle, (IPath)new Path(String.valueOf(NATVIVE_LIBS_FOLDER) + WS_SEP + NATIVE_LIBS_ARMV5 + "/lib" + NATIVE_LIBS_NAME + ".so"), (boolean)false);
            file = project.getProject().getFile(String.valueOf(NATVIVE_LIBS_FOLDER) + WS_SEP + NATIVE_LIBS_ARMV5 + "/lib" + NATIVE_LIBS_NAME + ".so");
            if (!file.exists()) {
                file.create(stream, true, null);
                stream.close();
            } else if (update) {
                file.setContents(stream, true, false, null);
                stream.close();
            }
            project.save(null, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void modifyActivityClass(IJavaProject jproject, String srcFolder, String packageName, String activityName) throws Exception {
        if (srcFolder == null || packageName == null || activityName == null) {
            return;
        }
        packageName = packageName.replace(".", WS_SEP);
        String activityFilePath = String.valueOf(srcFolder) + WS_SEP + packageName + WS_SEP + activityName + ".java";
        IFile activityFile = jproject.getProject().getFile(activityFilePath);
        if (activityFile != null) {
            String template = FileUtils.readTextFile(activityFile.getContents());
            int pos = template.indexOf("Bundle;");
            template = FileUtils.insert(template, pos + 7, NATIVE_MAP_IMPORT);
            pos = template.indexOf(123);
            template = FileUtils.insert(template, pos, NATIVE_LIB_TOKEN);
            pos = template.indexOf("main);");
            template = FileUtils.insert(template, pos + 6, NATIVE_MAP);
            pos = template.indexOf("}", template.indexOf("this);"));
            template = FileUtils.insert(template, pos, String.valueOf(NATIVE_CODE_TOKEN1) + NATIVE_CODE_TOKEN2 + NATIVE_CODE_TOKEN3);
            ByteArrayInputStream stream = new ByteArrayInputStream(template.getBytes("UTF-8"));
            activityFile.setContents((InputStream)stream, true, false, null);
            ((InputStream)stream).close();
        }
    }
}

