/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core;

import com.esri.arcgis.android.core.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;

public class ManifestFileUtils {
    static String MANIFEST_TOKEN = "<uses-feature android:glEsVersion=\"0x00020000\" android:required=\"true\"/> \n";
    static String PERMISSION_INTERNET = "android.permission.INTERNET";
    static String PERMISSION_LOCATION = "android.permission.ACCESS_FINE_LOCATION";
    static String PERMISSION_EXTERNAL_STORAGE = "android.permission.WRITE_EXTERNAL_STORAGE";
    static String MANIFEST_TOKEN1 = "<uses-permission android:name=\"" + PERMISSION_INTERNET + "\" />";
    static String MANIFEST_TOKEN2 = "<uses-permission android:name=\"" + PERMISSION_LOCATION + "\" />";
    static String MANIFEST_TOKEN3 = "<uses-permission android:name=\"" + PERMISSION_EXTERNAL_STORAGE + "\" />";
    public static final String WS_SEP = "/";
    public static final String FN_ANDROID_MANIFEST_XML = "AndroidManifest.xml";

    public static IFile getManifest(IProject project) {
        IResource r = project.findMember("/AndroidManifest.xml");
        if (r == null || !r.exists() || !(r instanceof IFile)) {
            return null;
        }
        return (IFile)r;
    }

    public static void modifyManifestFile(IJavaProject project, String apilevel) {
        IFile file = ManifestFileUtils.getManifest(project.getProject());
        if (file != null) {
            try {
                String template = FileUtils.readTextFile(file.getContents());
                String token = "minSdkVersion";
                int pos = template.indexOf(token);
                if (pos > 0) {
                    template = FileUtils.insert(template, pos + token.length() + 8, MANIFEST_TOKEN);
                } else if (apilevel != null) {
                    String sdkToken = " \n <uses-sdk android:minSdkVersion=\"" + apilevel + "\" /> \n";
                    token = "<application ";
                    pos = template.indexOf(token);
                    template = FileUtils.insert(template, pos - 1, String.valueOf(sdkToken) + MANIFEST_TOKEN);
                }
                token = "</application>";
                pos = template.indexOf(token);
                if (template.indexOf(PERMISSION_INTERNET) < 1) {
                    template = FileUtils.insert(template, pos + token.length(), String.valueOf(MANIFEST_TOKEN1) + "\n" + MANIFEST_TOKEN2 + "\n" + MANIFEST_TOKEN3);
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(template.getBytes("UTF-8"));
                file.setContents((InputStream)stream, true, false, null);
                ((InputStream)stream).close();
                project.save(null, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

