/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.android.core;

import com.esri.arcgis.android.core.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;

public class FileUtils {
    private static final int BUFFSIZE = 1024;
    private static byte[] buff1 = new byte[1024];
    private static byte[] buff2 = new byte[1024];

    public static String readTextFile(InputStream is) {
        try {
            if (is != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                StringBuilder total = new StringBuilder(reader.readLine());
                while ((line = reader.readLine()) != null) {
                    total.append('\n');
                    total.append(line);
                }
                return total.toString();
            }
        }
        catch (IOException e) {
            LogUtils.logERROR("Failed to read text file \n" + e.getLocalizedMessage());
        }
        return null;
    }

    public static String insert(String template, int pos, String token) {
        StringBuilder sb = new StringBuilder();
        sb.append(template.substring(0, pos + 1));
        sb.append("\n");
        sb.append(token);
        sb.append("\n");
        sb.append(template.substring(pos + 1, template.length()));
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean inputStreamEquals(InputStream is1, InputStream is2) {
        if (is1 == is2) {
            return true;
        }
        if (is1 == null && is2 == null) {
            return true;
        }
        if (is1 == null || is2 == null) {
            return true;
        }
        try {
            int read1 = -1;
            int read2 = -1;
            do {
                int offset1 = 0;
                while (offset1 < 1024 && (read1 = is1.read(buff1, offset1, 1024 - offset1)) >= 0) {
                    offset1 += read1;
                }
                int offset2 = 0;
                while (offset2 < 1024 && (read2 = is2.read(buff2, offset2, 1024 - offset2)) >= 0) {
                    offset2 += read2;
                }
                if (offset1 != offset2) {
                    return false;
                }
                if (offset1 != 1024) {
                    Arrays.fill(buff1, offset1, 1024, (byte)0);
                    Arrays.fill(buff2, offset2, 1024, (byte)0);
                }
                if (Arrays.equals(buff1, buff2)) continue;
                return false;
            } while (read1 >= 0 && read2 >= 0);
            return read1 < 0 && read2 < 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean fileContentsEquals(File file1, File file2) {
        FileInputStream is1 = null;
        InputStream is2 = null;
        if (file1.length() != file2.length()) {
            return false;
        }
        is1 = new FileInputStream(file1);
        is2 = new FileInputStream(file2);
        boolean bl = FileUtils.inputStreamEquals(is1, is2);
        try {
            if (is1 != null) {
                ((InputStream)is1).close();
            }
            if (is2 != null) {
                is2.close();
            }
        }
        catch (Exception exception) {}
        return bl;
        catch (Exception exception) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (is1 != null) {
                        ((InputStream)is1).close();
                    }
                    if (is2 != null) {
                        is2.close();
                    }
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                if (is1 != null) {
                    ((InputStream)is1).close();
                }
                if (is2 != null) {
                    is2.close();
                }
            }
            catch (Exception exception3) {}
            return false;
        }
    }

    public static boolean fileContentsEquals(String fn1, String fn2) {
        return FileUtils.fileContentsEquals(new File(fn1), new File(fn2));
    }
}

