/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.osgi.impl;

import java.util.List;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.osgi.impl.OSGiCredentialsProvider;
import org.apache.http.osgi.impl.OSGiHttpRoutePlanner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

final class OSGiHttpClientBuilder
extends HttpClientBuilder {
    private final List<CloseableHttpClient> trackedHttpClients;

    public OSGiHttpClientBuilder(BundleContext bundleContext, Map<String, ServiceRegistration> registeredConfigurations, List<CloseableHttpClient> trackedHttpClients) {
        this.trackedHttpClients = trackedHttpClients;
        this.setDefaultCredentialsProvider(new OSGiCredentialsProvider(bundleContext, registeredConfigurations));
        this.setRoutePlanner(new OSGiHttpRoutePlanner(bundleContext, registeredConfigurations));
    }

    @Override
    public CloseableHttpClient build() {
        CloseableHttpClient httpClient = super.build();
        this.trackedHttpClients.add(httpClient);
        return httpClient;
    }
}

