/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import com.sun.jarsigner.ContentSigner;
import com.sun.jarsigner.ContentSignerParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.SignerInfo;
import sun.security.timestamp.HttpTimestamper;
import sun.security.timestamp.TSRequest;
import sun.security.timestamp.TSResponse;
import sun.security.timestamp.TimestampToken;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AccessDescription;
import sun.security.x509.AlgorithmId;
import sun.security.x509.GeneralName;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertInfo;

public final class TimestampedSigner
extends ContentSigner {
    private static final SecureRandom RANDOM;
    private static final String SUBJECT_INFO_ACCESS_OID = "1.3.6.1.5.5.7.1.11";
    private static final String KP_TIMESTAMPING_OID = "1.3.6.1.5.5.7.3.8";
    private static final ObjectIdentifier AD_TIMESTAMPING_Id;
    private String tsaUrl = null;
    private X509Certificate tsaCertificate = null;
    private MessageDigest messageDigest = null;
    private boolean tsRequestCertificate = true;

    static {
        Serializable tmp = null;
        try {
            tmp = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        RANDOM = tmp;
        tmp = null;
        try {
            tmp = new ObjectIdentifier("1.3.6.1.5.5.7.48.3");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AD_TIMESTAMPING_Id = tmp;
    }

    @Override
    public byte[] generateSignedData(ContentSignerParameters parameters, boolean omitContent, boolean applyTimestamp) throws NoSuchAlgorithmException, CertificateException, IOException {
        if (parameters == null) {
            throw new NullPointerException();
        }
        String signatureAlgorithm = parameters.getSignatureAlgorithm();
        String digestAlgorithm = null;
        String keyAlgorithm = null;
        int with = signatureAlgorithm.indexOf("with");
        if (with > 0) {
            digestAlgorithm = signatureAlgorithm.substring(0, with);
            int and = signatureAlgorithm.indexOf("and", with + 4);
            keyAlgorithm = and > 0 ? signatureAlgorithm.substring(with + 4, and) : signatureAlgorithm.substring(with + 4);
        }
        AlgorithmId digestAlgorithmId = AlgorithmId.get(digestAlgorithm);
        X509Certificate[] signerCertificateChain = parameters.getSignerCertificateChain();
        Principal issuerName = signerCertificateChain[0].getIssuerDN();
        if (!(issuerName instanceof X500Name)) {
            X509CertInfo tbsCert = new X509CertInfo(signerCertificateChain[0].getTBSCertificate());
            issuerName = (Principal)tbsCert.get("issuer.dname");
        }
        BigInteger serialNumber = signerCertificateChain[0].getSerialNumber();
        byte[] content = parameters.getContent();
        ContentInfo contentInfo = omitContent ? new ContentInfo(ContentInfo.DATA_OID, null) : new ContentInfo(content);
        byte[] signature = parameters.getSignature();
        SignerInfo signerInfo = null;
        if (applyTimestamp) {
            this.tsaCertificate = parameters.getTimestampingAuthorityCertificate();
            URI tsaUri = parameters.getTimestampingAuthority();
            if (tsaUri != null) {
                this.tsaUrl = tsaUri.toString();
            } else {
                String certUrl = TimestampedSigner.getTimestampingUrl(this.tsaCertificate);
                if (certUrl == null) {
                    throw new CertificateException("Subject Information Access extension not found");
                }
                this.tsaUrl = certUrl;
            }
            byte[] tsToken = this.generateTimestampToken(signature);
            PKCS9Attributes unsignedAttrs = new PKCS9Attributes(new PKCS9Attribute[]{new PKCS9Attribute("SignatureTimestampToken", (Object)tsToken)});
            signerInfo = new SignerInfo((X500Name)issuerName, serialNumber, digestAlgorithmId, null, AlgorithmId.get(keyAlgorithm), signature, unsignedAttrs);
        } else {
            signerInfo = new SignerInfo((X500Name)issuerName, serialNumber, digestAlgorithmId, AlgorithmId.get(keyAlgorithm), signature);
        }
        SignerInfo[] signerInfos = new SignerInfo[]{signerInfo};
        AlgorithmId[] algorithms = new AlgorithmId[]{digestAlgorithmId};
        PKCS7 p7 = new PKCS7(algorithms, contentInfo, signerCertificateChain, signerInfos);
        ByteArrayOutputStream p7out = new ByteArrayOutputStream();
        p7.encodeSignedData(p7out);
        return p7out.toByteArray();
    }

    public static String getTimestampingUrl(X509Certificate tsaCertificate) {
        byte[] extensionValue;
        block6: {
            if (tsaCertificate == null) {
                return null;
            }
            extensionValue = tsaCertificate.getExtensionValue(SUBJECT_INFO_ACCESS_OID);
            if (extensionValue != null) break block6;
            return null;
        }
        try {
            DerInputStream der = new DerInputStream(extensionValue);
            der = new DerInputStream(der.getOctetString());
            DerValue[] derValue = der.getSequence(5);
            int i = 0;
            while (i < derValue.length) {
                URIName uri;
                GeneralName location;
                AccessDescription description = new AccessDescription(derValue[i]);
                if (description.getAccessMethod().equals(AD_TIMESTAMPING_Id) && (location = description.getAccessLocation()).getType() == 6 && (uri = (URIName)location.getName()).getScheme().equalsIgnoreCase("http")) {
                    return uri.getName();
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private byte[] generateTimestampToken(byte[] toBeTimestamped) throws CertificateException, IOException {
        if (this.messageDigest == null) {
            try {
                this.messageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        byte[] digest = this.messageDigest.digest(toBeTimestamped);
        TSRequest tsQuery = new TSRequest(digest, "SHA-1");
        BigInteger nonce = null;
        if (RANDOM != null) {
            nonce = new BigInteger(64, RANDOM);
            tsQuery.setNonce(nonce);
        }
        tsQuery.requestCertificate(this.tsRequestCertificate);
        HttpTimestamper tsa = new HttpTimestamper(this.tsaUrl);
        TSResponse tsReply = tsa.generateTimestamp(tsQuery);
        int status = tsReply.getStatusCode();
        if (status != 0 && status != 1) {
            int failureCode = tsReply.getFailureCode();
            if (failureCode == -1) {
                throw new IOException("Error generating timestamp: " + tsReply.getStatusCodeAsText());
            }
            throw new IOException("Error generating timestamp: " + tsReply.getStatusCodeAsText() + " " + tsReply.getFailureCodeAsText());
        }
        PKCS7 tsToken = tsReply.getToken();
        TimestampToken tst = new TimestampToken(tsToken.getContentInfo().getData());
        if (!tst.getHashAlgorithm().equals(new AlgorithmId(new ObjectIdentifier("1.3.14.3.2.26")))) {
            throw new IOException("Digest algorithm not SHA-1 in timestamp token");
        }
        if (!Arrays.equals(tst.getHashedMessage(), digest)) {
            throw new IOException("Digest octets changed in timestamp token");
        }
        BigInteger replyNonce = tst.getNonce();
        if (replyNonce == null && nonce != null) {
            throw new IOException("Nonce missing in timestamp token");
        }
        if (replyNonce != null && !replyNonce.equals(nonce)) {
            throw new IOException("Nonce changed in timestamp token");
        }
        List<String> keyPurposes = null;
        X509Certificate[] certs = tsToken.getCertificates();
        if (certs != null && certs.length > 0) {
            X509Certificate[] x509CertificateArray = certs;
            int n = certs.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate cert = x509CertificateArray[n2];
                boolean isSigner = false;
                X509Certificate[] x509CertificateArray2 = certs;
                int n3 = certs.length;
                int n4 = 0;
                while (n4 < n3) {
                    X509Certificate cert2 = x509CertificateArray2[n4];
                    if (cert != cert2 && cert.getSubjectDN().equals(cert2.getIssuerDN())) {
                        isSigner = true;
                        break;
                    }
                    ++n4;
                }
                if (!isSigner) {
                    keyPurposes = cert.getExtendedKeyUsage();
                    if (keyPurposes.contains(KP_TIMESTAMPING_OID)) break;
                    throw new CertificateException("Certificate is not valid for timestamping");
                }
                ++n2;
            }
        }
        return tsReply.getEncodedToken();
    }
}

