/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import com.sun.jarsigner.ContentSigner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import sun.security.tools.JarBASE64Encoder;
import sun.security.tools.JarSignerParameters;
import sun.security.tools.TimestampedSigner;
import sun.security.util.ManifestDigester;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertInfo;

class SignatureFile {
    Manifest sf;
    String baseName;

    public SignatureFile(MessageDigest[] digests, Manifest mf, ManifestDigester md, String baseName, boolean signManifest) {
        ManifestDigester.Entry mde;
        this.baseName = baseName;
        String version = System.getProperty("java.version");
        String javaVendor = System.getProperty("java.vendor");
        this.sf = new Manifest();
        Attributes mattr = this.sf.getMainAttributes();
        JarBASE64Encoder encoder = new JarBASE64Encoder();
        mattr.putValue(Attributes.Name.SIGNATURE_VERSION.toString(), "1.0");
        mattr.putValue("Created-By", String.valueOf(version) + " (" + javaVendor + ")");
        if (signManifest) {
            int i = 0;
            while (i < digests.length) {
                mattr.putValue(String.valueOf(digests[i].getAlgorithm()) + "-Digest-Manifest", encoder.encode(md.manifestDigest(digests[i])));
                ++i;
            }
        }
        if ((mde = md.get("Manifest-Main-Attributes", false)) != null) {
            int i = 0;
            while (i < digests.length) {
                mattr.putValue(String.valueOf(digests[i].getAlgorithm()) + "-Digest-" + "Manifest-Main-Attributes", encoder.encode(mde.digest(digests[i])));
                ++i;
            }
        } else {
            throw new IllegalStateException("ManifestDigester failed to create Manifest-Main-Attribute entry");
        }
        Map<String, Attributes> entries = this.sf.getEntries();
        for (Map.Entry<String, Attributes> e : mf.getEntries().entrySet()) {
            String name = e.getKey();
            mde = md.get(name, false);
            if (mde == null) continue;
            Attributes attr = new Attributes();
            int i = 0;
            while (i < digests.length) {
                attr.putValue(String.valueOf(digests[i].getAlgorithm()) + "-Digest", encoder.encode(mde.digest(digests[i])));
                ++i;
            }
            entries.put(name, attr);
        }
    }

    public void write(OutputStream out) throws IOException {
        this.sf.write(out);
    }

    public String getMetaName() {
        return "META-INF/" + this.baseName + ".SF";
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Block generateBlock(PrivateKey privateKey, String sigalg, X509Certificate[] certChain, boolean externalSF, String tsaUrl, X509Certificate tsaCert, ContentSigner signingMechanism, String[] args, ZipFile zipFile) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
        return new Block(this, privateKey, sigalg, certChain, externalSF, tsaUrl, tsaCert, signingMechanism, args, zipFile);
    }

    public static class Block {
        private byte[] block;
        private String blockFileName;

        Block(SignatureFile sfg, PrivateKey privateKey, String sigalg, X509Certificate[] certChain, boolean externalSF, String tsaUrl, X509Certificate tsaCert, ContentSigner signingMechanism, String[] args, ZipFile zipFile) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
            String signatureAlgorithm;
            Principal issuerName = certChain[0].getIssuerDN();
            if (!(issuerName instanceof X500Name)) {
                X509CertInfo tbsCert = new X509CertInfo(certChain[0].getTBSCertificate());
                issuerName = (Principal)tbsCert.get("issuer.dname");
            }
            BigInteger serial = certChain[0].getSerialNumber();
            String keyAlgorithm = privateKey.getAlgorithm();
            if (sigalg == null) {
                String digestAlgorithm;
                if (keyAlgorithm.equalsIgnoreCase("DSA")) {
                    digestAlgorithm = "SHA1";
                } else if (keyAlgorithm.equalsIgnoreCase("RSA")) {
                    digestAlgorithm = "SHA1";
                } else {
                    throw new RuntimeException("private key is not a DSA or RSA key");
                }
                signatureAlgorithm = String.valueOf(digestAlgorithm) + "with" + keyAlgorithm;
            } else {
                signatureAlgorithm = sigalg;
            }
            String sigAlgUpperCase = signatureAlgorithm.toUpperCase();
            if (sigAlgUpperCase.endsWith("WITHRSA") && !keyAlgorithm.equalsIgnoreCase("RSA") || sigAlgUpperCase.endsWith("WITHDSA") && !keyAlgorithm.equalsIgnoreCase("DSA")) {
                throw new SignatureException("private key algorithm is not compatible with signature algorithm");
            }
            this.blockFileName = "META-INF/" + sfg.getBaseName() + "." + keyAlgorithm;
            AlgorithmId sigAlg = AlgorithmId.get(signatureAlgorithm);
            AlgorithmId digEncrAlg = AlgorithmId.get(keyAlgorithm);
            Signature sig = Signature.getInstance(signatureAlgorithm);
            sig.initSign(privateKey);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            sfg.write(baos);
            byte[] content = baos.toByteArray();
            sig.update(content);
            byte[] signature = sig.sign();
            if (signingMechanism == null) {
                signingMechanism = new TimestampedSigner();
            }
            URI tsaUri = null;
            try {
                if (tsaUrl != null) {
                    tsaUri = new URI(tsaUrl);
                }
            }
            catch (URISyntaxException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            JarSignerParameters params = new JarSignerParameters(args, tsaUri, tsaCert, signature, signatureAlgorithm, certChain, content, zipFile);
            this.block = signingMechanism.generateSignedData(params, externalSF, tsaUrl != null || tsaCert != null);
        }

        public String getMetaName() {
            return this.blockFileName;
        }

        public void write(OutputStream out) throws IOException {
            out.write(this.block);
        }
    }
}

