/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import com.sun.jarsigner.ContentSigner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Timestamp;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import sun.misc.BASE64Encoder;
import sun.security.tools.JarBASE64Encoder;
import sun.security.tools.KeyStoreUtil;
import sun.security.tools.SignatureFile;
import sun.security.tools.TimestampedSigner;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ManifestDigester;
import sun.security.util.Password;
import sun.security.util.PathList;
import sun.security.util.SignatureFileVerifier;
import sun.security.x509.NetscapeCertTypeExtension;

public class JarSigner {
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.tools.JarSignerResources");
    private static final Collator collator = Collator.getInstance();
    private static final String META_INF = "META-INF/";
    private static final String SIG_PREFIX = "META-INF/SIG-";
    private static final Class[] PARAM_STRING;
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final long SIX_MONTHS = 15552000000L;
    static final String VERSION = "1.0";
    static final int IN_KEYSTORE = 1;
    static final int IN_SCOPE = 2;
    X509Certificate[] certChain;
    PrivateKey privateKey;
    KeyStore store;
    IdentityScope scope;
    String keystore;
    boolean nullStream = false;
    boolean token = false;
    String jarfile;
    String alias;
    char[] storepass;
    boolean protectedPath;
    String storetype;
    String providerName;
    Vector<String> providers = null;
    HashMap<String, String> providerArgs = new HashMap();
    char[] keypass;
    String sigfile;
    String sigalg;
    String digestalg = "SHA1";
    String signedjar;
    String tsaUrl;
    String tsaAlias;
    boolean verify = false;
    boolean verbose = false;
    boolean showcerts = false;
    boolean debug = false;
    boolean signManifest = true;
    boolean externalSF = true;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    private byte[] buffer = new byte[8192];
    private ContentSigner signingMechanism = null;
    private String altSignerClass = null;
    private String altSignerClasspath = null;
    private ZipFile zipFile = null;
    private boolean hasExpiredCert = false;
    private boolean hasExpiringCert = false;
    private boolean notYetValidCert = false;
    private boolean badKeyUsage = false;
    private boolean badExtendedKeyUsage = false;
    private boolean badNetscapeCertType = false;
    private static MessageFormat validityTimeForm;
    private static MessageFormat notYetTimeForm;
    private static MessageFormat expiredTimeForm;
    private static MessageFormat expiringTimeForm;
    private static MessageFormat signTimeForm;
    Hashtable<Certificate, String> storeHash = new Hashtable();

    static {
        collator.setStrength(0);
        PARAM_STRING = new Class[]{String.class};
        validityTimeForm = null;
        notYetTimeForm = null;
        expiredTimeForm = null;
        expiringTimeForm = null;
        signTimeForm = null;
    }

    public static void main(String[] args) throws Exception {
        JarSigner js = new JarSigner();
        js.run(args);
    }

    public void run(String[] args) {
        block20: {
            try {
                try {
                    this.parseArgs(args);
                    if (this.providers != null) {
                        ClassLoader cl = ClassLoader.getSystemClassLoader();
                        Enumeration<String> e = this.providers.elements();
                        while (e.hasMoreElements()) {
                            Object obj;
                            String provName = e.nextElement();
                            Class<?> provClass = cl != null ? cl.loadClass(provName) : Class.forName(provName);
                            String provArg = this.providerArgs.get(provName);
                            if (provArg == null) {
                                obj = provClass.newInstance();
                            } else {
                                Constructor<?> c = provClass.getConstructor(PARAM_STRING);
                                obj = c.newInstance(provArg);
                            }
                            if (!(obj instanceof Provider)) {
                                MessageFormat form = new MessageFormat(rb.getString("provName not a provider"));
                                Object[] source = new Object[]{provName};
                                throw new Exception(form.format(source));
                            }
                            Security.addProvider((Provider)obj);
                        }
                    }
                    this.hasExpiredCert = false;
                    this.hasExpiringCert = false;
                    this.notYetValidCert = false;
                    this.badKeyUsage = false;
                    this.badExtendedKeyUsage = false;
                    this.badNetscapeCertType = false;
                    if (this.verify) {
                        block19: {
                            try {
                                this.loadKeyStore(this.keystore, false);
                                this.scope = IdentityScope.getSystemScope();
                            }
                            catch (Exception e) {
                                if (this.keystore == null && this.storepass == null) break block19;
                                System.out.println(String.valueOf(rb.getString("jarsigner error: ")) + e.getMessage());
                                System.exit(1);
                            }
                        }
                        this.verifyJar(this.jarfile);
                        break block20;
                    }
                    this.loadKeyStore(this.keystore, true);
                    this.getAliasInfo(this.alias);
                    if (this.altSignerClass != null) {
                        this.signingMechanism = this.loadSigningMechanism(this.altSignerClass, this.altSignerClasspath);
                    }
                    this.signJar(this.jarfile, this.alias, args);
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(rb.getString("jarsigner error: ")) + e);
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    System.exit(1);
                    if (this.keypass != null) {
                        Arrays.fill(this.keypass, ' ');
                        this.keypass = null;
                    }
                    if (this.storepass != null) {
                        Arrays.fill(this.storepass, ' ');
                        this.storepass = null;
                    }
                }
            }
            finally {
                if (this.keypass != null) {
                    Arrays.fill(this.keypass, ' ');
                    this.keypass = null;
                }
                if (this.storepass != null) {
                    Arrays.fill(this.storepass, ' ');
                    this.storepass = null;
                }
            }
        }
    }

    void parseArgs(String[] args) {
        int n = 0;
        n = 0;
        while (n < args.length && args[n].startsWith("-")) {
            String flags = args[n];
            if (collator.compare(flags, "-keystore") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.keystore = args[n];
            } else if (collator.compare(flags, "-storepass") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.storepass = args[n].toCharArray();
            } else if (collator.compare(flags, "-storetype") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.storetype = args[n];
            } else if (collator.compare(flags, "-providerName") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.providerName = args[n];
            } else if (collator.compare(flags, "-provider") == 0 || collator.compare(flags, "-providerClass") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                if (this.providers == null) {
                    this.providers = new Vector(3);
                }
                this.providers.add(args[n]);
                if (args.length > n + 1 && collator.compare(flags = args[n + 1], "-providerArg") == 0) {
                    if (args.length == n + 2) {
                        this.usage();
                    }
                    this.providerArgs.put(args[n], args[n + 2]);
                    n += 2;
                }
            } else if (collator.compare(flags, "-protected") == 0) {
                this.protectedPath = true;
            } else if (collator.compare(flags, "-debug") == 0) {
                this.debug = true;
            } else if (collator.compare(flags, "-keypass") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.keypass = args[n].toCharArray();
            } else if (collator.compare(flags, "-sigfile") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.sigfile = args[n];
            } else if (collator.compare(flags, "-signedjar") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.signedjar = args[n];
            } else if (collator.compare(flags, "-tsa") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.tsaUrl = args[n];
            } else if (collator.compare(flags, "-tsacert") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.tsaAlias = args[n];
            } else if (collator.compare(flags, "-altsigner") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.altSignerClass = args[n];
            } else if (collator.compare(flags, "-altsignerpath") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.altSignerClasspath = args[n];
            } else if (collator.compare(flags, "-sectionsonly") == 0) {
                this.signManifest = false;
            } else if (collator.compare(flags, "-internalsf") == 0) {
                this.externalSF = false;
            } else if (collator.compare(flags, "-verify") == 0) {
                this.verify = true;
            } else if (collator.compare(flags, "-verbose") == 0) {
                this.verbose = true;
            } else if (collator.compare(flags, "-sigalg") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.sigalg = args[n];
            } else if (collator.compare(flags, "-digestalg") == 0) {
                if (++n == args.length) {
                    this.usage();
                }
                this.digestalg = args[n];
            } else if (collator.compare(flags, "-certs") == 0) {
                this.showcerts = true;
            } else if (collator.compare(flags, "-h") == 0 || collator.compare(flags, "-help") == 0) {
                this.usage();
            } else {
                System.err.println(String.valueOf(rb.getString("Illegal option: ")) + flags);
                this.usage();
            }
            ++n;
        }
        if (n == args.length) {
            this.usage();
        }
        this.jarfile = args[n++];
        if (!this.verify) {
            if (n == args.length) {
                this.usage();
            }
            this.alias = args[n++];
        }
        if (this.storetype == null) {
            this.storetype = KeyStore.getDefaultType();
        }
        this.storetype = KeyStoreUtil.niceStoreTypeName(this.storetype);
        if (P11KEYSTORE.equalsIgnoreCase(this.storetype) || KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            this.token = true;
            if (this.keystore == null) {
                this.keystore = NONE;
            }
        }
        if (NONE.equals(this.keystore)) {
            this.nullStream = true;
        }
        if (this.token && !this.nullStream) {
            System.err.println(MessageFormat.format(rb.getString("-keystore must be NONE if -storetype is {0}"), this.storetype));
            System.err.println();
            this.usage();
        }
        if (this.token && this.keypass != null) {
            System.err.println(MessageFormat.format(rb.getString("-keypass can not be specified if -storetype is {0}"), this.storetype));
            System.err.println();
            this.usage();
        }
        if (this.protectedPath && (this.storepass != null || this.keypass != null)) {
            System.err.println(rb.getString("If -protected is specified, then -storepass and -keypass must not be specified"));
            System.err.println();
            this.usage();
        }
        if (KeyStoreUtil.isWindowsKeyStore(this.storetype) && (this.storepass != null || this.keypass != null)) {
            System.err.println(rb.getString("If keystore is not password protected, then -storepass and -keypass must not be specified"));
            System.err.println();
            this.usage();
        }
    }

    void usage() {
        System.out.println(rb.getString("Usage: jarsigner [options] jar-file alias"));
        System.out.println(rb.getString("       jarsigner -verify [options] jar-file"));
        System.out.println();
        System.out.println(rb.getString("[-keystore <url>]           keystore location"));
        System.out.println();
        System.out.println(rb.getString("[-storepass <password>]     password for keystore integrity"));
        System.out.println();
        System.out.println(rb.getString("[-storetype <type>]         keystore type"));
        System.out.println();
        System.out.println(rb.getString("[-keypass <password>]       password for private key (if different)"));
        System.out.println();
        System.out.println(rb.getString("[-sigfile <file>]           name of .SF/.DSA file"));
        System.out.println();
        System.out.println(rb.getString("[-signedjar <file>]         name of signed JAR file"));
        System.out.println();
        System.out.println(rb.getString("[-digestalg <algorithm>]    name of digest algorithm"));
        System.out.println();
        System.out.println(rb.getString("[-sigalg <algorithm>]       name of signature algorithm"));
        System.out.println();
        System.out.println(rb.getString("[-verify]                   verify a signed JAR file"));
        System.out.println();
        System.out.println(rb.getString("[-verbose]                  verbose output when signing/verifying"));
        System.out.println();
        System.out.println(rb.getString("[-certs]                    display certificates when verbose and verifying"));
        System.out.println();
        System.out.println(rb.getString("[-tsa <url>]                location of the Timestamping Authority"));
        System.out.println();
        System.out.println(rb.getString("[-tsacert <alias>]          public key certificate for Timestamping Authority"));
        System.out.println();
        System.out.println(rb.getString("[-altsigner <class>]        class name of an alternative signing mechanism"));
        System.out.println();
        System.out.println(rb.getString("[-altsignerpath <pathlist>] location of an alternative signing mechanism"));
        System.out.println();
        System.out.println(rb.getString("[-internalsf]               include the .SF file inside the signature block"));
        System.out.println();
        System.out.println(rb.getString("[-sectionsonly]             don't compute hash of entire manifest"));
        System.out.println();
        System.out.println(rb.getString("[-protected]                keystore has protected authentication path"));
        System.out.println();
        System.out.println(rb.getString("[-providerName <name>]      provider name"));
        System.out.println();
        System.out.println(rb.getString("[-providerClass <class>     name of cryptographic service provider's"));
        System.out.println(rb.getString("  [-providerArg <arg>]] ... master class file and constructor argument"));
        System.out.println();
        System.exit(1);
    }

    void verifyJar(String jarName) throws Exception {
        block43: {
            boolean anySigned = false;
            boolean hasUnsignedEntry = false;
            ZipFile jf = null;
            try {
                try {
                    jf = new JarFile(jarName, true);
                    Vector<JarEntry> entriesVec = new Vector<JarEntry>();
                    byte[] buffer = new byte[8192];
                    Enumeration<JarEntry> entries = ((JarFile)jf).entries();
                    while (entries.hasMoreElements()) {
                        JarEntry je = entries.nextElement();
                        entriesVec.addElement(je);
                        try (InputStream is = null;){
                            int n;
                            is = ((JarFile)jf).getInputStream(je);
                            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                            }
                        }
                    }
                    Manifest man = ((JarFile)jf).getManifest();
                    if (man != null) {
                        if (this.verbose) {
                            System.out.println();
                        }
                        Enumeration e = entriesVec.elements();
                        long now = System.currentTimeMillis();
                        while (e.hasMoreElements()) {
                            JarEntry je = (JarEntry)e.nextElement();
                            String name = je.getName();
                            CodeSigner[] signers = je.getCodeSigners();
                            boolean isSigned = signers != null;
                            anySigned |= isSigned;
                            hasUnsignedEntry |= !je.isDirectory() && !isSigned && !this.signatureRelated(name);
                            if (this.verbose) {
                                int inStoreOrScope = this.inKeyStore(signers);
                                boolean inStore = (inStoreOrScope & 1) != 0;
                                boolean inScope = (inStoreOrScope & 2) != 0;
                                boolean inManifest = man.getAttributes(name) != null || man.getAttributes("./" + name) != null || man.getAttributes("/" + name) != null;
                                System.out.print(String.valueOf(isSigned ? rb.getString("s") : rb.getString(" ")) + (inManifest ? rb.getString("m") : rb.getString(" ")) + (inStore ? rb.getString("k") : rb.getString(" ")) + (inScope ? rb.getString("i") : rb.getString(" ")) + rb.getString("  "));
                                StringBuffer sb = new StringBuffer();
                                String s = Long.toString(je.getSize());
                                int i = 6 - s.length();
                                while (i > 0) {
                                    sb.append(' ');
                                    --i;
                                }
                                sb.append(s).append(' ').append(new Date(je.getTime()).toString());
                                sb.append(' ').append(je.getName());
                                System.out.println(sb.toString());
                                if (signers != null && this.showcerts) {
                                    String tab = rb.getString("      ");
                                    int i2 = 0;
                                    while (i2 < signers.length) {
                                        System.out.println();
                                        List<? extends Certificate> certs = signers[i2].getSignerCertPath().getCertificates();
                                        Timestamp timestamp = signers[i2].getTimestamp();
                                        if (timestamp != null) {
                                            System.out.println(this.printTimestamp(tab, timestamp));
                                        }
                                        for (Certificate certificate : certs) {
                                            System.out.println(this.printCert(tab, certificate, true, now));
                                        }
                                        ++i2;
                                    }
                                    System.out.println();
                                }
                            }
                            if (!isSigned) continue;
                            int i = 0;
                            while (i < signers.length) {
                                Certificate cert = signers[i].getSignerCertPath().getCertificates().get(0);
                                if (cert instanceof X509Certificate) {
                                    this.checkCertUsage((X509Certificate)cert, null);
                                    if (!this.showcerts) {
                                        long notAfter = ((X509Certificate)cert).getNotAfter().getTime();
                                        if (notAfter < now) {
                                            this.hasExpiredCert = true;
                                        } else if (notAfter < now + 15552000000L) {
                                            this.hasExpiringCert = true;
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                    if (this.verbose) {
                        System.out.println();
                        System.out.println(rb.getString("  s = signature was verified "));
                        System.out.println(rb.getString("  m = entry is listed in manifest"));
                        System.out.println(rb.getString("  k = at least one certificate was found in keystore"));
                        System.out.println(rb.getString("  i = at least one certificate was found in identity scope"));
                        System.out.println();
                    }
                    if (man == null) {
                        System.out.println(rb.getString("no manifest."));
                    }
                    if (!anySigned) {
                        System.out.println(rb.getString("jar is unsigned. (signatures missing or not parsable)"));
                    } else {
                        System.out.println(rb.getString("jar verified."));
                        if (hasUnsignedEntry || this.hasExpiredCert || this.hasExpiringCert || this.badKeyUsage || this.badExtendedKeyUsage || this.badNetscapeCertType || this.notYetValidCert) {
                            System.out.println();
                            System.out.println(rb.getString("Warning: "));
                            if (this.badKeyUsage) {
                                System.out.println(rb.getString("This jar contains entries whose signer certificate's KeyUsage extension doesn't allow code signing."));
                            }
                            if (this.badExtendedKeyUsage) {
                                System.out.println(rb.getString("This jar contains entries whose signer certificate's ExtendedKeyUsage extension doesn't allow code signing."));
                            }
                            if (this.badNetscapeCertType) {
                                System.out.println(rb.getString("This jar contains entries whose signer certificate's NetscapeCertType extension doesn't allow code signing."));
                            }
                            if (hasUnsignedEntry) {
                                System.out.println(rb.getString("This jar contains unsigned entries which have not been integrity-checked. "));
                            }
                            if (this.hasExpiredCert) {
                                System.out.println(rb.getString("This jar contains entries whose signer certificate has expired. "));
                            }
                            if (this.hasExpiringCert) {
                                System.out.println(rb.getString("This jar contains entries whose signer certificate will expire within six months. "));
                            }
                            if (this.notYetValidCert) {
                                System.out.println(rb.getString("This jar contains entries whose signer certificate is not yet valid. "));
                            }
                            if (!this.verbose || !this.showcerts) {
                                System.out.println();
                                System.out.println(rb.getString("Re-run with the -verbose and -certs options for more details."));
                            }
                        }
                    }
                    System.exit(0);
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(rb.getString("jarsigner: ")) + e);
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    if (jf != null) {
                        jf.close();
                    }
                    break block43;
                }
            }
            catch (Throwable throwable) {
                if (jf != null) {
                    jf.close();
                }
                throw throwable;
            }
            if (jf != null) {
                jf.close();
            }
        }
        System.exit(1);
    }

    String printCert(Certificate c) {
        return this.printCert("", c, false, 0L);
    }

    String printCert(String tab, Certificate c, boolean checkValidityPeriod, long now) {
        StringBuilder certStr = new StringBuilder();
        String space = rb.getString(" ");
        X509Certificate x509Cert = null;
        if (c instanceof X509Certificate) {
            x509Cert = (X509Certificate)c;
            certStr.append(tab).append(x509Cert.getType()).append(rb.getString(", ")).append(x509Cert.getSubjectDN().getName());
        } else {
            certStr.append(tab).append(c.getType());
        }
        String alias = this.storeHash.get(c);
        if (alias != null) {
            certStr.append(space).append(alias);
        }
        if (checkValidityPeriod && x509Cert != null) {
            Object[] source;
            certStr.append("\n").append(tab).append("[");
            Date notAfter = x509Cert.getNotAfter();
            try {
                Object[] source2;
                x509Cert.checkValidity();
                if (now == 0L) {
                    now = System.currentTimeMillis();
                }
                if (notAfter.getTime() < now + 15552000000L) {
                    this.hasExpiringCert = true;
                    if (expiringTimeForm == null) {
                        expiringTimeForm = new MessageFormat(rb.getString("certificate will expire on"));
                    }
                    source2 = new Object[]{notAfter};
                    certStr.append(expiringTimeForm.format(source2));
                } else {
                    if (validityTimeForm == null) {
                        validityTimeForm = new MessageFormat(rb.getString("certificate is valid from"));
                    }
                    source2 = new Object[]{x509Cert.getNotBefore(), notAfter};
                    certStr.append(validityTimeForm.format(source2));
                }
            }
            catch (CertificateExpiredException cee) {
                this.hasExpiredCert = true;
                if (expiredTimeForm == null) {
                    expiredTimeForm = new MessageFormat(rb.getString("certificate expired on"));
                }
                source = new Object[]{notAfter};
                certStr.append(expiredTimeForm.format(source));
            }
            catch (CertificateNotYetValidException cnyve) {
                this.notYetValidCert = true;
                if (notYetTimeForm == null) {
                    notYetTimeForm = new MessageFormat(rb.getString("certificate is not valid until"));
                }
                source = new Object[]{x509Cert.getNotBefore()};
                certStr.append(notYetTimeForm.format(source));
            }
            certStr.append("]");
            boolean[] bad = new boolean[3];
            this.checkCertUsage(x509Cert, bad);
            if (bad[0] || bad[1] || bad[2]) {
                String x = "";
                if (bad[0]) {
                    x = "KeyUsage";
                }
                if (bad[1]) {
                    if (x.length() > 0) {
                        x = String.valueOf(x) + ", ";
                    }
                    x = String.valueOf(x) + "ExtendedKeyUsage";
                }
                if (bad[2]) {
                    if (x.length() > 0) {
                        x = String.valueOf(x) + ", ";
                    }
                    x = String.valueOf(x) + "NetscapeCertType";
                }
                certStr.append("\n").append(tab).append(MessageFormat.format(rb.getString("[{0} extension does not support code signing]"), x));
            }
        }
        return certStr.toString();
    }

    private String printTimestamp(String tab, Timestamp timestamp) {
        if (signTimeForm == null) {
            signTimeForm = new MessageFormat(rb.getString("entry was signed on"));
        }
        Object[] source = new Object[]{timestamp.getTimestamp()};
        return tab + "[" + signTimeForm.format(source) + "]";
    }

    int inKeyStore(CodeSigner[] signers) {
        int result = 0;
        if (signers == null) {
            return 0;
        }
        boolean found = false;
        int i = 0;
        while (i < signers.length) {
            found = false;
            List<? extends Certificate> certs = signers[i].getSignerCertPath().getCertificates();
            for (Certificate certificate : certs) {
                Identity id;
                String alias = this.storeHash.get(certificate);
                if (alias != null) {
                    if (alias.startsWith("(")) {
                        result |= 1;
                        continue;
                    }
                    if (!alias.startsWith("[")) continue;
                    result |= 2;
                    continue;
                }
                if (this.store != null) {
                    try {
                        alias = this.store.getCertificateAlias(certificate);
                    }
                    catch (KeyStoreException keyStoreException) {
                        // empty catch block
                    }
                    if (alias != null) {
                        this.storeHash.put(certificate, "(" + alias + ")");
                        found = true;
                        result |= 1;
                    }
                }
                if (found || this.scope == null || (id = this.scope.getIdentity(certificate.getPublicKey())) == null) continue;
                result |= 2;
                this.storeHash.put(certificate, "[" + id.getName() + "]");
            }
            ++i;
        }
        return result;
    }

    void signJar(String jarName, String alias, String[] args) throws Exception {
        File signedJarFile;
        File jarFile;
        block72: {
            boolean aliasUsed = false;
            X509Certificate tsaCert = null;
            if (this.sigfile == null) {
                this.sigfile = alias;
                aliasUsed = true;
            }
            this.sigfile = this.sigfile.length() > 8 ? this.sigfile.substring(0, 8).toUpperCase() : this.sigfile.toUpperCase();
            StringBuilder tmpSigFile = new StringBuilder(this.sigfile.length());
            int j = 0;
            while (j < this.sigfile.length()) {
                int c = this.sigfile.charAt(j);
                if (!(c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 45 || c == 95)) {
                    if (aliasUsed) {
                        c = 95;
                    } else {
                        throw new RuntimeException(rb.getString("signature filename must consist of the following characters: A-Z, 0-9, _ or -"));
                    }
                }
                tmpSigFile.append((char)c);
                ++j;
            }
            this.sigfile = tmpSigFile.toString();
            String tmpJarName = this.signedjar == null ? String.valueOf(jarName) + ".sig" : this.signedjar;
            jarFile = new File(jarName);
            signedJarFile = new File(tmpJarName);
            try {
                this.zipFile = new ZipFile(jarName);
            }
            catch (IOException ioe) {
                this.error(String.valueOf(rb.getString("unable to open jar file: ")) + jarName, ioe);
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(signedJarFile);
            }
            catch (IOException ioe) {
                this.error(String.valueOf(rb.getString("unable to create: ")) + tmpJarName, ioe);
            }
            PrintStream ps = new PrintStream(fos);
            ZipOutputStream zos = new ZipOutputStream(ps);
            String sfFilename = (META_INF + this.sigfile + ".SF").toUpperCase();
            String bkFilename = (META_INF + this.sigfile + ".DSA").toUpperCase();
            Manifest manifest = new Manifest();
            Map<String, Attributes> mfEntries = manifest.getEntries();
            Attributes oldAttr = null;
            boolean mfModified = false;
            boolean mfCreated = false;
            byte[] mfRawBytes = null;
            try {
                try {
                    ZipEntry ze;
                    MessageDigest[] digests = new MessageDigest[]{MessageDigest.getInstance(this.digestalg)};
                    ZipEntry mfFile = this.getManifestFile(this.zipFile);
                    if (mfFile != null) {
                        mfRawBytes = this.getBytes(this.zipFile, mfFile);
                        manifest.read(new ByteArrayInputStream(mfRawBytes));
                        oldAttr = (Attributes)manifest.getMainAttributes().clone();
                    } else {
                        Attributes mattr = manifest.getMainAttributes();
                        mattr.putValue(Attributes.Name.MANIFEST_VERSION.toString(), VERSION);
                        String javaVendor = System.getProperty("java.vendor");
                        String jdkVersion = System.getProperty("java.version");
                        mattr.putValue("Created-By", String.valueOf(jdkVersion) + " (" + javaVendor + ")");
                        mfFile = new ZipEntry("META-INF/MANIFEST.MF");
                        mfCreated = true;
                    }
                    JarBASE64Encoder encoder = new JarBASE64Encoder();
                    Vector<ZipEntry> mfFiles = new Vector<ZipEntry>();
                    boolean wasSigned = false;
                    Enumeration<? extends ZipEntry> enum_ = this.zipFile.entries();
                    while (enum_.hasMoreElements()) {
                        ZipEntry ze2 = enum_.nextElement();
                        if (ze2.getName().startsWith(META_INF)) {
                            mfFiles.addElement(ze2);
                            if (SignatureFileVerifier.isBlockOrSF(ze2.getName().toUpperCase(Locale.ENGLISH))) {
                                wasSigned = true;
                            }
                            if (this.signatureRelated(ze2.getName())) continue;
                        }
                        if (manifest.getAttributes(ze2.getName()) != null) {
                            if (!this.updateDigests(ze2, this.zipFile, digests, encoder, manifest)) continue;
                            mfModified = true;
                            continue;
                        }
                        if (ze2.isDirectory()) continue;
                        Attributes attrs = this.getDigestAttributes(ze2, this.zipFile, digests, encoder);
                        mfEntries.put(ze2.getName(), attrs);
                        mfModified = true;
                    }
                    if (mfModified) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        manifest.write(baos);
                        if (wasSigned) {
                            byte[] newBytes = baos.toByteArray();
                            if (mfRawBytes != null && oldAttr.equals(manifest.getMainAttributes())) {
                                int oldPos;
                                int newPos = this.findHeaderEnd(newBytes);
                                if (newPos == (oldPos = this.findHeaderEnd(mfRawBytes))) {
                                    System.arraycopy(mfRawBytes, 0, newBytes, 0, oldPos);
                                } else {
                                    byte[] lastBytes = new byte[oldPos + newBytes.length - newPos];
                                    System.arraycopy(mfRawBytes, 0, lastBytes, 0, oldPos);
                                    System.arraycopy(newBytes, newPos, lastBytes, oldPos, newBytes.length - newPos);
                                    newBytes = lastBytes;
                                }
                            }
                            mfRawBytes = newBytes;
                        } else {
                            mfRawBytes = baos.toByteArray();
                        }
                    }
                    if (mfModified) {
                        mfFile = new ZipEntry("META-INF/MANIFEST.MF");
                    }
                    if (this.verbose) {
                        if (mfCreated) {
                            System.out.println(String.valueOf(rb.getString("   adding: ")) + mfFile.getName());
                        } else if (mfModified) {
                            System.out.println(String.valueOf(rb.getString(" updating: ")) + mfFile.getName());
                        }
                    }
                    zos.putNextEntry(mfFile);
                    zos.write(mfRawBytes);
                    ManifestDigester manDig = new ManifestDigester(mfRawBytes);
                    SignatureFile sf = new SignatureFile(digests, manifest, manDig, this.sigfile, this.signManifest);
                    if (this.tsaAlias != null) {
                        tsaCert = this.getTsaCert(this.tsaAlias);
                    }
                    SignatureFile.Block block = null;
                    try {
                        block = sf.generateBlock(this.privateKey, this.sigalg, this.certChain, this.externalSF, this.tsaUrl, tsaCert, this.signingMechanism, args, this.zipFile);
                    }
                    catch (SocketTimeoutException e) {
                        this.error(String.valueOf(rb.getString("unable to sign jar: ")) + rb.getString("no response from the Timestamping Authority. ") + rb.getString("When connecting from behind a firewall then an HTTP proxy may need to be specified. ") + rb.getString("Supply the following options to jarsigner: ") + "\n  -J-Dhttp.proxyHost=<hostname> " + "\n  -J-Dhttp.proxyPort=<portnumber> ", e);
                    }
                    sfFilename = sf.getMetaName();
                    bkFilename = block.getMetaName();
                    ZipEntry sfFile = new ZipEntry(sfFilename);
                    ZipEntry bkFile = new ZipEntry(bkFilename);
                    long time = System.currentTimeMillis();
                    sfFile.setTime(time);
                    bkFile.setTime(time);
                    zos.putNextEntry(sfFile);
                    sf.write(zos);
                    if (this.verbose) {
                        if (this.zipFile.getEntry(sfFilename) != null) {
                            System.out.println(String.valueOf(rb.getString(" updating: ")) + sfFilename);
                        } else {
                            System.out.println(String.valueOf(rb.getString("   adding: ")) + sfFilename);
                        }
                    }
                    if (this.verbose) {
                        if (this.tsaUrl != null || tsaCert != null) {
                            System.out.println(rb.getString("requesting a signature timestamp"));
                        }
                        if (this.tsaUrl != null) {
                            System.out.println(String.valueOf(rb.getString("TSA location: ")) + this.tsaUrl);
                        }
                        if (tsaCert != null) {
                            String certUrl = TimestampedSigner.getTimestampingUrl(tsaCert);
                            if (certUrl != null) {
                                System.out.println(String.valueOf(rb.getString("TSA location: ")) + certUrl);
                            }
                            System.out.println(String.valueOf(rb.getString("TSA certificate: ")) + this.printCert(tsaCert));
                        }
                        if (this.signingMechanism != null) {
                            System.out.println(rb.getString("using an alternative signing mechanism"));
                        }
                    }
                    zos.putNextEntry(bkFile);
                    block.write(zos);
                    if (this.verbose) {
                        if (this.zipFile.getEntry(bkFilename) != null) {
                            System.out.println(String.valueOf(rb.getString(" updating: ")) + bkFilename);
                        } else {
                            System.out.println(String.valueOf(rb.getString("   adding: ")) + bkFilename);
                        }
                    }
                    int i = 0;
                    while (i < mfFiles.size()) {
                        ze = (ZipEntry)mfFiles.elementAt(i);
                        if (!(ze.getName().equalsIgnoreCase("META-INF/MANIFEST.MF") || ze.getName().equalsIgnoreCase(sfFilename) || ze.getName().equalsIgnoreCase(bkFilename))) {
                            this.writeEntry(this.zipFile, zos, ze);
                        }
                        ++i;
                    }
                    Enumeration<? extends ZipEntry> enum_2 = this.zipFile.entries();
                    while (enum_2.hasMoreElements()) {
                        ze = enum_2.nextElement();
                        if (ze.getName().startsWith(META_INF)) continue;
                        if (this.verbose) {
                            if (manifest.getAttributes(ze.getName()) != null) {
                                System.out.println(String.valueOf(rb.getString("  signing: ")) + ze.getName());
                            } else {
                                System.out.println(String.valueOf(rb.getString("   adding: ")) + ze.getName());
                            }
                        }
                        this.writeEntry(this.zipFile, zos, ze);
                    }
                }
                catch (IOException ioe) {
                    this.error(String.valueOf(rb.getString("unable to sign jar: ")) + ioe, ioe);
                    if (this.zipFile != null) {
                        this.zipFile.close();
                        this.zipFile = null;
                    }
                    if (zos != null) {
                        zos.close();
                    }
                    break block72;
                }
            }
            catch (Throwable throwable) {
                if (this.zipFile != null) {
                    this.zipFile.close();
                    this.zipFile = null;
                }
                if (zos != null) {
                    zos.close();
                }
                throw throwable;
            }
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
            if (zos != null) {
                zos.close();
            }
        }
        if (this.signedjar == null && !signedJarFile.renameTo(jarFile)) {
            Object[] source;
            MessageFormat form;
            File origJar = new File(String.valueOf(jarName) + ".orig");
            if (jarFile.renameTo(origJar)) {
                if (signedJarFile.renameTo(jarFile)) {
                    origJar.delete();
                } else {
                    form = new MessageFormat(rb.getString("attempt to rename signedJarFile to jarFile failed"));
                    source = new Object[]{signedJarFile, jarFile};
                    this.error(form.format(source));
                }
            } else {
                form = new MessageFormat(rb.getString("attempt to rename jarFile to origJar failed"));
                source = new Object[]{jarFile, origJar};
                this.error(form.format(source));
            }
        }
        if (this.hasExpiredCert || this.hasExpiringCert || this.notYetValidCert || this.badKeyUsage || this.badExtendedKeyUsage || this.badNetscapeCertType) {
            System.out.println();
            System.out.println(rb.getString("Warning: "));
            if (this.badKeyUsage) {
                System.out.println(rb.getString("The signer certificate's KeyUsage extension doesn't allow code signing."));
            }
            if (this.badExtendedKeyUsage) {
                System.out.println(rb.getString("The signer certificate's ExtendedKeyUsage extension doesn't allow code signing."));
            }
            if (this.badNetscapeCertType) {
                System.out.println(rb.getString("The signer certificate's NetscapeCertType extension doesn't allow code signing."));
            }
            if (this.hasExpiredCert) {
                System.out.println(rb.getString("The signer certificate has expired."));
            } else if (this.hasExpiringCert) {
                System.out.println(rb.getString("The signer certificate will expire within six months."));
            } else if (this.notYetValidCert) {
                System.out.println(rb.getString("The signer certificate is not yet valid."));
            }
        }
    }

    private int findHeaderEnd(byte[] bs) {
        boolean newline = true;
        int len = bs.length;
        int i = 0;
        while (i < len) {
            switch (bs[i]) {
                case 13: {
                    if (i < len - 1 && bs[i + 1] == 10) {
                        ++i;
                    }
                }
                case 10: {
                    if (newline) {
                        return i + 1;
                    }
                    newline = true;
                    break;
                }
                default: {
                    newline = false;
                }
            }
            ++i;
        }
        return len;
    }

    private boolean signatureRelated(String name) {
        String ucName = name.toUpperCase();
        if (ucName.equals("META-INF/MANIFEST.MF") || ucName.equals(META_INF) || ucName.startsWith(SIG_PREFIX) && ucName.indexOf("/") == ucName.lastIndexOf("/")) {
            return true;
        }
        if (ucName.startsWith(META_INF) && SignatureFileVerifier.isBlockOrSF(ucName)) {
            return ucName.indexOf("/") == ucName.lastIndexOf("/");
        }
        return false;
    }

    private void writeEntry(ZipFile zf, ZipOutputStream os, ZipEntry ze) throws IOException {
        ZipEntry ze2 = new ZipEntry(ze.getName());
        ze2.setMethod(ze.getMethod());
        ze2.setTime(ze.getTime());
        ze2.setComment(ze.getComment());
        ze2.setExtra(ze.getExtra());
        if (ze.getMethod() == 0) {
            ze2.setSize(ze.getSize());
            ze2.setCrc(ze.getCrc());
        }
        os.putNextEntry(ze2);
        this.writeBytes(zf, ze, os);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void writeBytes(ZipFile zf, ZipEntry ze, ZipOutputStream os) throws IOException {
        try (InputStream is = null;){
            block7: {
                int n;
                long left;
                block6: {
                    is = zf.getInputStream(ze);
                    left = ze.getSize();
                    if (!true) break block6;
                    if (left <= 0L) return;
                    if ((n = is.read(this.buffer, 0, this.buffer.length)) == -1) break block7;
                }
                do {
                    os.write(this.buffer, 0, n);
                    left -= (long)n;
                    if (left <= 0L) return;
                } while ((n = is.read(this.buffer, 0, this.buffer.length)) != -1);
            }
            return;
        }
    }

    void loadKeyStore(String keyStoreName, boolean prompt) {
        block17: {
            if (!this.nullStream && keyStoreName == null) {
                keyStoreName = String.valueOf(System.getProperty("user.home")) + File.separator + ".keystore";
            }
            try {
                this.store = this.providerName == null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(this.storetype, this.providerName);
                if (this.token && this.storepass == null && !this.protectedPath && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
                    this.storepass = this.getPass(rb.getString("Enter Passphrase for keystore: "));
                } else if (!this.token && this.storepass == null && prompt) {
                    this.storepass = this.getPass(rb.getString("Enter Passphrase for keystore: "));
                }
                if (this.nullStream) {
                    this.store.load(null, this.storepass);
                    break block17;
                }
                keyStoreName = keyStoreName.replace(File.separatorChar, '/');
                URL url = null;
                try {
                    url = new URL(keyStoreName);
                }
                catch (MalformedURLException e) {
                    url = new File(keyStoreName).toURI().toURL();
                }
                try (InputStream is = null;){
                    is = url.openStream();
                    this.store.load(is, this.storepass);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(String.valueOf(rb.getString("keystore load: ")) + ioe.getMessage());
            }
            catch (CertificateException ce) {
                throw new RuntimeException(String.valueOf(rb.getString("certificate exception: ")) + ce.getMessage());
            }
            catch (NoSuchProviderException pe) {
                throw new RuntimeException(String.valueOf(rb.getString("keystore load: ")) + pe.getMessage());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException(String.valueOf(rb.getString("keystore load: ")) + nsae.getMessage());
            }
            catch (KeyStoreException kse) {
                throw new RuntimeException(String.valueOf(rb.getString("unable to instantiate keystore class: ")) + kse.getMessage());
            }
        }
    }

    X509Certificate getTsaCert(String alias) {
        Certificate cs = null;
        try {
            cs = this.store.getCertificate(alias);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (cs == null || !(cs instanceof X509Certificate)) {
            MessageFormat form = new MessageFormat(rb.getString("Certificate not found for: alias.  alias must reference a valid KeyStore entry containing an X.509 public key certificate for the Timestamping Authority."));
            Object[] source = new Object[]{alias, alias};
            this.error(form.format(source));
        }
        return (X509Certificate)cs;
    }

    void checkCertUsage(X509Certificate userCert, boolean[] bad) {
        boolean[] keyUsage;
        if (bad != null) {
            bad[2] = false;
            bad[1] = false;
            bad[0] = false;
        }
        if (!((keyUsage = userCert.getKeyUsage()) == null || keyUsage.length >= 1 && keyUsage[0])) {
            if (bad != null) {
                bad[0] = true;
            } else {
                this.badKeyUsage = true;
            }
        }
        try {
            List<String> xKeyUsage = userCert.getExtendedKeyUsage();
            if (xKeyUsage != null && !xKeyUsage.contains("2.5.29.37.0") && !xKeyUsage.contains("1.3.6.1.5.5.7.3.3")) {
                if (bad != null) {
                    bad[1] = true;
                } else {
                    this.badExtendedKeyUsage = true;
                }
            }
        }
        catch (CertificateParsingException xKeyUsage) {
            // empty catch block
        }
        try {
            byte[] netscapeEx = userCert.getExtensionValue("2.16.840.1.113730.1.1");
            if (netscapeEx != null) {
                DerInputStream in = new DerInputStream(netscapeEx);
                byte[] encoded = in.getOctetString();
                NetscapeCertTypeExtension extn = new NetscapeCertTypeExtension(encoded = new DerValue(encoded).getUnalignedBitString().toByteArray());
                Boolean val = (Boolean)extn.get("object_signing");
                if (!val.booleanValue()) {
                    if (bad != null) {
                        bad[2] = true;
                    } else {
                        this.badNetscapeCertType = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void getAliasInfo(String alias) {
        Key key;
        block25: {
            key = null;
            try {
                Certificate[] cs = null;
                try {
                    cs = this.store.getCertificateChain(alias);
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
                if (cs == null) {
                    MessageFormat form = new MessageFormat(rb.getString("Certificate chain not found for: alias.  alias must reference a valid KeyStore key entry containing a private key and corresponding public key certificate chain."));
                    Object[] source = new Object[]{alias, alias};
                    this.error(form.format(source));
                }
                this.certChain = new X509Certificate[cs.length];
                int i = 0;
                while (i < cs.length) {
                    if (!(cs[i] instanceof X509Certificate)) {
                        this.error(rb.getString("found non-X.509 certificate in signer's chain"));
                    }
                    this.certChain[i] = (X509Certificate)cs[i];
                    ++i;
                }
                X509Certificate userCert = (X509Certificate)this.store.getCertificate(alias);
                try {
                    userCert.checkValidity();
                    if (userCert.getNotAfter().getTime() < System.currentTimeMillis() + 15552000000L) {
                        this.hasExpiringCert = true;
                    }
                }
                catch (CertificateExpiredException cee) {
                    this.hasExpiredCert = true;
                }
                catch (CertificateNotYetValidException cnyve) {
                    this.notYetValidCert = true;
                }
                this.checkCertUsage(userCert, null);
                if (!userCert.equals(this.certChain[0])) {
                    X509Certificate[] certChainTmp = new X509Certificate[this.certChain.length];
                    certChainTmp[0] = userCert;
                    Principal issuer = userCert.getIssuerDN();
                    int i2 = 1;
                    while (i2 < this.certChain.length) {
                        int j = 0;
                        while (j < certChainTmp.length) {
                            Principal subject;
                            if (certChainTmp[j] != null && issuer.equals(subject = certChainTmp[j].getSubjectDN())) {
                                this.certChain[i2] = certChainTmp[j];
                                issuer = certChainTmp[j].getIssuerDN();
                                certChainTmp[j] = null;
                                break;
                            }
                            ++j;
                        }
                        if (j == certChainTmp.length) {
                            this.error(rb.getString("incomplete certificate chain"));
                        }
                        ++i2;
                    }
                    this.certChain = certChainTmp;
                }
                try {
                    if (!this.token && this.keypass == null) {
                        key = this.store.getKey(alias, this.storepass);
                        break block25;
                    }
                    key = this.store.getKey(alias, this.keypass);
                }
                catch (UnrecoverableKeyException e) {
                    if (this.token) {
                        throw e;
                    }
                    if (this.keypass == null) {
                        MessageFormat form = new MessageFormat(rb.getString("Enter key password for alias: "));
                        Object[] source = new Object[]{alias};
                        this.keypass = this.getPass(form.format(source));
                        key = this.store.getKey(alias, this.keypass);
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                this.error(e.getMessage());
            }
            catch (UnrecoverableKeyException e) {
                this.error(rb.getString("unable to recover key from keystore"));
            }
            catch (KeyStoreException e) {
                // empty catch block
            }
        }
        if (!(key instanceof PrivateKey)) {
            MessageFormat form = new MessageFormat(rb.getString("key associated with alias not a private key"));
            Object[] source = new Object[]{alias};
            this.error(form.format(source));
        } else {
            this.privateKey = (PrivateKey)key;
        }
    }

    void error(String message) {
        System.out.println(String.valueOf(rb.getString("jarsigner: ")) + message);
        System.exit(1);
    }

    void error(String message, Exception e) {
        System.out.println(String.valueOf(rb.getString("jarsigner: ")) + message);
        if (this.debug) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    char[] getPass(String prompt) {
        System.err.print(prompt);
        System.err.flush();
        try {
            char[] pass = Password.readPassword(System.in);
            if (pass != null) {
                return pass;
            }
            this.error(rb.getString("you must enter key password"));
        }
        catch (IOException ioe) {
            this.error(String.valueOf(rb.getString("unable to read password: ")) + ioe.getMessage());
        }
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized byte[] getBytes(ZipFile zf, ZipEntry ze) throws IOException {
        try (InputStream is = null;){
            block7: {
                int n;
                long left;
                block6: {
                    is = zf.getInputStream(ze);
                    this.baos.reset();
                    left = ze.getSize();
                    if (!true) break block6;
                    if (left <= 0L) return this.baos.toByteArray();
                    if ((n = is.read(this.buffer, 0, this.buffer.length)) == -1) break block7;
                }
                do {
                    this.baos.write(this.buffer, 0, n);
                    left -= (long)n;
                    if (left <= 0L) return this.baos.toByteArray();
                } while ((n = is.read(this.buffer, 0, this.buffer.length)) != -1);
            }
            return this.baos.toByteArray();
        }
    }

    private ZipEntry getManifestFile(ZipFile zf) {
        ZipEntry ze = zf.getEntry("META-INF/MANIFEST.MF");
        if (ze == null) {
            Enumeration<? extends ZipEntry> enum_ = zf.entries();
            while (enum_.hasMoreElements() && ze == null) {
                ze = enum_.nextElement();
                if ("META-INF/MANIFEST.MF".equalsIgnoreCase(ze.getName())) continue;
                ze = null;
            }
        }
        return ze;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String[] getDigests(ZipEntry ze, ZipFile zf, MessageDigest[] digests, BASE64Encoder encoder) throws IOException {
        int i;
        try (InputStream is = null;){
            int n;
            is = zf.getInputStream(ze);
            long left = ze.getSize();
            while (left > 0L && (n = is.read(this.buffer, 0, this.buffer.length)) != -1) {
                i = 0;
                while (i < digests.length) {
                    digests[i].update(this.buffer, 0, n);
                    ++i;
                }
                left -= (long)n;
            }
        }
        String[] base64Digests = new String[digests.length];
        i = 0;
        while (i < digests.length) {
            base64Digests[i] = encoder.encode(digests[i].digest());
            ++i;
        }
        return base64Digests;
    }

    private Attributes getDigestAttributes(ZipEntry ze, ZipFile zf, MessageDigest[] digests, BASE64Encoder encoder) throws IOException {
        String[] base64Digests = this.getDigests(ze, zf, digests, encoder);
        Attributes attrs = new Attributes();
        int i = 0;
        while (i < digests.length) {
            attrs.putValue(String.valueOf(digests[i].getAlgorithm()) + "-Digest", base64Digests[i]);
            ++i;
        }
        return attrs;
    }

    private boolean updateDigests(ZipEntry ze, ZipFile zf, MessageDigest[] digests, BASE64Encoder encoder, Manifest mf) throws IOException {
        boolean update = false;
        Attributes attrs = mf.getAttributes(ze.getName());
        String[] base64Digests = this.getDigests(ze, zf, digests, encoder);
        int i = 0;
        while (i < digests.length) {
            String name = String.valueOf(digests[i].getAlgorithm()) + "-Digest";
            String mfDigest = attrs.getValue(name);
            if (mfDigest == null && digests[i].getAlgorithm().equalsIgnoreCase("SHA")) {
                mfDigest = attrs.getValue("SHA-Digest");
            }
            if (mfDigest == null) {
                attrs.putValue(name, base64Digests[i]);
                update = true;
            } else if (!mfDigest.equalsIgnoreCase(base64Digests[i])) {
                attrs.putValue(name, base64Digests[i]);
                update = true;
            }
            ++i;
        }
        return update;
    }

    private ContentSigner loadSigningMechanism(String signerClassName, String signerClassPath) throws Exception {
        String cpString = null;
        cpString = PathList.appendPath((String)System.getProperty("env.class.path"), cpString);
        cpString = PathList.appendPath((String)System.getProperty("java.class.path"), (String)cpString);
        URL[] urls = PathList.pathToURLs((String)(cpString = PathList.appendPath((String)signerClassPath, (String)cpString)));
        URLClassLoader appClassLoader = new URLClassLoader(urls);
        Class<?> signerClass = appClassLoader.loadClass(signerClassName);
        Object signer = signerClass.newInstance();
        if (!(signer instanceof ContentSigner)) {
            MessageFormat form = new MessageFormat(rb.getString("signerClass is not a signing mechanism"));
            Object[] source = new Object[]{signerClass.getName()};
            throw new IllegalArgumentException(form.format(source));
        }
        return (ContentSigner)signer;
    }
}

