/*
 * Decompiled with CFR 0.152.
 */
package kiyut.swing.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;

public class WindowUtilities {
    private WindowUtilities() {
        throw new Error("WindowUtilities is a utility class for static methods");
    }

    public static void centerWindow(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = window.getSize();
        if (windowSize.height > screenSize.height) {
            windowSize.height = screenSize.height;
        }
        if (windowSize.width > screenSize.width) {
            windowSize.width = screenSize.width;
        }
        window.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
    }

    public static Point centerLocation(Dimension size1, Dimension size2) {
        if (size2.height > size1.height) {
            size2.height = size1.height;
        }
        if (size2.width > size1.width) {
            size2.width = size1.width;
        }
        Point p = new Point((size1.width - size2.width) / 2, (size1.height - size2.height) / 2);
        return p;
    }
}

