/*
 * Decompiled with CFR 0.152.
 */
package kiyut.swing.table.dom;

import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class AttributeTableModel
extends AbstractTableModel {
    protected String[] columnNames = new String[]{"Name", "Value"};
    protected Element element;
    protected EventListener domListener = new EventListener(){

        @Override
        public void handleEvent(Event evt) {
            AttributeTableModel.this.domNodeHandleEvent(evt);
        }
    };

    public void refresh() {
        this.fireTableDataChanged();
    }

    public void setElement(Element element) {
        if (this.element != null) {
            Element old = this.element;
            ((EventTarget)((Object)old)).removeEventListener("DOMAttrModified", this.domListener, false);
        }
        if (element == null) {
            return;
        }
        this.element = element;
        ((EventTarget)((Object)this.element)).addEventListener("DOMAttrModified", this.domListener, false);
        this.fireTableDataChanged();
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.element == null) {
            return 0;
        }
        return this.element.getAttributes().getLength();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        NamedNodeMap map = this.element.getAttributes();
        Node n = map.item(rowIndex);
        if (columnIndex == 0) {
            return n.getNodeName();
        }
        return n.getNodeValue();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    private void domNodeHandleEvent(Event evt) {
        this.fireTableDataChanged();
    }
}

