/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.xmleditor;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Element;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import kiyut.sketsa.options.CodeColoringOptions;
import kiyut.sketsa.options.CodeFormatOptions;
import kiyut.swing.text.xml.XMLContext;
import kiyut.swing.text.xml.XMLEditorKit;

public class XMLTextEditor
extends JEditorPane {
    protected UndoManager undoManager;

    public XMLTextEditor() {
        CodeColoringOptions opts = CodeColoringOptions.getInstance();
        XMLContext ctx = new XMLContext(opts.getSyntaxFontMap(), opts.getSyntaxForegroundMap());
        ctx.setTabWidth(CodeFormatOptions.getInstance().getTabWidth());
        XMLEditorKit kit = new XMLEditorKit(ctx);
        this.setEditorKitForContentType("text/xml", kit);
        this.setContentType("text/xml");
        this.setBackground(UIManager.getColor("EditorPane.background"));
        this.setEditable(true);
        this.undoManager = new UndoManager();
        UndoableEditListener undoableEditHandler = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                XMLTextEditor.this.undoManager.addEdit(evt.getEdit());
            }
        };
        this.getDocument().addUndoableEditListener(undoableEditHandler);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintComponent(g);
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.undoManager.discardAllEdits();
    }

    public void undo() {
        try {
            this.undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public void gotoLine(int line) {
        Element element = this.getDocument().getDefaultRootElement().getElement(line);
        if (element == null) {
            return;
        }
        int pos = element.getStartOffset();
        this.setCaretPosition(pos);
    }
}

