/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties.geometry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.properties.geometry.ElementGeometryProperties;
import org.w3c.dom.svg.SVGUseElement;

public class UseGeometryProperties
extends ElementGeometryProperties {
    private boolean editing;
    private JPanel attributePane;
    private JTextField hField;
    private JTextField hrefField;
    private JTextField wField;
    private JTextField xField;
    private JTextField yField;

    public UseGeometryProperties() {
        this.initComponents();
        this.initCustomComponents();
        this.editing = false;
    }

    private void initComponents() {
        this.attributePane = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.xField = new JTextField();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.yField = new JTextField();
        this.wField = new JTextField();
        this.hField = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.hrefField = new JTextField();
        this.setLayout(new BorderLayout());
        this.attributePane.setLayout(new GridBagLayout());
        jLabel2.setText("x");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.attributePane.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.attributePane.add((Component)this.xField, gridBagConstraints);
        jLabel3.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.attributePane.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("w");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.attributePane.add((Component)jLabel4, gridBagConstraints);
        jLabel5.setText("h");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.attributePane.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.attributePane.add((Component)this.yField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.attributePane.add((Component)this.wField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.attributePane.add((Component)this.hField, gridBagConstraints);
        jLabel6.setText("href");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.attributePane.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.attributePane.add((Component)this.hrefField, gridBagConstraints);
        this.add((Component)this.attributePane, "North");
    }

    private void initCustomComponents() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UseGeometryProperties.this.fieldActionPerformed(e);
            }
        };
        this.xField.addActionListener(fieldActionHandler);
        this.yField.addActionListener(fieldActionHandler);
        this.wField.addActionListener(fieldActionHandler);
        this.hField.addActionListener(fieldActionHandler);
        this.hrefField.addActionListener(fieldActionHandler);
    }

    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        SVGUseElement elt = (SVGUseElement)this.element;
        try {
            this.xField.setText(elt.getAttributeNS(null, "x"));
        }
        catch (Exception ex) {
            this.xField.setText("");
        }
        try {
            this.yField.setText(elt.getAttributeNS(null, "y"));
        }
        catch (Exception ex) {
            this.yField.setText("");
        }
        try {
            this.wField.setText(elt.getAttributeNS(null, "width"));
        }
        catch (Exception ex) {
            this.wField.setText("");
        }
        try {
            this.hField.setText(elt.getAttributeNS(null, "height"));
        }
        catch (Exception ex) {
            this.hField.setText("");
        }
        try {
            this.hrefField.setText(elt.getHref().getBaseVal());
        }
        catch (Exception ex) {
            this.hrefField.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fieldActionPerformed(ActionEvent evt) {
        SVGUseElement elt = (SVGUseElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Use attributes");
        try {
            Number number;
            String attrName = "x";
            String str = this.xField.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
            attrName = "y";
            str = this.yField.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
            attrName = "width";
            str = this.wField.getText().trim();
            if (str.length() > 0) {
                number = DataTypeUtilities.validateLength(str);
                if (number.floatValue() < 0.0f) {
                    throw new RuntimeException(bundle.getString("MSG_NegativeWidth.Text"));
                }
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "height";
            str = this.hField.getText().trim();
            if (str.length() > 0) {
                number = DataTypeUtilities.validateLength(str);
                if (number.floatValue() < 0.0f) {
                    throw new RuntimeException(bundle.getString("MSG_NegativeHeight.Text"));
                }
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            String xlinkNS = "http://www.w3.org/1999/xlink";
            str = this.hrefField.getText().trim();
            if (str.length() <= 0) {
                throw new RuntimeException(bundle.getString("MSG_HREFRequired.Text"));
            }
            elt.setAttributeNS(xlinkNS, "xlink:href", str);
        }
        catch (Exception ex) {
            this.refreshProperties();
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
        }
        if (this.canvas != null) {
            this.canvas.refresh();
        }
    }
}

