/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties.geometry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.properties.geometry.ElementGeometryProperties;
import org.w3c.dom.svg.SVGTextElement;

public class TextGeometryProperties
extends ElementGeometryProperties {
    private boolean editing;
    private JPanel attributePane;
    private JTextField xField;
    private JTextField yField;

    public TextGeometryProperties() {
        this.initComponents();
        this.initCustomComponents();
        this.editing = false;
    }

    private void initComponents() {
        this.attributePane = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.xField = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.yField = new JTextField();
        this.setLayout(new BorderLayout());
        this.attributePane.setLayout(new GridBagLayout());
        jLabel2.setText("x");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.attributePane.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.attributePane.add((Component)this.xField, gridBagConstraints);
        jLabel3.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.yField, gridBagConstraints);
        this.add((Component)this.attributePane, "First");
    }

    protected void initCustomComponents() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextGeometryProperties.this.fieldActionPerformed(e);
            }
        };
        this.xField.addActionListener(fieldActionHandler);
        this.yField.addActionListener(fieldActionHandler);
    }

    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        SVGTextElement textElement = (SVGTextElement)this.element;
        try {
            this.xField.setText(textElement.getAttributeNS(null, "x"));
        }
        catch (Exception ex) {
            this.xField.setText("");
        }
        try {
            this.yField.setText(textElement.getAttributeNS(null, "y"));
        }
        catch (Exception ex) {
            this.yField.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fieldActionPerformed(ActionEvent e) {
        SVGTextElement elt = (SVGTextElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Text geometry attributes");
        try {
            String attrName = "x";
            String str = this.xField.getText().trim();
            DataTypeUtilities.validateLengthList(str);
            if (!str.isEmpty()) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "y";
            str = this.yField.getText().trim();
            DataTypeUtilities.validateLengthList(str);
            if (!str.isEmpty()) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
        }
        catch (Exception ex) {
            this.refreshProperties();
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
        }
        if (this.canvas != null) {
            this.canvas.refresh();
        }
    }
}

