/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties;

import java.awt.BorderLayout;
import java.util.Collection;
import kiyut.sketsa.cookies.SVGEditorCookie;
import kiyut.sketsa.loaders.SVGEditorSupport;
import kiyut.sketsa.loaders.event.SVGEditorSupportEvent;
import kiyut.sketsa.loaders.event.SVGEditorSupportListenerAdapter;
import kiyut.sketsa.windows.properties.Properties;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="PropertiesTopComponent", persistenceType=0)
public final class PropertiesTopComponent
extends TopComponent {
    private Lookup.Result<SVGEditorCookie> result;
    private LookupListener editorCookieLookupListener;
    private UndoRedo undoRedo;
    private Properties propertiesPane;

    private PropertiesTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(PropertiesTopComponent.class, (String)"CTL_PropertiesTopComponent"));
        this.setToolTipText(NbBundle.getMessage(PropertiesTopComponent.class, (String)"HINT_PropertiesTopComponent"));
        this.initCustomComponents();
        this.editorCookieLookupListener = new LookupListener(){

            public void resultChanged(LookupEvent evt) {
                PropertiesTopComponent.this.editorCookieLookupListenerResultChanged(evt);
            }
        };
        SVGEditorSupport.getListenerRegistry().addListener(new SVGEditorSupportListenerAdapter(){

            @Override
            public void documentReverted(SVGEditorSupportEvent evt) {
                this.lookupListenerResultChanged(evt);
            }

            @Override
            public void documentReplaced(SVGEditorSupportEvent evt) {
                this.lookupListenerResultChanged(evt);
            }

            @Override
            public void documentClosed(SVGEditorSupportEvent evt) {
                this.lookupListenerResultChanged(evt);
            }

            private void lookupListenerResultChanged(SVGEditorSupportEvent evt) {
                TopComponent tc = evt.getTopComponent();
                if (tc != null) {
                    PropertiesTopComponent.this.editorCookieLookupListenerResultChanged(null);
                }
            }
        });
        this.result = Utilities.actionsGlobalContext().lookupResult(SVGEditorCookie.class);
        this.result.addLookupListener(this.editorCookieLookupListener);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    void writeProperties(java.util.Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
    }

    public UndoRedo getUndoRedo() {
        if (this.undoRedo == null) {
            return super.getUndoRedo();
        }
        return this.undoRedo;
    }

    private void initCustomComponents() {
        this.propertiesPane = new Properties();
        this.add("Center", this.propertiesPane);
    }

    private void editorCookieLookupListenerResultChanged(LookupEvent evt) {
        Collection c = this.result.allInstances();
        if (!c.isEmpty()) {
            SVGEditorCookie cookie = (SVGEditorCookie)c.iterator().next();
            if (cookie.isOpened()) {
                this.propertiesPane.setVectorCanvas(cookie.getVectorCanvas());
                this.undoRedo = cookie.getUndoRedo();
            } else {
                this.propertiesPane.setVectorCanvas(null);
                this.undoRedo = null;
            }
        }
    }
}

