/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DOMUtilities;
import kiyut.sketsa.windows.properties.AbstractGraphicsProperties;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGStylable;

public class MarkerProperties
extends AbstractGraphicsProperties {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.windows.properties.MarkerProperties");
    private boolean editing = false;
    private boolean refreshing = false;
    private CSSStyleDeclaration computedStyle;
    private JScrollPane jScrollPane1;
    private JPanel mainPane;
    private JRadioButton markerEndBlankRadio;
    private ButtonGroup markerEndButtonGroup;
    private JRadioButton markerEndNoneRadio;
    private JComboBox markerEndURICombo;
    private JRadioButton markerMidBlankRadio;
    private ButtonGroup markerMidButtonGroup;
    private JRadioButton markerMidNoneRadio;
    private JComboBox markerMidURICombo;
    private JRadioButton markerStartBlankRadio;
    private ButtonGroup markerStartButtonGroup;
    private JRadioButton markerStartNoneRadio;
    private JComboBox markerStartURICombo;

    public MarkerProperties() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.markerStartButtonGroup = new ButtonGroup();
        this.markerStartBlankRadio = new JRadioButton();
        this.markerMidButtonGroup = new ButtonGroup();
        this.markerMidBlankRadio = new JRadioButton();
        this.markerEndButtonGroup = new ButtonGroup();
        this.markerEndBlankRadio = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.mainPane = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.markerStartNoneRadio = new JRadioButton();
        this.markerStartURICombo = new JComboBox();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JPanel jPanel3 = new JPanel();
        this.markerMidNoneRadio = new JRadioButton();
        this.markerMidURICombo = new JComboBox();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JPanel jPanel4 = new JPanel();
        this.markerEndNoneRadio = new JRadioButton();
        this.markerEndURICombo = new JComboBox();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JPanel jPanel2 = new JPanel();
        this.markerStartButtonGroup.add(this.markerStartBlankRadio);
        this.markerMidButtonGroup.add(this.markerMidBlankRadio);
        this.markerEndButtonGroup.add(this.markerEndBlankRadio);
        this.setLayout(new BorderLayout());
        this.mainPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.mainPane.setLayout(new GridBagLayout());
        jPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_Marker-Start.text")), BorderFactory.createEmptyBorder(6, 12, 12, 12)));
        jPanel1.setLayout(new GridBagLayout());
        this.markerStartButtonGroup.add(this.markerStartNoneRadio);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel1.add((Component)this.markerStartNoneRadio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel1.add((Component)this.markerStartURICombo, gridBagConstraints);
        jLabel1.setText(bundle.getString("CTL_None.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel1.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText(bundle.getString("CTL_URI.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        jPanel1.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.mainPane.add((Component)jPanel1, gridBagConstraints);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_Marker-Mid.text")), BorderFactory.createEmptyBorder(6, 12, 12, 12)));
        jPanel3.setLayout(new GridBagLayout());
        this.markerMidButtonGroup.add(this.markerMidNoneRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.markerMidNoneRadio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel3.add((Component)this.markerMidURICombo, gridBagConstraints);
        jLabel3.setText(bundle.getString("CTL_None.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText(bundle.getString("CTL_URI.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        jPanel3.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.mainPane.add((Component)jPanel3, gridBagConstraints);
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_Marker-End.text")), BorderFactory.createEmptyBorder(6, 12, 12, 12)));
        jPanel4.setLayout(new GridBagLayout());
        this.markerEndButtonGroup.add(this.markerEndNoneRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this.markerEndNoneRadio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel4.add((Component)this.markerEndURICombo, gridBagConstraints);
        jLabel5.setText(bundle.getString("CTL_None.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel4.add((Component)jLabel5, gridBagConstraints);
        jLabel6.setText(bundle.getString("CTL_URI.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        jPanel4.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.mainPane.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPane.add((Component)jPanel2, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.mainPane);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void initCustomComponents() {
        ActionListener markerNoneActionPerformed = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarkerProperties.this.markerNoneRadioActionPerformed(evt);
            }
        };
        ItemListener markerURIComboItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MarkerProperties.this.markerURIComboItemStateChanged(e);
            }
        };
        this.markerStartNoneRadio.addActionListener(markerNoneActionPerformed);
        this.markerMidNoneRadio.addActionListener(markerNoneActionPerformed);
        this.markerEndNoneRadio.addActionListener(markerNoneActionPerformed);
        this.markerStartURICombo.addItemListener(markerURIComboItemListener);
        this.markerMidURICombo.addItemListener(markerURIComboItemListener);
        this.markerEndURICombo.addItemListener(markerURIComboItemListener);
        String prototypeDisplayValue = "none";
        this.markerStartURICombo.setPrototypeDisplayValue(prototypeDisplayValue);
        this.markerMidURICombo.setPrototypeDisplayValue(prototypeDisplayValue);
        this.markerEndURICombo.setPrototypeDisplayValue(prototypeDisplayValue);
    }

    @Override
    public void refresh() {
        if (this.editing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        this.refreshing = true;
        this.refreshURIData();
        String markerStartURI = null;
        String markerMidURI = null;
        String markerEndURI = null;
        boolean multiMarkerStartURI = false;
        boolean multiMarkerMidURI = false;
        boolean multiMarkerEndURI = false;
        for (int i = 0; i < this.selectionList.size(); ++i) {
            int indexOf;
            String str;
            SVGElement element;
            if (!(this.selectionList.get(i) instanceof SVGElement) || !((element = (SVGElement)this.selectionList.get(i)) instanceof SVGStylable)) continue;
            ViewCSS viewCSS = (ViewCSS)((Object)element.getOwnerDocument().getDocumentElement());
            this.computedStyle = viewCSS.getComputedStyle((Element)element, null);
            if (!multiMarkerStartURI) {
                try {
                    str = this.computedStyle.getPropertyValue("marker-start");
                    if (!str.equals("none")) {
                        indexOf = str.lastIndexOf("#");
                        str = str.substring(indexOf + 1, str.length() - 1);
                    }
                    if (markerStartURI == null) {
                        markerStartURI = str;
                    }
                    if (!markerStartURI.equals(str)) {
                        multiMarkerStartURI = true;
                    }
                }
                catch (DOMException dex) {
                    multiMarkerStartURI = true;
                }
            }
            if (!multiMarkerMidURI) {
                try {
                    str = this.computedStyle.getPropertyValue("marker-mid");
                    if (!str.equals("none")) {
                        indexOf = str.lastIndexOf("#");
                        str = str.substring(indexOf + 1, str.length() - 1);
                    }
                    if (markerMidURI == null) {
                        markerMidURI = str;
                    }
                    if (!markerMidURI.equals(str)) {
                        multiMarkerMidURI = true;
                    }
                }
                catch (DOMException dex) {
                    multiMarkerStartURI = true;
                }
            }
            if (multiMarkerEndURI) continue;
            try {
                str = this.computedStyle.getPropertyValue("marker-end");
                if (!str.equals("none")) {
                    indexOf = str.lastIndexOf("#");
                    str = str.substring(indexOf + 1, str.length() - 1);
                }
                if (markerEndURI == null) {
                    markerEndURI = str;
                }
                if (markerEndURI.equals(str)) continue;
                multiMarkerEndURI = true;
                continue;
            }
            catch (DOMException dex) {
                multiMarkerEndURI = true;
            }
        }
        if (multiMarkerStartURI) {
            this.markerStartBlankRadio.setSelected(true);
            this.markerStartURICombo.setSelectedIndex(-1);
        } else if (markerStartURI.equals("none")) {
            this.markerStartNoneRadio.setSelected(true);
            this.markerStartURICombo.setSelectedIndex(-1);
        } else {
            this.markerStartBlankRadio.setSelected(true);
            this.markerStartURICombo.setSelectedItem(markerStartURI);
        }
        if (multiMarkerMidURI) {
            this.markerMidBlankRadio.setSelected(true);
            this.markerMidURICombo.setSelectedIndex(-1);
        } else if (markerMidURI.equals("none")) {
            this.markerMidNoneRadio.setSelected(true);
            this.markerMidURICombo.setSelectedIndex(-1);
        } else {
            this.markerMidBlankRadio.setSelected(true);
            this.markerMidURICombo.setSelectedItem(markerMidURI);
        }
        if (multiMarkerEndURI) {
            this.markerEndBlankRadio.setSelected(true);
            this.markerEndURICombo.setSelectedIndex(-1);
        } else if (markerEndURI.equals("none")) {
            this.markerEndNoneRadio.setSelected(true);
            this.markerEndURICombo.setSelectedIndex(-1);
        } else {
            this.markerEndBlankRadio.setSelected(true);
            this.markerEndURICombo.setSelectedItem(markerEndURI);
        }
        this.refreshing = false;
    }

    private void refreshURIData() {
        DefaultComboBoxModel modelMarkerStart = (DefaultComboBoxModel)this.markerStartURICombo.getModel();
        modelMarkerStart.removeAllElements();
        DefaultComboBoxModel modelMarkerMid = (DefaultComboBoxModel)this.markerMidURICombo.getModel();
        modelMarkerMid.removeAllElements();
        DefaultComboBoxModel modelMarkerEnd = (DefaultComboBoxModel)this.markerEndURICombo.getModel();
        modelMarkerEnd.removeAllElements();
        SVGDocument doc = this.canvas.getSVGDocument();
        NodeList nodeList = doc.getElementsByTagNameNS("http://www.w3.org/2000/svg", "marker");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            SVGElement elt = (SVGElement)nodeList.item(i);
            modelMarkerStart.addElement(elt.getId());
            modelMarkerMid.addElement(elt.getId());
            modelMarkerEnd.addElement(elt.getId());
        }
    }

    private boolean allowMarker(Node node) {
        boolean allow = false;
        if (node instanceof SVGPathElement || node instanceof SVGPolygonElement || node instanceof SVGPolylineElement || node instanceof SVGLineElement) {
            allow = true;
        }
        return allow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markerNoneRadioActionPerformed(ActionEvent evt) {
        String attr;
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        JComboBox comboURI = null;
        if (evt.getSource() == this.markerStartNoneRadio) {
            attr = "marker-start";
            comboURI = this.markerStartURICombo;
        } else if (evt.getSource() == this.markerMidNoneRadio) {
            attr = "marker-mid";
            comboURI = this.markerMidURICombo;
        } else {
            attr = "marker-end";
            comboURI = this.markerEndURICombo;
        }
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change " + attr + " property to none");
        try {
            for (int i = 0; i < this.selectionList.size(); ++i) {
                Node node = (Node)this.selectionList.get(i);
                if (!this.allowMarker(node) || !(node instanceof SVGStylable)) continue;
                DOMUtilities.updateProperty((SVGStylable)node, null, attr, "none");
            }
            comboURI.setSelectedIndex(-1);
        }
        catch (DOMException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_ValueError.Title"), 0);
            this.editing = false;
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
            if (this.canvas != null) {
                this.canvas.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markerURIComboItemStateChanged(ItemEvent evt) {
        String attr;
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        JComboBox comboURI = null;
        JRadioButton blankRadio = null;
        Object source = evt.getSource();
        comboURI = (JComboBox)source;
        if (source == this.markerStartURICombo) {
            attr = "marker-start";
            blankRadio = this.markerStartBlankRadio;
        } else if (source == this.markerMidURICombo) {
            attr = "marker-mid";
            blankRadio = this.markerMidBlankRadio;
        } else if (source == this.markerEndURICombo) {
            attr = "marker-end";
            blankRadio = this.markerEndBlankRadio;
        } else {
            return;
        }
        String newUri = (String)comboURI.getSelectedItem();
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change " + attr + " URI property ");
        try {
            for (int i = 0; i < this.selectionList.size(); ++i) {
                Node node = (Node)this.selectionList.get(i);
                if (!this.allowMarker(node) || !(node instanceof SVGStylable)) continue;
                if (newUri == null) {
                    DOMUtilities.updateProperty((SVGStylable)node, null, attr, null);
                    continue;
                }
                DOMUtilities.updateProperty((SVGStylable)node, null, attr, "url(#" + newUri + ")");
            }
            blankRadio.setSelected(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_ValueError.Title"), 0);
            this.editing = false;
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
            if (this.canvas != null) {
                this.canvas.refresh();
            }
        }
    }
}

