/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.domeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AttributeEditor
extends JPanel {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    protected boolean editMode = false;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTextField nameField;
    private JCheckBox nsURICheck;
    private JComboBox nsURICombo;
    private JTextArea valueArea;

    public AttributeEditor() {
        this(false);
    }

    public AttributeEditor(boolean mode) {
        this.initComponents();
        this.nsURICombo.setSelectedIndex(-1);
        this.setEditMode(mode);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.nsURICombo = new JComboBox();
        this.nsURICheck = new JCheckBox();
        this.nameField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.valueArea = new JTextArea();
        this.setPreferredSize(new Dimension(350, 200));
        this.setLayout(new GridBagLayout());
        this.jLabel3.setText("Namespace");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel1.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.nsURICombo.setEditable(true);
        this.nsURICombo.setModel(new DefaultComboBoxModel<String>(new String[]{"http://www.w3.org/1999/xlink", "http://www.w3.org/2000/xmlns/"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.nsURICombo, gridBagConstraints);
        this.nsURICheck.setSelected(true);
        this.nsURICheck.setText("use namespace");
        this.nsURICheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AttributeEditor.this.nsURICheckItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 12, 0, 0);
        this.add((Component)this.nsURICheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.nameField, gridBagConstraints);
        this.valueArea.setLineWrap(true);
        this.valueArea.setTabSize(4);
        this.valueArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.valueArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void nsURICheckItemStateChanged(ItemEvent evt) {
        this.nsURICombo.setEnabled(this.nsURICheck.isSelected());
    }

    public void setEditMode(boolean mode) {
        this.editMode = mode;
        this.nsURICheck.setEnabled(!mode);
        this.nameField.setEnabled(!mode);
        this.nsURICombo.setEnabled(!mode && this.nsURICheck.isSelected());
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public String getNamespaceURI(boolean auto) {
        String ns = null;
        if (this.nsURICheck.isSelected()) {
            ns = this.nsURICombo.getSelectedItem().toString();
        }
        if (auto && ns == null) {
            String name = this.getAttributeName();
            if (name.startsWith("xlink:")) {
                ns = this.nsURICombo.getItemAt(0).toString();
            } else if (name.startsWith("xmlns:")) {
                ns = this.nsURICombo.getItemAt(1).toString();
            }
        }
        return ns;
    }

    public void setNamespaceURI(String ns) {
        this.nsURICombo.setSelectedItem(ns);
    }

    public boolean isNamespaceURIEnabled() {
        return this.nsURICheck.isSelected();
    }

    public void setNamespaceURIEnabled(boolean enabled) {
        this.nsURICheck.setSelected(enabled);
    }

    public String getAttributeName() {
        return this.nameField.getText().trim();
    }

    public void setAttributeName(String text) {
        this.nameField.setText(text);
    }

    public String getAttributeValue() {
        return this.valueArea.getText().trim();
    }

    public void setAttributeValue(String text) {
        this.valueArea.setText(text);
    }
}

