/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.marker;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DOMUtilities;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.util.SVGNodeFilter;
import kiyut.sketsa.windows.defs.AbstractElementProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGMarkerElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGStylable;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class MarkerProperties
extends AbstractElementProperty {
    private boolean editing;
    private boolean refreshing;
    private JPanel buttonPane;
    private JTextField heightField;
    private JTextField idField;
    private JComboBox markerUnitsCombo;
    private JComboBox orientCombo;
    private JTextField refXField;
    private JTextField refYField;
    private JTextField widthField;

    public MarkerProperties() {
        this.initComponents();
        this.initEventHandler();
        this.editing = false;
        this.refreshing = false;
    }

    private void initComponents() {
        JLabel jLabel7 = new JLabel();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.idField = new JTextField();
        this.refXField = new JTextField();
        this.refYField = new JTextField();
        this.widthField = new JTextField();
        this.heightField = new JTextField();
        JSeparator jSeparator1 = new JSeparator();
        JLabel jLabel5 = new JLabel();
        this.markerUnitsCombo = new JComboBox();
        JLabel jLabel6 = new JLabel();
        this.orientCombo = new JComboBox();
        this.buttonPane = new JPanel();
        JButton applyButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        jLabel7.setText("id");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)jLabel7, gridBagConstraints);
        jLabel1.setText("ref x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText("ref y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText("width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.idField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.refXField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.refYField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.widthField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.heightField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)jSeparator1, gridBagConstraints);
        jLabel5.setText("marker units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel5, gridBagConstraints);
        this.markerUnitsCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"strokeWidth", "userSpaceOnUse"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.markerUnitsCombo, gridBagConstraints);
        jLabel6.setText("orient");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel6, gridBagConstraints);
        this.orientCombo.setEditable(true);
        this.orientCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"auto"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.orientCombo, gridBagConstraints);
        this.buttonPane.setLayout(new GridLayout(1, 0));
        applyButton.setMnemonic('A');
        applyButton.setText("Apply");
        applyButton.setFocusPainted(false);
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarkerProperties.this.applyButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(applyButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.buttonPane, gridBagConstraints);
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.updateVectorCanvas();
    }

    private void initEventHandler() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarkerProperties.this.updateDOM();
            }
        };
        this.idField.addActionListener(fieldActionHandler);
        this.refXField.addActionListener(fieldActionHandler);
        this.refYField.addActionListener(fieldActionHandler);
        this.widthField.addActionListener(fieldActionHandler);
        this.heightField.addActionListener(fieldActionHandler);
        ItemListener itemListenerHandler = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                MarkerProperties.this.updateDOM();
            }
        };
        this.markerUnitsCombo.addItemListener(itemListenerHandler);
        this.orientCombo.addItemListener(itemListenerHandler);
    }

    @Override
    public void setSVGElement(SVGElement element) {
        super.setSVGElement(element);
        this.refreshProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        try {
            SVGMarkerElement elt = (SVGMarkerElement)this.element;
            this.idField.setText(elt.getId());
            SVGLength length = elt.getRefX().getBaseVal();
            this.refXField.setText(length.getValueAsString());
            length = elt.getRefY().getBaseVal();
            this.refYField.setText(length.getValueAsString());
            length = elt.getMarkerWidth().getBaseVal();
            this.widthField.setText(length.getValueAsString());
            length = elt.getMarkerHeight().getBaseVal();
            this.heightField.setText(length.getValueAsString());
            short s = elt.getMarkerUnits().getBaseVal();
            if (s == 2) {
                this.markerUnitsCombo.setSelectedIndex(0);
            } else if (s == 1) {
                this.markerUnitsCombo.setSelectedIndex(1);
            }
            s = elt.getOrientType().getBaseVal();
            if (s == 1) {
                this.orientCombo.setSelectedIndex(0);
            } else {
                this.orientCombo.setSelectedItem(elt.getOrientAngle().getBaseVal().getValueAsString());
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDOM() {
        if (this.refreshing) {
            return;
        }
        SVGMarkerElement elt = (SVGMarkerElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Marker properties");
        try {
            String attrName = "refX";
            String str = this.refXField.getText().trim();
            String defaultStr = "-10%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "refY";
            str = this.refYField.getText().trim();
            defaultStr = "-10%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "width";
            str = this.widthField.getText().trim();
            Number number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative width value is an error.");
            }
            defaultStr = "120%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "height";
            str = this.heightField.getText().trim();
            number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative height value is an error.");
            }
            defaultStr = "120%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "markerUnits";
            str = this.markerUnitsCombo.getSelectedItem().toString().trim();
            if (str.equalsIgnoreCase("strokeWidth")) {
                elt.removeAttributeNS(null, attrName);
            } else {
                elt.setAttributeNS(null, attrName, str);
            }
            attrName = "orient";
            str = this.orientCombo.getSelectedItem().toString().trim();
            if (str.equalsIgnoreCase("0")) {
                elt.removeAttributeNS(null, attrName);
            } else {
                elt.setAttributeNS(null, attrName, str);
            }
            String newId = this.idField.getText();
            this.updateReferenceElement(newId);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }

    public void updateVectorCanvas() {
        String newId = this.idField.getText();
        this.updateReferenceElement(newId);
        if (this.canvas != null) {
            this.canvas.refreshSelection();
            this.canvas.refresh();
        }
    }

    protected void updateReferenceElement(String newId) {
        String baseUri = this.element.getBaseURI();
        String fragment = this.element.getId();
        String newBaseUri = baseUri;
        String newFragment = newId;
        this.element.setId(newId);
        Document doc = this.element.getOwnerDocument();
        SVGFilterableNode filter = new SVGFilterableNode();
        DocumentTraversal travelsal = (DocumentTraversal)((Object)doc);
        TreeWalker treeWalker = travelsal.createTreeWalker(doc, 1, filter, false);
        if (baseUri == null) {
            baseUri = "";
        }
        if (newBaseUri == null) {
            newBaseUri = "";
        }
        this.recursiveUpdate(treeWalker, baseUri, fragment, newBaseUri, newFragment);
    }

    private void recursiveUpdate(TreeWalker treeWalker, String baseUri, String fragment, String newBaseUri, String newFragment) {
        Node n = treeWalker.getCurrentNode();
        Node child = treeWalker.firstChild();
        while (child != null) {
            Element elt = (Element)child;
            this.updateElement(elt, "marker-start", baseUri, fragment, newBaseUri, newFragment);
            this.updateElement(elt, "marker-mid", baseUri, fragment, newBaseUri, newFragment);
            this.updateElement(elt, "marker-end", baseUri, fragment, newBaseUri, newFragment);
            this.recursiveUpdate(treeWalker, baseUri, fragment, newBaseUri, newFragment);
            child = treeWalker.nextSibling();
        }
        treeWalker.setCurrentNode(n);
    }

    private void updateElement(Element element, String attr, String baseUri, String fragment, String newBaseUri, String newFragment) {
        String curUri;
        String oldUri;
        ViewCSS viewCSS = (ViewCSS)((Object)element.getOwnerDocument().getDocumentElement());
        CSSStyleDeclaration computedStyle = viewCSS.getComputedStyle(element, null);
        String value = computedStyle.getPropertyValue(attr);
        if (!value.equalsIgnoreCase("none") && !value.equalsIgnoreCase("inherit") && (oldUri = value).equalsIgnoreCase(curUri = "url(" + baseUri + "#" + fragment + ")")) {
            String newUri = "#" + newFragment;
            if (!baseUri.equals(newBaseUri)) {
                newUri = newBaseUri + newUri;
            }
            SVGStylable stylable = (SVGStylable)element;
            DOMUtilities.updateProperty(stylable, null, attr, "none");
            DOMUtilities.updateProperty(stylable, null, attr, "url(" + newUri + ")");
        }
    }

    private static class SVGFilterableNode
    extends SVGNodeFilter {
        @Override
        public short acceptNode(Node n) {
            short result = 3;
            if (n instanceof SVGPathElement) {
                result = 1;
            } else if (n instanceof SVGLineElement) {
                result = 1;
            } else if (n instanceof SVGPolygonElement) {
                result = 1;
            } else if (n instanceof SVGPolylineElement) {
                result = 1;
            }
            return result;
        }
    }
}

