/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.gradient;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.windows.defs.AbstractElementProperty;
import kiyut.sketsa.windows.defs.gradient.DefaultPreviewComponent;
import kiyut.sketsa.windows.defs.gradient.GradientStopTable;
import kiyut.sketsa.windows.defs.gradient.GradientStopTableModel;
import kiyut.sketsa.windows.defs.gradient.SVGGradientUtilities;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGGradientElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLinearGradientElement;

public class LinearGradientProperties
extends AbstractElementProperty {
    private GradientStopTable gradientStopTable;
    private DefaultPreviewComponent previewComponent;
    private boolean editing;
    private boolean refreshing;
    private JButton addGradientStopButton;
    private JPanel buttonPane;
    private JPanel gradientStopPane;
    private JScrollPane gradientStopScrollPane;
    private JComboBox gradientUnitsCombo;
    private JTextField idField;
    private JPanel previewPane;
    private JButton removeGradientStopButton;
    private JComboBox spreadMethodCombo;
    private JTextField x1Field;
    private JTextField x2Field;
    private JTextField y1Field;
    private JTextField y2Field;

    public LinearGradientProperties() {
        this.initComponents();
        this.gradientStopTable = new GradientStopTable();
        this.gradientStopScrollPane.setViewportView(this.gradientStopTable);
        this.previewComponent = new DefaultPreviewComponent();
        this.previewPane.add((Component)this.previewComponent, "Center");
        this.initEventHandler();
        this.editing = false;
        this.refreshing = false;
    }

    private void initEventHandler() {
        TableModel model = this.gradientStopTable.getModel();
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                LinearGradientProperties.this.gradientStopTableChanged(evt);
            }
        });
        ActionListener gradientStopButtonActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearGradientProperties.this.gradientStopButtonActionPerformed(evt);
            }
        };
        this.addGradientStopButton.setActionCommand("add");
        this.addGradientStopButton.addActionListener(gradientStopButtonActionHandler);
        this.removeGradientStopButton.setActionCommand("remove");
        this.removeGradientStopButton.addActionListener(gradientStopButtonActionHandler);
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearGradientProperties.this.fieldActionPerformed(evt);
            }
        };
        this.idField.addActionListener(fieldActionHandler);
        this.x1Field.addActionListener(fieldActionHandler);
        this.y1Field.addActionListener(fieldActionHandler);
        this.x2Field.addActionListener(fieldActionHandler);
        this.y2Field.addActionListener(fieldActionHandler);
        this.gradientUnitsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LinearGradientProperties.this.gradientUnitsComboItemStateChanged(evt);
            }
        });
        this.spreadMethodCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LinearGradientProperties.this.spreadMethodComboItemStateChanged(evt);
            }
        });
    }

    private void initComponents() {
        JLabel jLabel7 = new JLabel();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.idField = new JTextField();
        this.x1Field = new JTextField();
        this.y1Field = new JTextField();
        this.x2Field = new JTextField();
        this.y2Field = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.gradientUnitsCombo = new JComboBox();
        JLabel jLabel6 = new JLabel();
        this.spreadMethodCombo = new JComboBox();
        this.gradientStopPane = new JPanel();
        this.gradientStopScrollPane = new JScrollPane();
        JToolBar jToolBar1 = new JToolBar();
        this.addGradientStopButton = new JButton();
        this.removeGradientStopButton = new JButton();
        this.previewPane = new JPanel();
        JSeparator jSeparator1 = new JSeparator();
        this.buttonPane = new JPanel();
        JButton applyButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        jLabel7.setText("id");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)jLabel7, gridBagConstraints);
        jLabel1.setText("x1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText("y1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText("x2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("y2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.idField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.x1Field, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.y1Field, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.x2Field, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.y2Field, gridBagConstraints);
        jLabel5.setText("gradient units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)jLabel5, gridBagConstraints);
        this.gradientUnitsCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"objectBoundingBox", "userSpaceOnUse"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.gradientUnitsCombo, gridBagConstraints);
        jLabel6.setText("spread method");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)jLabel6, gridBagConstraints);
        this.spreadMethodCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"pad", "reflect", "repeat"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.spreadMethodCombo, gridBagConstraints);
        this.gradientStopPane.setPreferredSize(new Dimension(75, 75));
        this.gradientStopPane.setLayout(new BorderLayout());
        this.gradientStopPane.add((Component)this.gradientStopScrollPane, "Center");
        jToolBar1.setFloatable(false);
        jToolBar1.setOrientation(1);
        jToolBar1.setRollover(true);
        this.addGradientStopButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/defs/gradient/plus.png")));
        this.addGradientStopButton.setFocusPainted(false);
        this.addGradientStopButton.setMargin(new Insets(1, 1, 1, 1));
        jToolBar1.add(this.addGradientStopButton);
        this.removeGradientStopButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/defs/gradient/minus.png")));
        this.removeGradientStopButton.setFocusPainted(false);
        this.removeGradientStopButton.setMargin(new Insets(1, 1, 1, 1));
        jToolBar1.add(this.removeGradientStopButton);
        this.gradientStopPane.add((Component)jToolBar1, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.gradientStopPane, gridBagConstraints);
        this.previewPane.setBackground(new Color(255, 255, 255));
        this.previewPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Separator.shadow")));
        this.previewPane.setMinimumSize(new Dimension(50, 50));
        this.previewPane.setPreferredSize(new Dimension(50, 50));
        this.previewPane.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.previewPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)jSeparator1, gridBagConstraints);
        this.buttonPane.setLayout(new GridLayout(1, 0));
        applyButton.setMnemonic('A');
        applyButton.setText("Apply");
        applyButton.setFocusPainted(false);
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearGradientProperties.this.applyButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(applyButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.buttonPane, gridBagConstraints);
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.updateVectorCanvas();
    }

    @Override
    public void setSVGElement(SVGElement element) {
        super.setSVGElement(element);
        this.refreshProperties();
        this.updatePreview();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        try {
            SVGLinearGradientElement elt = (SVGLinearGradientElement)this.element;
            this.idField.setText(elt.getId());
            SVGLength length = elt.getX1().getBaseVal();
            this.x1Field.setText(length.getValueAsString());
            length = elt.getY1().getBaseVal();
            this.y1Field.setText(length.getValueAsString());
            length = elt.getX2().getBaseVal();
            this.x2Field.setText(length.getValueAsString());
            length = elt.getY2().getBaseVal();
            this.y2Field.setText(length.getValueAsString());
            short s = elt.getGradientUnits().getBaseVal();
            if (s == 2) {
                this.gradientUnitsCombo.setSelectedIndex(0);
            } else if (s == 1) {
                this.gradientUnitsCombo.setSelectedIndex(1);
            }
            s = elt.getSpreadMethod().getBaseVal();
            if (s == 1) {
                this.spreadMethodCombo.setSelectedIndex(0);
            } else if (s == 2) {
                this.spreadMethodCombo.setSelectedIndex(1);
            } else if (s == 3) {
                this.spreadMethodCombo.setSelectedIndex(2);
            }
            this.gradientStopTable.setGradientElement((SVGGradientElement)this.element);
        }
        finally {
            this.refreshing = false;
        }
    }

    public void updateVectorCanvas() {
        String newId = this.idField.getText();
        this.updateReferenceElement(newId);
        if (this.canvas != null) {
            this.canvas.refreshSelection();
            this.canvas.refresh();
        }
    }

    public void updatePreview() {
        if (!this.isVisible()) {
            return;
        }
        GradientStopTableModel model = (GradientStopTableModel)this.gradientStopTable.getModel();
        float largest = 0.0f;
        float[] fractions = new float[model.getRowCount()];
        Color[] colors = new Color[model.getRowCount()];
        for (int i = 0; i < model.getRowCount(); ++i) {
            float f;
            String str = (String)model.getValueAt(i, 0);
            if (str.endsWith("%")) {
                f = Float.parseFloat(str.substring(0, str.length() - 1));
                f /= 100.0f;
            } else {
                f = Float.parseFloat(str);
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f < largest) {
                f = largest;
            }
            largest = Math.max(f, largest);
            fractions[i] = f;
            colors[i] = (Color)model.getValueAt(i, 1);
        }
        this.previewComponent.setType(1);
        this.previewComponent.setFractions(fractions);
        this.previewComponent.setColors(colors);
        this.previewComponent.repaint();
    }

    protected void updateReferenceElement(String newId) {
        SVGGradientUtilities.updateReferenceElement(this.element, newId);
    }

    private void gradientStopTableChanged(TableModelEvent evt) {
        this.updatePreview();
    }

    private void gradientStopButtonActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("add")) {
            GradientStopTableModel model = (GradientStopTableModel)this.gradientStopTable.getModel();
            model.newRow();
        } else if (evt.getActionCommand().equalsIgnoreCase("remove")) {
            int index = this.gradientStopTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            GradientStopTableModel model = (GradientStopTableModel)this.gradientStopTable.getModel();
            model.removeRow(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fieldActionPerformed(ActionEvent evt) {
        SVGLinearGradientElement elt = (SVGLinearGradientElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Linear Gradient attributes");
        try {
            SVGLength length = elt.getX1().getBaseVal();
            length.setValueAsString(this.x1Field.getText());
            length = elt.getY1().getBaseVal();
            length.setValueAsString(this.y1Field.getText());
            length = elt.getX2().getBaseVal();
            length.setValueAsString(this.x2Field.getText());
            length = elt.getY2().getBaseVal();
            length.setValueAsString(this.y2Field.getText());
            String newId = this.idField.getText();
            this.updateReferenceElement(newId);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gradientUnitsComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Gradient units attributes");
        try {
            String str = (String)this.gradientUnitsCombo.getSelectedItem();
            short unitType = 2;
            if (str.equalsIgnoreCase("userSpaceOnUse")) {
                unitType = 1;
            }
            SVGLinearGradientElement elt = (SVGLinearGradientElement)this.element;
            elt.getGradientUnits().setBaseVal(unitType);
            String newId = this.idField.getText();
            this.updateReferenceElement(newId);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spreadMethodComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Gradient Spread Method attributes");
        try {
            String str = (String)this.spreadMethodCombo.getSelectedItem();
            short unitType = 1;
            if (str.equalsIgnoreCase("reflect")) {
                unitType = 2;
            } else if (str.equalsIgnoreCase("repeat")) {
                unitType = 3;
            }
            SVGLinearGradientElement elt = (SVGLinearGradientElement)this.element;
            elt.getSpreadMethod().setBaseVal(unitType);
            String newId = this.idField.getText();
            this.updateReferenceElement(newId);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }
}

