/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.gradient;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class DefaultPreviewComponent
extends JPanel {
    public static final int TYPE_LINEAR_GRADIENT = 1;
    public static final int TYPE_RADIAL_GRADIENT = 2;
    protected Paint paint;
    protected int type;
    protected Color[] colors;
    private float[] fractions;

    public DefaultPreviewComponent() {
        this.setOpaque(false);
        this.type = 1;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.colors == null || this.fractions == null) {
            return;
        }
        if (this.colors.length == 0) {
            return;
        }
        Rectangle bounds = this.getBounds();
        if (this.colors.length == 1) {
            this.paint = this.colors[0];
        } else if (this.type == 1) {
            this.paint = new LinearGradientPaint(0.0f, 0.0f, (float)((int)bounds.getWidth()), 0.0f, this.fractions, this.colors);
        } else if (this.type == 2) {
            double cx = 0.0 + bounds.getWidth() / 2.0;
            double cy = 0.0 + bounds.getHeight() / 2.0;
            double r = bounds.getWidth() / 2.0;
            this.paint = new RadialGradientPaint((float)cx, (float)cy, (float)r, this.fractions, this.colors);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, bounds.getWidth(), bounds.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(this.paint);
        g2d.fill(rect);
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setFractions(float[] fractions) {
        this.fractions = new float[fractions.length];
        System.arraycopy(fractions, 0, this.fractions, 0, fractions.length);
    }

    public void setColors(Color[] colors) {
        this.colors = new Color[colors.length];
        System.arraycopy(colors, 0, this.colors, 0, colors.length);
    }

    public void setType(int type) {
        this.type = type;
    }
}

