/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.filter.primitive;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.windows.defs.filter.primitive.AbstractFilterPrimitiveProperty;
import org.w3c.dom.svg.SVGFEMergeNodeElement;

public class FEMergeNodeProperty
extends AbstractFilterPrimitiveProperty {
    private boolean editing = false;
    private boolean refreshing = false;
    private JPanel fillerPane;
    private JComboBox inCombo;

    public FEMergeNodeProperty() {
        this.initComponents();
        this.initEventHandler();
    }

    private void initComponents() {
        JLabel jLabel6 = new JLabel();
        this.inCombo = new JComboBox();
        this.fillerPane = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new GridBagLayout());
        jLabel6.setText("in");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)jLabel6, gridBagConstraints);
        this.inCombo.setEditable(true);
        this.inCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"SourceGraphic", "SourceAlpha", "BackgroundImage", "BackgroundAlpha", "FillPaint", "StrokePaint"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.inCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPane, gridBagConstraints);
    }

    private void initEventHandler() {
        ItemListener itemListenerHandler = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                FEMergeNodeProperty.this.updateDOM();
            }
        };
        this.inCombo.addItemListener(itemListenerHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        try {
            SVGFEMergeNodeElement elt = (SVGFEMergeNodeElement)this.element;
            String str = elt.getIn1().getBaseVal();
            this.inCombo.setSelectedItem(str);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDOM() {
        if (this.refreshing) {
            return;
        }
        SVGFEMergeNodeElement elt = (SVGFEMergeNodeElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change feMergeNode properties");
        try {
            String attrName = "in";
            String str = this.inCombo.getSelectedItem().toString().trim();
            if (str.length() > 0) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }
}

