/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.filter.primitive;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.defs.filter.primitive.AbstractFilterPrimitiveProperty;
import org.w3c.dom.svg.SVGFEDistantLightElement;

public class FEDistantLightProperty
extends AbstractFilterPrimitiveProperty {
    private boolean editing = false;
    private boolean refreshing = false;
    protected JTextField azimuthField;
    protected JTextField elevationField;
    private JPanel fillerPane;

    public FEDistantLightProperty() {
        this.initComponents();
        this.initEventHandler();
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.azimuthField = new JTextField();
        this.elevationField = new JTextField();
        this.fillerPane = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new GridBagLayout());
        jLabel1.setText("azimuth");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText("elevation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.azimuthField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.elevationField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPane, gridBagConstraints);
    }

    private void initEventHandler() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FEDistantLightProperty.this.fieldActionPerformed(e);
            }
        };
        this.azimuthField.addActionListener(fieldActionHandler);
        this.elevationField.addActionListener(fieldActionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        try {
            SVGFEDistantLightElement elt = (SVGFEDistantLightElement)this.element;
            float f = elt.getAzimuth().getBaseVal();
            this.azimuthField.setText(Float.toString(f));
            f = elt.getElevation().getBaseVal();
            this.elevationField.setText(Float.toString(f));
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fieldActionPerformed(ActionEvent e) {
        if (this.refreshing) {
            return;
        }
        SVGFEDistantLightElement elt = (SVGFEDistantLightElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change feDistantLight properties");
        try {
            String attrName = "azimuth";
            String str = this.azimuthField.getText().trim();
            Number number = DataTypeUtilities.validateNumber(str);
            String defaultStr = "0";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "elevation";
            str = this.elevationField.getText().trim();
            number = DataTypeUtilities.validateNumber(str);
            defaultStr = "0";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }
}

