/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.filter.primitive;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.defs.filter.primitive.AbstractFilterPrimitiveProperty;
import kiyut.swing.dialog.DialogESC;
import org.w3c.dom.svg.SVGFEConvolveMatrixElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGNumberList;

public class FEConvolveMatrixProperty
extends AbstractFilterPrimitiveProperty {
    private boolean editing = false;
    private boolean refreshing = false;
    private JDialog kernelDialog;
    private JTextField biasField;
    private JButton cancelButton;
    private JTextField divisorField;
    private JComboBox edgeModeCombo;
    private JPanel fillerPane;
    protected JTextField hField;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JButton kernelButton;
    private JPanel kernelPane;
    private JPanel matrixPane;
    private JTable matrixTable;
    private JButton okButton;
    private JTextField orderXField;
    private JTextField orderYField;
    private JComboBox preserveAlphaCombo;
    protected JTextField resultField;
    private JTextField targetXField;
    private JTextField targetYField;
    private JTextField unitLengthXField;
    private JTextField unitLengthYField;
    protected JTextField wField;
    protected JTextField xField;
    protected JTextField yField;

    public FEConvolveMatrixProperty() {
        this.initComponents();
        this.initEventHandler();
    }

    private void initComponents() {
        this.kernelPane = new JPanel();
        JLabel jLabel9 = new JLabel();
        this.divisorField = new JTextField();
        JLabel jLabel10 = new JLabel();
        this.biasField = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.unitLengthXField = new JTextField();
        JLabel jLabel15 = new JLabel();
        this.unitLengthYField = new JTextField();
        this.matrixPane = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.matrixTable = new JTable();
        JLabel jLabel13 = new JLabel();
        this.orderXField = new JTextField();
        JLabel jLabel14 = new JLabel();
        this.orderYField = new JTextField();
        JLabel jLabel11 = new JLabel();
        this.targetXField = new JTextField();
        JLabel jLabel12 = new JLabel();
        this.targetYField = new JTextField();
        this.jPanel2 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.resultField = new JTextField();
        this.hField = new JTextField();
        this.wField = new JTextField();
        this.yField = new JTextField();
        this.xField = new JTextField();
        this.jPanel1 = new JPanel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        this.edgeModeCombo = new JComboBox();
        this.preserveAlphaCombo = new JComboBox();
        this.kernelButton = new JButton();
        this.fillerPane = new JPanel();
        this.kernelPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.kernelPane.setLayout(new GridBagLayout());
        jLabel9.setText("divisor");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.kernelPane.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.kernelPane.add((Component)this.divisorField, gridBagConstraints);
        jLabel10.setText("bias");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.kernelPane.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.kernelPane.add((Component)this.biasField, gridBagConstraints);
        jLabel6.setText("unit lengthX");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.kernelPane.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.kernelPane.add((Component)this.unitLengthXField, gridBagConstraints);
        jLabel15.setText("unit lengthY");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.kernelPane.add((Component)jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.kernelPane.add((Component)this.unitLengthYField, gridBagConstraints);
        this.matrixPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Matrix"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.matrixPane.setLayout(new GridBagLayout());
        this.matrixTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"", "", ""}){
            Class[] types;
            {
                this.types = new Class[]{Float.class, Float.class, Float.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.matrixTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.matrixPane.add((Component)this.jScrollPane1, gridBagConstraints);
        jLabel13.setText("orderX");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.matrixPane.add((Component)jLabel13, gridBagConstraints);
        this.orderXField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        this.matrixPane.add((Component)this.orderXField, gridBagConstraints);
        jLabel14.setText("orderY");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.matrixPane.add((Component)jLabel14, gridBagConstraints);
        this.orderYField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        this.matrixPane.add((Component)this.orderYField, gridBagConstraints);
        jLabel11.setText("targetX");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.matrixPane.add((Component)jLabel11, gridBagConstraints);
        this.targetXField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        this.matrixPane.add((Component)this.targetXField, gridBagConstraints);
        jLabel12.setText("targetY");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.matrixPane.add((Component)jLabel12, gridBagConstraints);
        this.targetYField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        this.matrixPane.add((Component)this.targetYField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.kernelPane.add((Component)this.matrixPane, gridBagConstraints);
        this.okButton.setText("  Ok  ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FEConvolveMatrixProperty.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FEConvolveMatrixProperty.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.kernelPane.add((Component)this.jPanel2, gridBagConstraints);
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new GridBagLayout());
        jLabel1.setText("x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText("width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel4, gridBagConstraints);
        jLabel5.setText("result");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.resultField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.hField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.wField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.yField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.xField, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Convolution"), BorderFactory.createEmptyBorder(0, 6, 6, 6)));
        this.jPanel1.setLayout(new GridBagLayout());
        jLabel7.setText("Edge Mode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 5);
        this.jPanel1.add((Component)jLabel7, gridBagConstraints);
        jLabel8.setText("Preserve Alpha");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.jPanel1.add((Component)jLabel8, gridBagConstraints);
        this.edgeModeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"duplicate", "wrap", "none"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.edgeModeCombo, gridBagConstraints);
        this.preserveAlphaCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"false", "true"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.preserveAlphaCombo, gridBagConstraints);
        this.kernelButton.setText("Configure Kernel Matrix");
        this.kernelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FEConvolveMatrixProperty.this.kernelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.kernelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPane, gridBagConstraints);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.updateDOMKernel();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.kernelDialog.dispose();
        this.kernelDialog = null;
    }

    private void kernelButtonActionPerformed(ActionEvent evt) {
        this.kernelDialog = DialogESC.createDialog(this, "Kernel Matrix", true);
        this.kernelDialog.setDefaultCloseOperation(2);
        this.kernelDialog.setContentPane(this.kernelPane);
        this.kernelDialog.pack();
        this.kernelDialog.setVisible(true);
    }

    private void initEventHandler() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FEConvolveMatrixProperty.this.updateDOMField();
            }
        };
        this.xField.addActionListener(fieldActionHandler);
        this.yField.addActionListener(fieldActionHandler);
        this.wField.addActionListener(fieldActionHandler);
        this.hField.addActionListener(fieldActionHandler);
        this.resultField.addActionListener(fieldActionHandler);
        ItemListener itemListenerHandler = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                FEConvolveMatrixProperty.this.updateDOMConvolution();
            }
        };
        this.edgeModeCombo.addItemListener(itemListenerHandler);
        this.preserveAlphaCombo.addItemListener(itemListenerHandler);
        ActionListener orderActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FEConvolveMatrixProperty.this.updateDOMOrder();
            }
        };
        this.orderXField.addActionListener(orderActionHandler);
        this.orderYField.addActionListener(orderActionHandler);
    }

    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        try {
            String item;
            int i;
            SVGFEConvolveMatrixElement elt = (SVGFEConvolveMatrixElement)this.element;
            SVGLength length = elt.getX().getBaseVal();
            this.xField.setText(length.getValueAsString());
            length = elt.getY().getBaseVal();
            this.yField.setText(length.getValueAsString());
            length = elt.getWidth().getBaseVal();
            this.wField.setText(length.getValueAsString());
            length = elt.getHeight().getBaseVal();
            this.hField.setText(length.getValueAsString());
            String str = elt.getResult().getBaseVal();
            this.resultField.setText(str);
            str = elt.getAttributeNS(null, "edgeMode");
            for (i = 0; i < this.edgeModeCombo.getItemCount(); ++i) {
                item = this.edgeModeCombo.getItemAt(i).toString();
                if (!str.equalsIgnoreCase(item)) continue;
                this.edgeModeCombo.setSelectedIndex(i);
            }
            str = Boolean.toString(elt.getPreserveAlpha().getBaseVal());
            for (i = 0; i < this.preserveAlphaCombo.getItemCount(); ++i) {
                item = this.preserveAlphaCombo.getItemAt(i).toString();
                if (!str.equalsIgnoreCase(item)) continue;
                this.preserveAlphaCombo.setSelectedIndex(i);
            }
            float f = elt.getDivisor().getBaseVal();
            this.divisorField.setText(Float.toString(f));
            f = elt.getBias().getBaseVal();
            this.biasField.setText(Float.toString(f));
            str = elt.getAttributeNS(null, "kernelUnitLength").trim();
            if (str.equalsIgnoreCase("")) {
                Number[] numbers = new Number[]{new Float(0.0f), new Float(0.0f)};
            }
            Number[] numbers = DataTypeUtilities.validateNumberOptional(str);
            this.unitLengthXField.setText(numbers[0].toString());
            this.unitLengthYField.setText(numbers[1].toString());
            f = elt.getTargetX().getBaseVal();
            this.targetXField.setText(Integer.toString((int)f));
            f = elt.getTargetY().getBaseVal();
            this.targetYField.setText(Float.toString((int)f));
            str = elt.getAttributeNS(null, "order").trim();
            if (str.equalsIgnoreCase("")) {
                numbers = new Number[]{new Float(0.0f), new Float(0.0f)};
            }
            numbers = DataTypeUtilities.validateNumberOptional(str);
            this.orderXField.setText(numbers[0].toString());
            this.orderYField.setText(numbers[1].toString());
            DefaultTableModel model = (DefaultTableModel)this.matrixTable.getModel();
            model.setColumnCount(numbers[0].intValue());
            model.setRowCount(numbers[1].intValue());
            SVGNumberList numberList = elt.getKernelMatrix().getBaseVal();
            int index = 0;
            for (int row = 0; row < model.getRowCount(); ++row) {
                for (int col = 0; col < model.getColumnCount(); ++col) {
                    f = index < numberList.getNumberOfItems() ? numberList.getItem(index).getValue() : 1.0f;
                    model.setValueAt(new Float(f), row, col);
                    ++index;
                }
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDOMKernel() {
        if (this.refreshing) {
            return;
        }
        boolean failed = true;
        SVGFEConvolveMatrixElement elt = (SVGFEConvolveMatrixElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change feConvolveMatrix properties");
        try {
            String attrName = "divisor";
            String str = this.divisorField.getText().trim();
            Number number = DataTypeUtilities.validateNumber(str);
            if (number.floatValue() == 0.0f) {
                throw new RuntimeException("A divisor 0 value is an error.");
            }
            elt.setAttributeNS(null, attrName, str);
            attrName = "bias";
            str = this.biasField.getText().trim();
            number = DataTypeUtilities.validateNumber(str);
            String defaultStr = "0";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "kernelUnitLength";
            str = this.unitLengthXField.getText().trim() + " " + this.unitLengthYField.getText().trim();
            Number[] numbers = DataTypeUtilities.validateNumberOptional(str);
            float f1 = numbers[0].floatValue();
            float f2 = numbers[1].floatValue();
            if (f1 <= 0.0f) {
                throw new RuntimeException("A negative or zero unit length X value is an error.");
            }
            if (f2 <= 0.0f) {
                throw new RuntimeException("A negative or zero unit length Y value is an error.");
            }
            if (f1 != f2) {
                elt.setAttributeNS(null, attrName, Float.toString(f1) + " " + Float.toString(f2));
            } else if (f1 == f2 && f1 != 1.0f) {
                elt.setAttributeNS(null, attrName, Float.toString(f1));
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "targetX";
            str = this.targetXField.getText().trim();
            if (str.length() > 0) {
                number = DataTypeUtilities.validateInteger(str);
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "targetY";
            str = this.targetYField.getText().trim();
            if (str.length() > 0) {
                number = DataTypeUtilities.validateInteger(str);
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "order";
            str = this.orderXField.getText().trim() + " " + this.orderYField.getText().trim();
            numbers = DataTypeUtilities.validateNumberOptional(str);
            f1 = numbers[0].floatValue();
            f2 = numbers[1].floatValue();
            if (f1 <= 0.0f) {
                throw new RuntimeException("A negative or zero order X value is an error.");
            }
            if (f2 <= 0.0f) {
                throw new RuntimeException("A negative or zero order Y value is an error.");
            }
            if (f1 != f2) {
                elt.setAttributeNS(null, attrName, Float.toString(f1) + " " + Float.toString(f2));
            } else if (f1 == f2 && f1 != 3.0f) {
                elt.setAttributeNS(null, attrName, Float.toString(f1));
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "kernelMatrix";
            DefaultTableModel model = (DefaultTableModel)this.matrixTable.getModel();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < model.getRowCount(); ++i) {
                for (int j = 0; j < model.getColumnCount(); ++j) {
                    sb.append(model.getValueAt(i, j)).append(" ");
                }
            }
            elt.setAttributeNS(null, attrName, sb.toString());
            failed = false;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
            failed = true;
        }
        finally {
            undoManager.end();
            this.editing = false;
        }
        if (!failed) {
            this.cancelButtonActionPerformed(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDOMField() {
        if (this.refreshing) {
            return;
        }
        SVGFEConvolveMatrixElement elt = (SVGFEConvolveMatrixElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change feConvolveMatrix properties");
        try {
            String attrName = "x";
            String str = this.xField.getText().trim();
            String defaultStr = "0%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "y";
            str = this.yField.getText().trim();
            defaultStr = "0%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "width";
            str = this.wField.getText().trim();
            Number number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative width value is an error.");
            }
            defaultStr = "100%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "height";
            str = this.hField.getText().trim();
            number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative height value is an error.");
            }
            defaultStr = "100%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "result";
            str = this.resultField.getText().trim();
            if (str.length() > 0) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDOMConvolution() {
        if (this.refreshing) {
            return;
        }
        SVGFEConvolveMatrixElement elt = (SVGFEConvolveMatrixElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change feConvolveMatrix properties");
        try {
            String attrName = "edgeMode";
            String str = this.edgeModeCombo.getSelectedItem().toString().trim();
            elt.setAttributeNS(null, attrName, str);
            attrName = "preserveAlpha";
            str = this.preserveAlphaCombo.getSelectedItem().toString().trim();
            if (str.equalsIgnoreCase("true")) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDOMOrder() {
        if (this.refreshing) {
            return;
        }
        SVGFEConvolveMatrixElement elt = (SVGFEConvolveMatrixElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change feConvolveMatrix properties");
        try {
            String attrName = "order";
            String str = this.orderXField.getText().trim() + " " + this.orderYField.getText().trim();
            Number[] numbers = DataTypeUtilities.validateNumberOptional(str);
            float f1 = numbers[0].floatValue();
            float f2 = numbers[1].floatValue();
            if (f1 <= 0.0f) {
                throw new RuntimeException("A negative or zero order X value is an error.");
            }
            if (f2 <= 0.0f) {
                throw new RuntimeException("A negative or zero order Y value is an error.");
            }
            if (f1 != f2) {
                elt.setAttributeNS(null, attrName, Float.toString(f1) + " " + Float.toString(f2));
            } else if (f1 == f2 && f1 != 3.0f) {
                elt.setAttributeNS(null, attrName, Float.toString(f1));
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            DefaultTableModel model = (DefaultTableModel)this.matrixTable.getModel();
            model.setColumnCount(numbers[0].intValue());
            model.setRowCount(numbers[1].intValue());
            for (int i = 0; i < model.getRowCount(); ++i) {
                int j = 0;
                while (j < model.getColumnCount()) {
                    if (model.getValueAt(i, j) == null) {
                        model.setValueAt(new Float(1.0f), i, j);
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
        }
    }
}

