/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.filter.primitive;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.defs.filter.primitive.AbstractFilterPrimitiveProperty;
import org.w3c.dom.svg.SVGComponentTransferFunctionElement;

public class FEComponentTransferFunctionProperty
extends AbstractFilterPrimitiveProperty {
    private boolean editing = false;
    private boolean refreshing = false;
    protected JTextField amplitudeField;
    protected JTextField exponentField;
    private JPanel fillerPane;
    protected JTextField interceptField;
    private JTextField offsetField;
    protected JTextField slopeField;
    protected JTextField tableField;
    private JComboBox typeCombo;

    public FEComponentTransferFunctionProperty() {
        this.initComponents();
        this.initEventHandler();
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.typeCombo = new JComboBox();
        JLabel jLabel2 = new JLabel();
        this.tableField = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.slopeField = new JTextField();
        JLabel jLabel4 = new JLabel();
        this.interceptField = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.amplitudeField = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.exponentField = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.offsetField = new JTextField();
        this.fillerPane = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new GridBagLayout());
        jLabel1.setText("type");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)jLabel1, gridBagConstraints);
        this.typeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"identity", "table", "discrete", "linear", "gamma"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.typeCombo, gridBagConstraints);
        jLabel2.setText("table");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.tableField, gridBagConstraints);
        jLabel3.setText("slope");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.slopeField, gridBagConstraints);
        jLabel4.setText("intercept");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.interceptField, gridBagConstraints);
        jLabel6.setText("amplitude");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.amplitudeField, gridBagConstraints);
        jLabel5.setText("exponent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.exponentField, gridBagConstraints);
        jLabel7.setText("offset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.offsetField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPane, gridBagConstraints);
    }

    private void initEventHandler() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FEComponentTransferFunctionProperty.this.updateDOM();
            }
        };
        this.tableField.addActionListener(fieldActionHandler);
        this.slopeField.addActionListener(fieldActionHandler);
        this.interceptField.addActionListener(fieldActionHandler);
        this.amplitudeField.addActionListener(fieldActionHandler);
        this.exponentField.addActionListener(fieldActionHandler);
        this.offsetField.addActionListener(fieldActionHandler);
        ItemListener itemListenerHandler = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                FEComponentTransferFunctionProperty.this.updateDOM();
            }
        };
        this.typeCombo.addItemListener(itemListenerHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        try {
            SVGComponentTransferFunctionElement elt = (SVGComponentTransferFunctionElement)this.element;
            String str = elt.getAttributeNS(null, "type");
            for (int i = 0; i < this.typeCombo.getItemCount(); ++i) {
                String item = this.typeCombo.getItemAt(i).toString();
                if (!str.equalsIgnoreCase(item)) continue;
                this.typeCombo.setSelectedIndex(i);
            }
            str = elt.getAttributeNS(null, "tableValues");
            this.tableField.setText(str.trim());
            float f = elt.getSlope().getBaseVal();
            this.slopeField.setText(Float.toString(f));
            f = elt.getIntercept().getBaseVal();
            this.interceptField.setText(Float.toString(f));
            f = elt.getAmplitude().getBaseVal();
            this.amplitudeField.setText(Float.toString(f));
            f = elt.getExponent().getBaseVal();
            this.exponentField.setText(Float.toString(f));
            f = elt.getOffset().getBaseVal();
            this.offsetField.setText(Float.toString(f));
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDOM() {
        if (this.refreshing) {
            return;
        }
        SVGComponentTransferFunctionElement elt = (SVGComponentTransferFunctionElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change feComponentTransferFunction properties");
        try {
            String attrName = "type";
            String str = this.typeCombo.getSelectedItem().toString().trim();
            elt.setAttributeNS(null, attrName, str);
            attrName = "tableValues";
            str = this.tableField.getText().trim();
            if (str.length() > 0) {
                DataTypeUtilities.validateNumberList(str);
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "slope";
            str = this.slopeField.getText().trim();
            DataTypeUtilities.validateNumber(str);
            String defaultStr = "1";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "intercept";
            str = this.interceptField.getText().trim();
            DataTypeUtilities.validateNumber(str);
            defaultStr = "0";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "amplitude";
            str = this.amplitudeField.getText().trim();
            DataTypeUtilities.validateNumber(str);
            defaultStr = "1";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "exponent";
            str = this.exponentField.getText().trim();
            DataTypeUtilities.validateNumber(str);
            defaultStr = "1";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "offset";
            str = this.offsetField.getText().trim();
            DataTypeUtilities.validateNumber(str);
            defaultStr = "0";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }
}

