/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.windows.defs.filter.FilterTree;
import kiyut.sketsa.windows.defs.filter.primitive.FEBlendProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEComponentTransferFunctionProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEComponentTransferProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FECompositeProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEDiffuseLightingProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEDisplacementMapProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEDistantLightProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEFloodProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEGaussianBlurProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEMergeNodeProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEMergeProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEMorphologyProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEOffsetProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FEPointLightProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FESpecularLightingProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FESpotLightProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FETileProperty;
import kiyut.sketsa.windows.defs.filter.primitive.FETurbulenceProperty;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGComponentTransferFunctionElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGFEBlendElement;
import org.w3c.dom.svg.SVGFEComponentTransferElement;
import org.w3c.dom.svg.SVGFECompositeElement;
import org.w3c.dom.svg.SVGFEDiffuseLightingElement;
import org.w3c.dom.svg.SVGFEDisplacementMapElement;
import org.w3c.dom.svg.SVGFEDistantLightElement;
import org.w3c.dom.svg.SVGFEFloodElement;
import org.w3c.dom.svg.SVGFEGaussianBlurElement;
import org.w3c.dom.svg.SVGFEMergeElement;
import org.w3c.dom.svg.SVGFEMergeNodeElement;
import org.w3c.dom.svg.SVGFEMorphologyElement;
import org.w3c.dom.svg.SVGFEOffsetElement;
import org.w3c.dom.svg.SVGFEPointLightElement;
import org.w3c.dom.svg.SVGFESpecularLightingElement;
import org.w3c.dom.svg.SVGFESpotLightElement;
import org.w3c.dom.svg.SVGFETileElement;
import org.w3c.dom.svg.SVGFETurbulenceElement;
import org.w3c.dom.svg.SVGFilterElement;

public class FilterEditor
extends JPanel {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.windows.defs.filter.FilterEditor");
    private static final String ADD_ACTION = "add";
    private static final String REMOVE_ACTION = "remove";
    private static final String MOVE_UP_ACTION = "moveUp";
    private static final String MOVE_DOWN_ACTION = "moveDown";
    private VectorCanvas canvas;
    private FilterTree filterTree;
    private JPanel emptyPane = new JPanel();
    private JPopupMenu popupMenu;
    private JMenu lightSourceMenu;
    private JMenu mergeMenu;
    private JMenu transferFunctionMenu;
    private JButton addButton;
    private JToolBar buttonBar;
    private JScrollPane detailPane;
    private JScrollPane filterTreeScrollPane;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeButton;
    private JSplitPane splitPaneHor;
    private JPanel treePane;

    public FilterEditor() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.splitPaneHor = new JSplitPane();
        this.treePane = new JPanel();
        this.filterTreeScrollPane = new JScrollPane();
        this.buttonBar = new JToolBar();
        this.addButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.removeButton = new JButton();
        this.detailPane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.splitPaneHor.setDividerLocation(150);
        this.treePane.setLayout(new BorderLayout());
        this.treePane.add((Component)this.filterTreeScrollPane, "Center");
        this.buttonBar.setFloatable(false);
        this.buttonBar.setRollover(true);
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/actions/new.png")));
        this.addButton.setToolTipText(bundle.getString("CTL_Add.Tooltip"));
        this.addButton.setFocusPainted(false);
        this.addButton.setFocusable(false);
        this.buttonBar.add(this.addButton);
        this.moveUpButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/domeditor/up.png")));
        this.moveUpButton.setToolTipText(bundle.getString("CTL_MoveUp.Tooltip"));
        this.moveUpButton.setFocusPainted(false);
        this.moveUpButton.setFocusable(false);
        this.buttonBar.add(this.moveUpButton);
        this.moveDownButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/domeditor/down.png")));
        this.moveDownButton.setToolTipText(bundle.getString("CTL_MoveDown.Tooltip"));
        this.moveDownButton.setFocusPainted(false);
        this.moveDownButton.setFocusable(false);
        this.buttonBar.add(this.moveDownButton);
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/domeditor/delete.png")));
        this.removeButton.setToolTipText(bundle.getString("CTL_Remove.Tooltip"));
        this.removeButton.setFocusPainted(false);
        this.removeButton.setFocusable(false);
        this.buttonBar.add(this.removeButton);
        this.treePane.add((Component)this.buttonBar, "South");
        this.splitPaneHor.setLeftComponent(this.treePane);
        this.detailPane.setBorder(null);
        this.splitPaneHor.setRightComponent(this.detailPane);
        this.add((Component)this.splitPaneHor, "Center");
    }

    private void initCustomComponents() {
        this.filterTree = new FilterTree();
        this.filterTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FilterEditor.this.filterTreeValueChanged(e);
            }
        });
        this.filterTreeScrollPane.setViewportView(this.filterTree);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterEditor.this.buttonActionPerformed(e);
            }
        };
        this.addButton.setActionCommand(ADD_ACTION);
        this.addButton.addActionListener(actionListener);
        this.removeButton.setActionCommand(REMOVE_ACTION);
        this.removeButton.addActionListener(actionListener);
        this.moveUpButton.setActionCommand(MOVE_UP_ACTION);
        this.moveUpButton.addActionListener(actionListener);
        this.moveDownButton.setActionCommand(MOVE_DOWN_ACTION);
        this.moveDownButton.addActionListener(actionListener);
        this.popupMenu = new JPopupMenu();
        JMenu menu = new JMenu("Filter Primitive");
        this.popupMenu.add(menu);
        String str = "feBlend";
        JMenuItem menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feComponentTransfer";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feComposite";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feDiffuseLighting";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feDisplacementMap";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feFlood";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feGaussianBlur";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feMerge";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feMorphology";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feOffset";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feSpecularLighting";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feTile";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feTurbulence";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        menu = new JMenu("Light Source");
        this.popupMenu.add(menu);
        this.lightSourceMenu = menu;
        str = "feDistantLight";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "fePointLight";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feSpotLight";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        menu = new JMenu("Merge");
        this.popupMenu.add(menu);
        this.mergeMenu = menu;
        str = "feMergeNode";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        menu = new JMenu("Transfer Function");
        this.popupMenu.add(menu);
        this.transferFunctionMenu = menu;
        str = "feFuncR";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feFuncG";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feFuncB";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        str = "feFuncA";
        menuItem = new JMenuItem(str);
        menuItem.setActionCommand(str);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
    }

    public void setSVGFilterElement(VectorCanvas canvas, SVGFilterElement element) {
        this.canvas = canvas;
        this.filterTree.setSVGFilterElement(canvas, element);
    }

    private void filterTreeValueChanged(TreeSelectionEvent e) {
        int div = this.splitPaneHor.getDividerLocation();
        if (this.filterTree.getSelectionCount() != 0) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
            Node domNode = (Node)treeNode.getUserObject();
            if (domNode instanceof SVGFEBlendElement) {
                FEBlendProperty primitivePane = new FEBlendProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFEComponentTransferElement) {
                FEComponentTransferProperty primitivePane = new FEComponentTransferProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFECompositeElement) {
                FECompositeProperty primitivePane = new FECompositeProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFEDiffuseLightingElement) {
                FEDiffuseLightingProperty primitivePane = new FEDiffuseLightingProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFEDisplacementMapElement) {
                FEDisplacementMapProperty primitivePane = new FEDisplacementMapProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFEFloodElement) {
                FEFloodProperty primitivePane = new FEFloodProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFEGaussianBlurElement) {
                FEGaussianBlurProperty primitivePane = new FEGaussianBlurProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFEMergeElement) {
                FEMergeProperty primitivePane = new FEMergeProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFEMorphologyElement) {
                FEMorphologyProperty primitivePane = new FEMorphologyProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFEOffsetElement) {
                FEOffsetProperty primitivePane = new FEOffsetProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFESpecularLightingElement) {
                FESpecularLightingProperty primitivePane = new FESpecularLightingProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFETileElement) {
                FETileProperty primitivePane = new FETileProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFETurbulenceElement) {
                FETurbulenceProperty primitivePane = new FETurbulenceProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFEDistantLightElement) {
                FEDistantLightProperty primitivePane = new FEDistantLightProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFEPointLightElement) {
                FEPointLightProperty primitivePane = new FEPointLightProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFESpotLightElement) {
                FESpotLightProperty primitivePane = new FESpotLightProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGFEMergeNodeElement) {
                FEMergeNodeProperty primitivePane = new FEMergeNodeProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else if (domNode instanceof SVGComponentTransferFunctionElement) {
                FEComponentTransferFunctionProperty primitivePane = new FEComponentTransferFunctionProperty();
                primitivePane.setSVGElement(this.canvas, (SVGElement)domNode);
                this.detailPane.setViewportView(primitivePane);
            } else {
                this.detailPane.setViewportView(this.emptyPane);
            }
        } else {
            this.detailPane.setViewportView(this.emptyPane);
        }
        this.splitPaneHor.setDividerLocation(div);
    }

    private void buttonActionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(ADD_ACTION)) {
            this.lightSourceMenu.setEnabled(false);
            this.mergeMenu.setEnabled(false);
            this.transferFunctionMenu.setEnabled(false);
            Object obj = this.filterTree.getLastSelectedPathComponent();
            if (obj != null) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
                Node domNode = (Node)treeNode.getUserObject();
                if (domNode instanceof SVGFEDiffuseLightingElement || domNode instanceof SVGFESpecularLightingElement) {
                    this.lightSourceMenu.setEnabled(true);
                } else if (domNode instanceof SVGFEMergeElement) {
                    this.mergeMenu.setEnabled(true);
                } else if (domNode instanceof SVGFEComponentTransferElement) {
                    this.transferFunctionMenu.setEnabled(true);
                }
            }
            JComponent comp = (JComponent)e.getSource();
            this.popupMenu.show(comp, comp.getX(), comp.getY());
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase(REMOVE_ACTION)) {
            Object obj = this.filterTree.getLastSelectedPathComponent();
            if (obj == null) {
                JOptionPane.showMessageDialog(this, bundle.getString("MSG_NothingSelected.Text"), bundle.getString("MSG_Exception.Title"), 0);
                return;
            }
            int result = JOptionPane.showConfirmDialog(this, bundle.getString("MSG_ConfirmRemove.Text"), bundle.getString("MSG_Exception.Title"), 0);
            if (result == 0) {
                this.filterTree.removeSelected();
            }
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase(MOVE_UP_ACTION)) {
            Object obj = this.filterTree.getLastSelectedPathComponent();
            if (obj == null) {
                JOptionPane.showMessageDialog(this, bundle.getString("MSG_NothingSelected.Text"), bundle.getString("MSG_Exception.Title"), 0);
                return;
            }
            this.filterTree.moveSelectedUp();
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase(MOVE_DOWN_ACTION)) {
            Object obj = this.filterTree.getLastSelectedPathComponent();
            if (obj == null) {
                JOptionPane.showMessageDialog(this, bundle.getString("MSG_NothingSelected.Text"), bundle.getString("MSG_Exception.Title"), 0);
                return;
            }
            this.filterTree.moveSelectedDown();
            return;
        }
        if (e.getActionCommand().startsWith("fe")) {
            this.filterTree.add(e.getActionCommand(), true);
            return;
        }
    }
}

