/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.canvas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Collection;
import javax.swing.JDialog;
import kiyut.sketsa.cookies.SVGEditorCookie;
import kiyut.sketsa.loaders.SVGEditorSupport;
import kiyut.sketsa.loaders.event.SVGEditorSupportEvent;
import kiyut.sketsa.loaders.event.SVGEditorSupportListenerAdapter;
import kiyut.sketsa.windows.canvas.DefaultNavigator;
import kiyut.sketsa.windows.canvas.Navigator;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class NavigatorManager {
    private static NavigatorManager instance;
    private Lookup.Result<SVGEditorCookie> result;
    private LookupListener editorCookieLookupListener;
    private Navigator navigator = new DefaultNavigator();
    private JDialog dialog;

    public static synchronized NavigatorManager getInstance() {
        if (instance == null) {
            instance = new NavigatorManager();
        }
        return instance;
    }

    private NavigatorManager() {
        this.editorCookieLookupListener = new LookupListener(){

            public void resultChanged(LookupEvent evt) {
                NavigatorManager.this.editorCookieLookupListenerResultChanged(evt);
            }
        };
        SVGEditorSupport.getListenerRegistry().addListener(new SVGEditorSupportListenerAdapter(){

            @Override
            public void documentReverted(SVGEditorSupportEvent evt) {
                this.lookupListenerResultChanged(evt);
            }

            @Override
            public void documentReplaced(SVGEditorSupportEvent evt) {
                this.lookupListenerResultChanged(evt);
            }

            @Override
            public void documentClosed(SVGEditorSupportEvent evt) {
                this.lookupListenerResultChanged(evt);
            }

            private void lookupListenerResultChanged(SVGEditorSupportEvent evt) {
                TopComponent tc = evt.getTopComponent();
                if (tc != null) {
                    NavigatorManager.this.editorCookieLookupListenerResultChanged(null);
                }
            }
        });
        this.result = Utilities.actionsGlobalContext().lookupResult(SVGEditorCookie.class);
        this.result.addLookupListener(this.editorCookieLookupListener);
    }

    private void editorCookieLookupListenerResultChanged(LookupEvent evt) {
        Collection c = this.result.allInstances();
        if (!c.isEmpty()) {
            SVGEditorCookie cookie = (SVGEditorCookie)c.iterator().next();
            if (cookie.isOpened()) {
                this.navigator.setVectorCanvas(cookie.getVectorCanvas(), cookie.getVectorCanvasTopComponent().getViewport());
                this.navigator.refresh();
            } else {
                this.navigator.setVectorCanvas(null, null);
                this.navigator.refresh();
            }
        }
    }

    public void openNavigator() {
        if (this.dialog == null) {
            Frame mainFrame = WindowManager.getDefault().getMainWindow();
            this.dialog = new JDialog(mainFrame, NbBundle.getMessage(NavigatorManager.class, (String)"CTL_Navigator"));
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.navigator, "Center");
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(mainFrame);
        }
        this.dialog.setVisible(true);
        this.editorCookieLookupListenerResultChanged(null);
    }
}

