/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.canvas;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputAdapter;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.util.GeomUtilities;
import kiyut.sketsa.windows.canvas.Navigator;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.Overlay;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

public class DefaultNavigator
extends Navigator {
    protected VectorCanvas canvas;
    protected JViewport viewport;
    protected SVGDocument doc;
    protected JGVTComponent navigator;
    protected NavigatorOverlay overlay;
    protected boolean inProgress;
    protected EventListener domListener;
    protected ComponentListener canvasComponentListener;
    protected AdjustmentListener adjustmentListener;

    public DefaultNavigator() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.setLayout(new BorderLayout());
    }

    protected void initCustomComponents() {
        this.navigator = new JGVTComponent();
        this.navigator.setPreferredSize(new Dimension(200, 200));
        this.add((Component)this.navigator, "Center");
        this.overlay = new NavigatorOverlay();
        this.navigator.getOverlays().add(this.overlay);
        this.inProgress = false;
        NavigatorMouseListener mouseListener = new NavigatorMouseListener();
        this.navigator.addMouseListener((MouseListener)mouseListener);
        this.navigator.addMouseMotionListener((MouseMotionListener)mouseListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DefaultNavigator.this.refresh();
            }
        });
        this.canvasComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DefaultNavigator.this.refresh();
            }
        };
        this.adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                if (DefaultNavigator.this.inProgress) {
                    return;
                }
                DefaultNavigator.this.overlay.updateAOI();
                DefaultNavigator.this.repaint();
            }
        };
        this.domListener = new EventListener(){

            @Override
            public void handleEvent(Event evt) {
                DefaultNavigator.this.refresh();
            }
        };
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas, JViewport viewport) {
        JScrollPane scrollPane;
        EventTarget et;
        VectorCanvas oldCanvas = this.canvas;
        SVGDocument oldDoc = this.doc;
        JViewport oldViewport = this.viewport;
        this.canvas = canvas;
        this.viewport = viewport;
        boolean removeOld = true;
        if (this.canvas != null) {
            if (!this.canvas.equals(oldCanvas)) {
                canvas.addComponentListener(this.canvasComponentListener);
            } else {
                removeOld = false;
            }
            this.doc = canvas.getSVGDocument();
        }
        if (removeOld && oldCanvas != null) {
            oldCanvas.removeComponentListener(this.canvasComponentListener);
        }
        removeOld = true;
        if (this.doc != null) {
            if (!this.doc.equals(oldDoc)) {
                et = (EventTarget)((Object)this.doc.getDocumentElement());
                et.addEventListener("DOMSubtreeModified", this.domListener, false);
            } else {
                removeOld = false;
            }
        } else {
            this.navigator.setGraphicsNode(null);
        }
        if (removeOld && oldDoc != null) {
            et = (EventTarget)((Object)oldDoc.getDocumentElement());
            et.removeEventListener("DOMSubtreeModified", this.domListener, false);
        }
        if (this.viewport != null) {
            if (!this.viewport.equals(oldViewport)) {
                scrollPane = (JScrollPane)viewport.getParent();
                scrollPane.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
                scrollPane.getHorizontalScrollBar().addAdjustmentListener(this.adjustmentListener);
            } else {
                removeOld = false;
            }
        }
        if (removeOld && oldViewport != null) {
            scrollPane = (JScrollPane)oldViewport.getParent();
            scrollPane.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
            scrollPane.getHorizontalScrollBar().removeAdjustmentListener(this.adjustmentListener);
        }
    }

    @Override
    public void refresh() {
        if (this.inProgress) {
            return;
        }
        if (this.canvas == null) {
            this.navigator.setGraphicsNode(null);
            this.navigator.resetRenderingTransform();
            try {
                this.navigator.flush();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.navigator.immediateRepaint();
            this.repaint();
            return;
        }
        this.navigator.setGraphicsNode(this.canvas.getModel().getRoot());
        Dimension dimSrc = new Dimension((int)this.canvas.getModel().getSVGWidth(), (int)this.canvas.getModel().getSVGHeight());
        Dimension dimDest = this.navigator.getSize();
        double scale = GeomUtilities.scaleToFit(dimSrc, dimDest);
        AffineTransform at = AffineTransform.getScaleInstance(scale, scale);
        Rectangle2D rect = new Rectangle2D.Double(0.0, 0.0, dimSrc.getWidth(), dimSrc.getHeight());
        rect = at.createTransformedShape(rect).getBounds2D();
        double tx = (dimDest.getWidth() - rect.getWidth()) / 2.0;
        double ty = (dimDest.getHeight() - rect.getHeight()) / 2.0;
        at.preConcatenate(AffineTransform.getTranslateInstance(tx, ty));
        this.navigator.setRenderingTransform(at);
        this.overlay.updateAOI();
        this.repaint();
    }

    protected class NavigatorMouseListener
    extends MouseInputAdapter {
        protected int x;
        protected int y;
        protected int tx;
        protected int ty;
        protected boolean in;
        protected AffineTransform invAt = null;

        protected NavigatorMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (!DefaultNavigator.this.overlay.isDragable()) {
                return;
            }
            this.x = evt.getX();
            this.y = evt.getY();
            this.in = DefaultNavigator.this.overlay.contains(this.x, this.y);
            this.invAt = null;
            AffineTransform at = DefaultNavigator.this.navigator.getRenderingTransform();
            try {
                at.concatenate(DefaultNavigator.this.canvas.getTransform(true).createInverse());
                this.invAt = at.createInverse();
            }
            catch (Exception ex) {
                this.invAt = null;
            }
            DefaultNavigator.this.inProgress = true;
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (!DefaultNavigator.this.overlay.isDragable()) {
                return;
            }
            if (!this.in) {
                return;
            }
            this.tx = evt.getX() - this.x;
            this.ty = evt.getY() - this.y;
            this.updateView(true);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (!DefaultNavigator.this.overlay.isDragable()) {
                return;
            }
            if (!this.in) {
                return;
            }
            this.in = false;
            DefaultNavigator.this.overlay.updateAOI();
            this.invAt = null;
            DefaultNavigator.this.inProgress = false;
        }

        private void updateView(boolean resynch) {
            AffineTransform paintingTransform = DefaultNavigator.this.overlay.moveBy(this.tx, this.ty);
            DefaultNavigator.this.navigator.repaint();
            if (!resynch) {
                return;
            }
            if (this.invAt == null) {
                return;
            }
            Rectangle2D bounds = DefaultNavigator.this.overlay.getBounds();
            Point2D pt = new Point2D.Double(bounds.getX(), bounds.getY());
            pt = paintingTransform.transform(pt, pt);
            pt = this.invAt.transform(pt, pt);
            DefaultNavigator.this.viewport.setViewPosition(new Point((int)pt.getX(), (int)pt.getY()));
        }
    }

    protected class NavigatorOverlay
    implements Overlay {
        protected Shape shape;
        protected AffineTransform paintingTransform;
        protected boolean dragable = false;
        protected Rectangle maxRect;

        protected NavigatorOverlay() {
        }

        public void paint(Graphics g) {
            if (this.shape == null) {
                return;
            }
            if (DefaultNavigator.this.canvas == null) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.transform(this.paintingTransform);
            Paint strokePaint = DefaultNavigator.this.canvas.getCanvasSelection().getStrokePaint();
            g2d.setPaint(strokePaint);
            g2d.draw(this.shape);
            if (strokePaint instanceof Color) {
                Color color = (Color)strokePaint;
                Color fillPaint = new Color(color.getRed(), color.getGreen(), color.getBlue(), 75);
                g2d.setPaint(fillPaint);
                g2d.fill(this.shape);
            }
        }

        public boolean contains(int x, int y) {
            if (this.shape == null) {
                return false;
            }
            Shape tShape = this.paintingTransform.createTransformedShape(this.shape);
            return tShape.contains(x, y);
        }

        public Rectangle2D getBounds() {
            return this.shape.getBounds2D();
        }

        public AffineTransform moveBy(double tx, double ty) {
            this.paintingTransform = AffineTransform.getTranslateInstance(tx, ty);
            Rectangle2D sBounds = this.shape.getBounds2D();
            Rectangle2D tBounds = this.paintingTransform.createTransformedShape(this.shape).getBounds2D();
            boolean over = false;
            if (tBounds.getX() < 0.0) {
                tx = 0.0 - sBounds.getX();
                over = true;
            }
            if (tBounds.getY() < 0.0) {
                ty = 0.0 - sBounds.getY();
                over = true;
            }
            if (tBounds.getMaxX() > this.maxRect.getMaxX()) {
                tx = this.maxRect.getMaxX() - sBounds.getMaxX();
                over = true;
            }
            if (tBounds.getMaxY() > this.maxRect.getMaxY()) {
                ty = this.maxRect.getMaxX() - sBounds.getMaxY();
                over = true;
            }
            if (over) {
                this.paintingTransform = AffineTransform.getTranslateInstance(tx, ty);
            }
            return this.paintingTransform;
        }

        public void updateAOI() {
            this.paintingTransform = new AffineTransform();
            Dimension dim = DefaultNavigator.this.navigator.getSize();
            this.maxRect = new Rectangle(0, 0, dim.width, dim.height);
            AffineTransform at = DefaultNavigator.this.navigator.getRenderingTransform();
            try {
                at.concatenate(DefaultNavigator.this.canvas.getTransform(true).createInverse());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.shape = DefaultNavigator.this.viewport.getViewRect();
                this.shape = at.createTransformedShape(this.shape);
                if (this.maxRect.contains(this.shape.getBounds())) {
                    this.dragable = true;
                } else {
                    this.dragable = false;
                    this.shape = this.maxRect;
                }
            }
            catch (Exception ex) {
                this.dragable = false;
                this.shape = this.maxRect;
            }
        }

        public boolean isDragable() {
            return this.dragable;
        }
    }
}

